/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.block;

import com.github.tartaricacid.touhoulittlemaid.client.gui.block.ModelSwitcherModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.DirectButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ImageButtonWithId;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SaveSwitcherDataMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ModelSwitcherGui
extends Screen {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/model_switcher.png");
    private static final ResourceLocation DEFAULT_MODEL_ID = new ResourceLocation("touhou_little_maid:hakurei_reimu");
    private final List<TileEntityModelSwitcher.ModeInfo> infoList;
    private final BlockPos pos;
    private final int maxRow = 6;
    private final UUID bindUuid;
    protected int imageWidth = 256;
    protected int imageHeight = 166;
    protected int leftPos;
    protected int topPos;
    private EntityMaid maid = null;
    private TextFieldWidget description;
    private int selectedIndex = -1;
    private int page;

    public ModelSwitcherGui(TileEntityModelSwitcher switcher) {
        super((ITextComponent)new StringTextComponent("Model Switcher GUI"));
        this.infoList = switcher.getInfoList();
        this.pos = switcher.func_174877_v();
        this.bindUuid = switcher.getUuid();
        if (Minecraft.func_71410_x().field_71441_e != null) {
            this.maid = new EntityMaid((World)Minecraft.func_71410_x().field_71441_e);
        }
    }

    protected void func_231160_c_() {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.field_230710_m_.clear();
        this.leftPos = (this.field_230708_k_ - this.imageWidth) / 2;
        this.topPos = (this.field_230709_l_ - this.imageHeight) / 2;
        this.selectedIndex = this.selectedIndex < this.infoList.size() ? this.selectedIndex : -1;
        this.page = this.page <= (this.infoList.size() - 1) / 6 ? this.page : 0;
        this.addListChangeButton();
        this.addPageButton();
        this.addListButton();
        if (this.selectedIndex >= 0) {
            this.addEditButton();
        } else {
            this.description = null;
        }
    }

    private void addEditButton() {
        TileEntityModelSwitcher.ModeInfo info = this.infoList.get(this.selectedIndex);
        this.maid.setModelId(info.getModelId().toString());
        this.func_230480_a_((Widget)new Button(this.leftPos + 55, this.topPos + 15, 76, 20, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.button.skin"), b -> {
            ModelSwitcherModelGui modelGui = new ModelSwitcherModelGui(this.maid, info, this);
            this.getMinecraft().func_147108_a((Screen)modelGui);
        }));
        this.func_230480_a_((Widget)new DirectButton(this.leftPos + 55, this.topPos + 38, 76, 20, info.getDirection(), b -> info.setDirection(((DirectButton)b).getDirection())));
        this.func_230480_a_((Widget)new Button(this.leftPos + 12, this.topPos + 135, 121, 20, (ITextComponent)new TranslationTextComponent("selectWorld.edit.save"), b -> NetworkHandler.CHANNEL.sendToServer((Object)new SaveSwitcherDataMessage(this.pos, this.infoList))));
        this.description = new TextFieldWidget(this.getMinecraft().field_71466_p, this.leftPos + 12, this.topPos + 65, 119, 20, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.name_tag.edit_box"));
        this.description.func_146180_a(info.getText());
        this.func_230481_d_((IGuiEventListener)this.description);
        this.func_212928_a((IGuiEventListener)this.description);
    }

    private void addListButton() {
        int startOffsetY = this.topPos + 24;
        for (int i = this.page * 6; i < Math.min(this.infoList.size(), (this.page + 1) * 6); ++i) {
            ImageButtonWithId button = i != this.selectedIndex ? new ImageButtonWithId(i, this.leftPos + 141, startOffsetY, 108, 19, 0, 166, 19, BG, b -> {
                this.selectedIndex = ((ImageButtonWithId)b).getIndex();
                this.func_231160_c_();
            }) : new ImageButtonWithId(i, this.leftPos + 141, startOffsetY, 108, 19, 108, 166, 0, BG, b -> {
                this.selectedIndex = -1;
                this.func_231160_c_();
            });
            this.func_230480_a_((Widget)button);
            startOffsetY += 19;
        }
    }

    private void addPageButton() {
        this.func_230480_a_((Widget)new ImageButton(this.leftPos + 141, this.topPos + 7, 13, 16, 0, 204, 16, BG, b -> {
            if (this.page > 0) {
                --this.page;
                this.func_231160_c_();
            }
        }));
        this.func_230480_a_((Widget)new ImageButton(this.leftPos + 236, this.topPos + 7, 13, 16, 13, 204, 16, BG, b -> {
            if (this.page + 1 <= (this.infoList.size() - 1) / 6) {
                ++this.page;
                this.func_231160_c_();
            }
        }));
    }

    private void addListChangeButton() {
        this.func_230480_a_((Widget)new Button(this.leftPos + 141, this.topPos + 139, 53, 20, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.model_switcher.list.add"), b -> {
            this.infoList.add(new TileEntityModelSwitcher.ModeInfo(DEFAULT_MODEL_ID, "", Direction.NORTH));
            this.func_231160_c_();
        }));
        this.func_230480_a_((Widget)new Button(this.leftPos + 196, this.topPos + 139, 53, 20, (ITextComponent)new TranslationTextComponent("selectWorld.deleteButton"), b -> {
            if (-1 < this.selectedIndex && this.selectedIndex < this.infoList.size()) {
                this.infoList.remove(this.selectedIndex);
                this.selectedIndex = -1;
                this.func_231160_c_();
            }
        }));
    }

    public void func_231152_a_(Minecraft pMinecraft, int pWidth, int pHeight) {
        String value = "";
        if (this.description != null) {
            value = this.description.func_146179_b();
        }
        super.func_231152_a_(pMinecraft, this.field_230708_k_, this.field_230709_l_);
        if (this.description != null) {
            this.description.func_146180_a(value);
        }
    }

    public void func_230430_a_(MatrixStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.maid == null) {
            return;
        }
        this.func_230446_a_(pPoseStack);
        this.getMinecraft().field_71446_o.func_110577_a(BG);
        this.func_238474_b_(pPoseStack, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.bindUuid != null) {
            ModelSwitcherGui.func_238471_a_((MatrixStack)pPoseStack, (FontRenderer)this.field_230712_o_, (String)this.bindUuid.toString(), (int)(this.leftPos + 128), (int)(this.topPos - 10), (int)0xFFFFFF);
        } else {
            ModelSwitcherGui.func_238472_a_((MatrixStack)pPoseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.model_switcher.uuid.empty"), (int)(this.leftPos + 128), (int)(this.topPos - 10), (int)0xFFFFFF);
        }
        ModelSwitcherGui.func_238471_a_((MatrixStack)pPoseStack, (FontRenderer)this.field_230712_o_, (String)String.format("%d/%d", this.page + 1, (this.infoList.size() - 1) / 6 + 1), (int)(this.leftPos + 193), (int)(this.topPos + 12), (int)0xFFFFFF);
        if (this.description != null) {
            InventoryScreen.func_228187_a_((int)(this.leftPos + 30), (int)(this.topPos + 60), (int)25, (float)(this.leftPos - 150), (float)(this.topPos - 50), (LivingEntity)this.maid);
            this.description.func_230430_a_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
        super.func_230430_a_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderListButtonName(pPoseStack);
    }

    private void renderListButtonName(MatrixStack pPoseStack) {
        int startOffsetY = this.topPos + 29;
        for (int i = this.page * 6; i < Math.min(this.infoList.size(), (this.page + 1) * 6); ++i) {
            String modelId = this.infoList.get(i).getModelId().toString();
            if (CustomPackLoader.MAID_MODELS.getInfo(modelId).isPresent()) {
                MaidModelInfo info = CustomPackLoader.MAID_MODELS.getInfo(modelId).get();
                TranslationTextComponent component = new TranslationTextComponent(ParseI18n.getI18nKey(info.getName()));
                ModelSwitcherGui.func_238472_a_((MatrixStack)pPoseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)component, (int)(this.leftPos + 193), (int)startOffsetY, (int)0xFFFFFF);
            }
            startOffsetY += 19;
        }
    }

    public void func_231023_e_() {
        if (this.description != null) {
            this.description.func_146178_a();
            if (0 <= this.selectedIndex && this.selectedIndex < this.infoList.size()) {
                this.infoList.get(this.selectedIndex).setText(this.description.func_146179_b());
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.description != null && this.description.func_231044_a_(mouseX, mouseY, button)) {
            this.func_231035_a_((IGuiEventListener)this.description);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    protected void func_231155_a_(String text, boolean overwrite) {
        if (this.description != null) {
            if (overwrite) {
                this.description.func_146180_a(text);
            } else {
                this.description.func_146191_b(text);
            }
        }
    }

    public void func_231175_as__() {
        NetworkHandler.CHANNEL.sendToServer((Object)new SaveSwitcherDataMessage(this.pos, this.infoList));
        super.func_231175_as__();
    }
}

