/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity;

import com.github.tartaricacid.touhoulittlemaid.client.download.InfoGetManager;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.GuiDownloadButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.PackInfoButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ModelDownloadGui
extends Screen {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/download_background.png");
    private static final String PACK_FILE_SUFFIX = ".zip";
    private final Map<Long, String> crc32Infos = Maps.newHashMap();
    private final List<DownloadInfo> showInfos = Lists.newArrayList();
    private Condition condition = Condition.ALL;
    private TextFieldWidget textField;
    private boolean needReload = false;
    private int selectIndex = -1;
    private int currentPage;
    private int x;
    private int y;

    public ModelDownloadGui() {
        super((ITextComponent)new StringTextComponent("New Model Pack Download GUI"));
        this.getCrc32Infos();
        this.checkDownloadInfo();
    }

    protected void func_231160_c_() {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.x = (this.field_230708_k_ - 420) / 2;
        this.y = (this.field_230709_l_ - 240) / 2;
        this.initShowInfos();
        this.addBaseButtons();
        this.addPackButtons();
        this.addPageButtons();
        this.addPackHandleButtons();
        this.addSearchBox();
    }

    private void addSearchBox() {
        String textCache = this.textField == null ? "" : this.textField.func_146179_b();
        boolean focus = this.textField != null && this.textField.func_230999_j_();
        this.textField = new TextFieldWidget(this.getMinecraft().field_71466_p, this.x + 273, this.y + 78, 144, 16, StringTextComponent.field_240750_d_);
        this.textField.func_146193_g(15986656);
        this.textField.func_146195_b(focus);
        this.textField.func_146180_a(textCache);
        this.textField.func_146202_e();
        this.func_230481_d_((IGuiEventListener)this.textField);
    }

    private void addPackHandleButtons() {
        if (0 <= this.selectIndex && this.selectIndex < this.showInfos.size()) {
            DownloadInfo info = this.showInfos.get(this.selectIndex);
            this.func_230480_a_((Widget)new FlatColorButton(this.x + 272, this.y + 50, 20, 20, StringTextComponent.field_240750_d_, b -> this.openPackWebsite(info)).setTooltips("gui.touhou_little_maid.resources_download.open_link"));
            this.func_230480_a_((Widget)new GuiDownloadButton(this.x + 294, this.y + 50, 102, 20, info, b -> {
                if (info.getStatus() == DownloadStatus.NOT_DOWNLOAD) {
                    info.setStatus(DownloadStatus.DOWNLOADING);
                    InfoGetManager.downloadResourcesPack(info);
                    this.func_231160_c_();
                } else if (info.getStatus() == DownloadStatus.NEED_UPDATE) {
                    this.updatePack(info);
                }
            }));
            this.func_230480_a_((Widget)new FlatColorButton(this.x + 398, this.y + 50, 20, 20, StringTextComponent.field_240750_d_, b -> this.deletePack(info)).setTooltips("gui.touhou_little_maid.resources_download.delete"));
        }
    }

    private void addPageButtons() {
        this.func_230480_a_((Widget)new FlatColorButton(this.x, this.y + 218, 40, 20, (ITextComponent)new StringTextComponent("<"), b -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.func_231160_c_();
            }
        }));
        this.func_230480_a_((Widget)new FlatColorButton(this.x + 228, this.y + 218, 40, 20, (ITextComponent)new StringTextComponent(">"), b -> {
            if (this.currentPage * 4 + 4 <= this.showInfos.size()) {
                ++this.currentPage;
                this.func_231160_c_();
            }
        }));
    }

    private void addPackButtons() {
        int startIndex;
        for (int i = startIndex = this.currentPage * 4; i < startIndex + 4 && i < this.showInfos.size(); ++i) {
            DownloadInfo info = this.showInfos.get(i);
            int yOffset = this.y + 26 + (i - startIndex) * 48;
            int tmp = i;
            PackInfoButton button = new PackInfoButton(this.x, yOffset, info, b -> {
                this.selectIndex = tmp;
                this.func_231160_c_();
            });
            if (this.selectIndex == i) {
                button.setSelect(true);
            }
            this.func_230480_a_((Widget)button);
        }
    }

    private void addBaseButtons() {
        int i = 0;
        for (Condition c : Condition.values()) {
            int width = 52;
            int xPos = this.x + (width + 2) * i;
            String key = c.name().toLowerCase(Locale.US);
            String nameKey = "gui.touhou_little_maid.resources_download." + key;
            String descKey = nameKey + ".tips";
            Button button = new Button(xPos, this.y + 3, width, 20, (ITextComponent)new TranslationTextComponent(nameKey), b -> this.setCondition(c), (b, matrixStack, x, y) -> this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent(descKey), x, y));
            if (this.condition.equals((Object)c)) {
                button.field_230693_o_ = false;
            }
            this.func_230480_a_((Widget)button);
            ++i;
        }
        this.func_230480_a_((Widget)new FlatColorButton(this.x + 400, this.y + 2, 20, 20, StringTextComponent.field_240750_d_, b -> this.getMinecraft().func_147108_a(null)).setTooltips("gui.touhou_little_maid.skin.button.close"));
        this.func_230480_a_((Widget)new Button(this.x + 270, this.y + 218, 150, 20, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.resources_download.open_folder"), b -> Util.func_110647_a().func_195641_a(CustomPackLoader.PACK_FOLDER.toFile())));
    }

    private void initShowInfos() {
        this.showInfos.clear();
        switch (this.condition) {
            default: {
                this.showInfos.addAll(InfoGetManager.DOWNLOAD_INFO_LIST_ALL);
                break;
            }
            case MAID: {
                this.showInfos.addAll(InfoGetManager.getTypedDownloadInfoList(DownloadInfo.TypeEnum.MAID));
                break;
            }
            case CHAIR: {
                this.showInfos.addAll(InfoGetManager.getTypedDownloadInfoList(DownloadInfo.TypeEnum.CHAIR));
                break;
            }
            case SOUND: {
                this.showInfos.addAll(InfoGetManager.getTypedDownloadInfoList(DownloadInfo.TypeEnum.SOUND));
                break;
            }
            case UPDATE: {
                this.showInfos.addAll(InfoGetManager.DOWNLOAD_INFO_LIST_ALL.stream().filter(info -> info.getStatus() == DownloadStatus.NEED_UPDATE).collect(Collectors.toList()));
            }
        }
        if (this.textField != null && StringUtils.isNotBlank((CharSequence)this.textField.func_146179_b())) {
            String search = this.textField.func_146179_b().toLowerCase(Locale.US);
            this.showInfos.removeIf(info -> !info.getKeyword().contains(search));
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float pPartialTick) {
        this.renderBase(matrixStack);
        this.renderSearchBox(matrixStack, mouseX, mouseY, pPartialTick);
        this.renderPageNumber(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, pPartialTick);
        this.renderBaseButtons(matrixStack);
        this.renderPackHandleButtons(matrixStack);
        this.renderNoDataTips(matrixStack);
        this.field_230710_m_.stream().filter(b -> b instanceof FlatColorButton).forEach(b -> ((FlatColorButton)((Object)b)).renderToolTip(matrixStack, this, mouseX, mouseY));
    }

    private void renderNoDataTips(MatrixStack matrixStack) {
        if (!InfoGetManager.DOWNLOAD_INFO_LIST_ALL.isEmpty()) {
            return;
        }
        List split = this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("gui.touhou_little_maid.resources_download.fail"), 200);
        int yOffset = this.y + 100;
        for (IReorderingProcessor sequence : split) {
            this.field_230712_o_.func_238407_a_(matrixStack, sequence, (float)(this.x + 134 - this.field_230712_o_.func_243245_a(sequence) / 2), (float)yOffset, TextFormatting.RED.func_211163_e().intValue());
            yOffset += 12;
        }
    }

    private void renderPageNumber(MatrixStack matrixStack) {
        int maxPage = (this.showInfos.size() - 1) / 4;
        String pageInfo = String.format("%d/%d", this.currentPage + 1, maxPage + 1);
        int n = this.x + 134 - this.field_230712_o_.func_78256_a(pageInfo) / 2;
        this.field_230712_o_.getClass();
        ModelDownloadGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)pageInfo, (int)n, (int)(this.y + 227 - 9 / 2), (int)15986656);
    }

    private void renderPackHandleButtons(MatrixStack matrixStack) {
        if (0 <= this.selectIndex && this.selectIndex < this.showInfos.size()) {
            DownloadInfo info = this.showInfos.get(this.selectIndex);
            ModelDownloadGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent(info.getName()), (int)(this.x + 345), (int)(this.y + 34), (int)0xFFFFFF);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(BG);
            this.func_238474_b_(matrixStack, this.x + 400, this.y + 52, 0, 16, 16, 16);
            this.func_238474_b_(matrixStack, this.x + 274, this.y + 52, 16, 16, 16, 16);
        }
    }

    private void renderBaseButtons(MatrixStack matrixStack) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BG);
        this.func_238474_b_(matrixStack, this.x + 402, this.y + 4, 32, 16, 16, 16);
    }

    private void renderSearchBox(MatrixStack matrixStack, int pMouseX, int pMouseY, float pPartialTick) {
        ModelDownloadGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.resources_download.hot_search"), (int)(this.x + 274), (int)(this.y + 102), (int)0xFFFFFF);
        this.field_230712_o_.func_238418_a_((ITextProperties)new TranslationTextComponent("gui.touhou_little_maid.resources_download.hot_search_key"), this.x + 274, this.y + 115, 146, TextFormatting.GRAY.func_211163_e().intValue());
        this.textField.func_230430_a_(matrixStack, pMouseX, pMouseY, pPartialTick);
        if (this.textField.func_146179_b().isEmpty() && !this.textField.func_230999_j_()) {
            ModelDownloadGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.resources_download.search").func_240699_a_(TextFormatting.ITALIC), (int)(this.x + 277), (int)(this.y + 83), (int)0x777777);
        }
    }

    private void renderBase(MatrixStack matrixStack) {
        this.func_238468_a_(matrixStack, 0, 0, this.field_230708_k_, this.field_230709_l_, -503316480, -503316480);
        this.func_238468_a_(matrixStack, this.x + 270, this.y + 26, this.x + 420, this.y + 72, -14474719, -14474719);
        this.func_238468_a_(matrixStack, this.x + 270, this.y + 74, this.x + 420, this.y + 216, -14474719, -14474719);
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        String value = this.textField.func_146179_b();
        super.func_231152_a_(minecraft, width, height);
        this.textField.func_146180_a(value);
    }

    public void func_231023_e_() {
        this.textField.func_146178_a();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.textField.func_231044_a_(mouseX, mouseY, button)) {
            this.func_231035_a_((IGuiEventListener)this.textField);
            return true;
        }
        if (this.textField.func_230999_j_()) {
            this.textField.func_146195_b(false);
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        if (this.textField == null) {
            return false;
        }
        String perText = this.textField.func_146179_b();
        if (this.textField.func_231042_a_(codePoint, modifiers)) {
            if (!Objects.equals(perText, this.textField.func_146179_b())) {
                this.currentPage = 0;
                this.func_231160_c_();
            }
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean hasKeyCode = InputMappings.func_197954_a((int)keyCode, (int)scanCode).func_241552_e_().isPresent();
        String preText = this.textField.func_146179_b();
        if (hasKeyCode) {
            return true;
        }
        if (this.textField.func_231046_a_(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(preText, this.textField.func_146179_b())) {
                this.currentPage = 0;
                this.func_231160_c_();
            }
            return true;
        }
        return this.textField.func_230999_j_() && this.textField.func_146176_q() && keyCode != 256 || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    protected void func_231155_a_(String text, boolean overwrite) {
        if (overwrite) {
            this.textField.func_146180_a(text);
        } else {
            this.textField.func_146191_b(text);
        }
    }

    public void func_231175_as__() {
        if (this.needReload && this.getMinecraft().field_71439_g != null) {
            this.getMinecraft().field_71456_v.func_238452_a_((ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.resources_download.need_reload.title"), null, 10, 70, 20);
            this.getMinecraft().field_71456_v.func_238452_a_(null, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.resources_download.need_reload.subtitle"), 10, 70, 20);
            this.getMinecraft().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.resources_download.need_reload.subtitle"), Util.field_240973_b_);
        }
        super.func_231175_as__();
    }

    private void getCrc32Infos() {
        this.crc32Infos.clear();
        try {
            Files.walkFileTree(CustomPackLoader.PACK_FOLDER, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(ModelDownloadGui.PACK_FILE_SUFFIX)) {
                        ModelDownloadGui.this.crc32Infos.put(FileUtils.checksumCRC32((File)file.toFile()), file.toFile().getName());
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkDownloadInfo() {
        block0: for (DownloadInfo info : InfoGetManager.DOWNLOAD_INFO_LIST_ALL) {
            if (info.getStatus() != DownloadStatus.DOWNLOADING) {
                info.setStatus(DownloadStatus.NOT_DOWNLOAD);
            }
            for (Long crc32 : this.crc32Infos.keySet()) {
                if (crc32.equals(info.getChecksum())) {
                    info.setStatus(DownloadStatus.DOWNLOADED);
                    continue block0;
                }
                if (!info.getOldVersion().contains(crc32)) continue;
                info.setStatus(DownloadStatus.NEED_UPDATE);
                continue block0;
            }
        }
    }

    private void setCondition(Condition condition) {
        if (this.condition != condition) {
            this.condition = condition;
            this.currentPage = 0;
            this.func_231160_c_();
        }
    }

    private void openPackWebsite(DownloadInfo info) {
        String website = info.getWebsite();
        if (StringUtils.isNotBlank((CharSequence)website)) {
            this.getMinecraft().func_147108_a((Screen)new ConfirmOpenLinkScreen(yes -> {
                if (yes) {
                    Util.func_110647_a().func_195640_a(website);
                }
                this.getMinecraft().func_147108_a((Screen)this);
            }, website, false));
        }
    }

    private void deletePack(DownloadInfo info) {
        Set<String> deleteFiles = this.getDeleteFiles(info);
        if (info.getStatus() == DownloadStatus.DOWNLOADED || info.getStatus() == DownloadStatus.NEED_UPDATE) {
            this.getMinecraft().func_147108_a((Screen)new ConfirmScreen(yes -> this.deleteFilesAndReload(yes, deleteFiles), (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.resources_download.delete.confirm"), (ITextComponent)new TranslationTextComponent(info.getName())));
        }
    }

    private void updatePack(DownloadInfo info) {
        Set<String> deleteFiles = this.getDeleteFiles(info);
        this.deleteFiles(deleteFiles);
        info.setStatus(DownloadStatus.DOWNLOADING);
        InfoGetManager.downloadResourcesPack(info);
        this.needReload = true;
        this.getCrc32Infos();
        this.checkDownloadInfo();
        this.func_231160_c_();
    }

    @Nonnull
    private Set<String> getDeleteFiles(DownloadInfo info) {
        HashSet deleteFiles = Sets.newHashSet();
        deleteFiles.add(info.getFileName());
        info.getOldVersion().forEach(version -> {
            if (this.crc32Infos.containsKey(version)) {
                deleteFiles.add(this.crc32Infos.get(version));
            }
        });
        return deleteFiles;
    }

    private void deleteFiles(Set<String> deleteFiles) {
        for (String fileName : deleteFiles) {
            try {
                Path file = CustomPackLoader.PACK_FOLDER.resolve(fileName);
                if (!Files.isRegularFile(file, new LinkOption[0])) continue;
                Files.delete(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void deleteFilesAndReload(boolean yes, Set<String> deleteFiles) {
        if (yes) {
            this.deleteFiles(deleteFiles);
            this.needReload = true;
            this.getCrc32Infos();
            this.checkDownloadInfo();
            this.func_231160_c_();
        }
        this.getMinecraft().func_147108_a((Screen)this);
    }

    public static enum Condition {
        ALL,
        MAID,
        CHAIR,
        SOUND,
        UPDATE;

    }
}

