/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail;

import com.github.tartaricacid.touhoulittlemaid.client.model.DebugFloorModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.Rectangle;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class AbstractModelDetailsGui<T extends LivingEntity, E extends IModelInfo>
extends Screen {
    private static final ResourceLocation BUTTON_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/gui/skin_detail.png");
    private static final ResourceLocation FLOOR_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/debug_floor.png");
    private static final int LEFT_MOUSE_BUTTON = 0;
    private static final int RIGHT_MOUSE_BUTTON = 1;
    private static final float SCALE_MAX = 360.0f;
    private static final float SCALE_MIN = 18.0f;
    private static final float PITCH_MAX = 90.0f;
    private static final float PITCH_MIN = -90.0f;
    private static Rectangle BACKGROUND_SIZE;
    private static Rectangle BOTTOM_STATUS_BAR_SIZE;
    private static Rectangle SIDE_MENU_SIZE;
    private static Rectangle TOP_STATUS_BAR_SIZE;
    protected final DebugFloorModel floorModel;
    protected T sourceEntity;
    protected volatile T guiEntity;
    protected E modelInfo;
    private float posX = 0.0f;
    private float posY = 25.0f;
    private float scale = 80.0f;
    private float yaw = 145.0f;
    private float pitch = -25.0f;
    private boolean showFloor = true;

    public AbstractModelDetailsGui(T sourceEntity, @Nullable T guiEntity, E modelInfo) {
        super((ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.custom_model_details_gui.title"));
        this.sourceEntity = sourceEntity;
        this.guiEntity = guiEntity;
        this.modelInfo = modelInfo;
        this.floorModel = new DebugFloorModel();
    }

    protected abstract void applyReturnButtonLogic();

    protected abstract void initSideButton();

    protected abstract void renderExtraEntity(EntityRendererManager var1, MatrixStack var2, IRenderTypeBuffer var3);

    protected void func_231160_c_() {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        BACKGROUND_SIZE = new Rectangle(0.0, 0.0, this.field_230708_k_, this.field_230709_l_);
        BOTTOM_STATUS_BAR_SIZE = new Rectangle(0.0, this.field_230709_l_ - 16, this.field_230708_k_, this.field_230709_l_);
        SIDE_MENU_SIZE = new Rectangle(0.0, 0.0, 132.0, this.field_230709_l_);
        TOP_STATUS_BAR_SIZE = new Rectangle(0.0, 0.0, this.field_230708_k_, 15.0);
        ImageButton closeButton = new ImageButton(this.field_230708_k_ - 15, 0, 15, 15, 0, 24, 15, BUTTON_TEXTURE, b -> Minecraft.func_71410_x().func_147108_a(null));
        ImageButton floorButton = new ImageButton(this.field_230708_k_ - 30, 0, 15, 15, 30, 24, 15, BUTTON_TEXTURE, b -> {
            this.showFloor = !this.showFloor;
        });
        ImageButton returnButton = new ImageButton(this.field_230708_k_ - 45, 0, 15, 15, 15, 24, 15, BUTTON_TEXTURE, b -> this.applyReturnButtonLogic());
        this.func_230480_a_((Widget)closeButton);
        this.func_230480_a_((Widget)floorButton);
        this.func_230480_a_((Widget)returnButton);
        this.initSideButton();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230706_i_ == null) {
            return;
        }
        this.renderViewBg(stack);
        this.renderEntity((this.field_230708_k_ + 132) / 2, this.field_230709_l_ / 2);
        this.renderViewCrosshair();
        this.renderBottomStatueBar(stack);
        this.fillGradient(stack, SIDE_MENU_SIZE, -31382229);
        this.fillGradient(stack, TOP_STATUS_BAR_SIZE, -30921676);
        AbstractModelDetailsGui.func_238475_b_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.func_231171_q_(), (int)6, (int)4, (int)-5592406);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    private void renderViewBg(MatrixStack stack) {
        this.fillGradient(stack, BACKGROUND_SIZE, -32040675, -1000);
        stack.func_227860_a_();
        stack.func_227861_a_(0.0, 0.0, -900.0);
        AbstractModelDetailsGui.func_238475_b_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.skin_details.left_mouse"), (int)((int)AbstractModelDetailsGui.SIDE_MENU_SIZE.w + 4), (int)((int)AbstractModelDetailsGui.TOP_STATUS_BAR_SIZE.h + 4), (int)-5592406);
        AbstractModelDetailsGui.func_238475_b_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.skin_details.right_mouse"), (int)((int)AbstractModelDetailsGui.SIDE_MENU_SIZE.w + 4), (int)((int)AbstractModelDetailsGui.TOP_STATUS_BAR_SIZE.h + 14), (int)-5592406);
        AbstractModelDetailsGui.func_238475_b_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.skin_details.mouse_wheel"), (int)((int)AbstractModelDetailsGui.SIDE_MENU_SIZE.w + 4), (int)((int)AbstractModelDetailsGui.TOP_STATUS_BAR_SIZE.h + 24), (int)-5592406);
        stack.func_227865_b_();
    }

    private void renderBottomStatueBar(MatrixStack stack) {
        this.fillGradient(stack, BOTTOM_STATUS_BAR_SIZE, -30921676);
        String name = String.format("%s %s", "\u2714", I18n.func_135052_a((String)ParseI18n.getI18nKey(this.modelInfo.getName()), (Object[])new Object[0]));
        String info = String.format("%d FPS %.2f%%", Minecraft.field_71470_ab, Float.valueOf(this.scale * 100.0f / 80.0f));
        AbstractModelDetailsGui.func_238476_c_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)name, (int)136, (int)(this.field_230709_l_ - 12), (int)13290196);
        AbstractModelDetailsGui.func_238476_c_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)info, (int)(this.field_230708_k_ - this.field_230712_o_.func_78256_a(info) - 4), (int)(this.field_230709_l_ - 12), (int)13290196);
    }

    private void renderViewCrosshair() {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(this.field_230708_k_ - 16), (float)(this.field_230709_l_ - 32), (float)-20.0f);
        RenderSystem.rotatef((float)this.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.rotatef((float)this.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.renderCrosshair((int)10);
        RenderSystem.popMatrix();
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean isInRange;
        boolean isInWidthRange = 132.0 < mouseX && mouseX < (double)(this.field_230708_k_ - 1);
        boolean isInHeightRange = 15.0 < mouseY && mouseY < (double)(this.field_230709_l_ - 16);
        boolean bl = isInRange = isInWidthRange && isInHeightRange;
        if (this.field_230706_i_ == null || !isInRange) {
            return false;
        }
        if (button == 0) {
            this.yaw = (float)((double)this.yaw + dragX);
            this.changePitchValue((float)dragY);
        }
        if (button == 1) {
            this.posX = (float)((double)this.posX + dragX);
            this.posY = (float)((double)this.posY + dragY);
        }
        return true;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        boolean isInRange;
        boolean isInWidthRange = 132.0 < mouseX && mouseX < (double)(this.field_230708_k_ - 1);
        boolean isInHeightRange = 15.0 < mouseY && mouseY < (double)(this.field_230709_l_ - 16);
        boolean bl = isInRange = isInWidthRange && isInHeightRange;
        if (this.field_230706_i_ == null || !isInRange) {
            return false;
        }
        if (delta != 0.0) {
            this.changeScaleValue((float)delta * 0.07f);
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, delta);
    }

    private void changePitchValue(float amount) {
        this.pitch = this.pitch - amount > 90.0f ? 90.0f : (this.pitch - amount < -90.0f ? -90.0f : (this.pitch -= amount));
    }

    private void changeScaleValue(float amount) {
        float tmp = this.scale + amount * this.scale;
        this.scale = MathHelper.func_76131_a((float)tmp, (float)18.0f, (float)360.0f);
    }

    private void renderEntity(int middleWidth, int middleHeight) {
        MatrixStack matrixstack = new MatrixStack();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(this.posX + (float)middleWidth), (float)(this.posY + (float)middleHeight), (float)-550.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        RenderSystem.rotatef((float)(-this.pitch), (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.rotatef((float)(-this.yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        matrixstack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-180.0f));
        matrixstack.func_227862_a_(this.scale, this.scale, this.scale);
        EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();
        manager.func_229089_a_(Vector3f.field_229179_b_.func_229187_a_(this.pitch));
        manager.func_178633_a(false);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> {
            manager.func_229084_a_(this.guiEntity, 0.0, -0.5, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)buffer, 0xF000F0);
            if (this.showFloor) {
                this.floorModel.func_225598_a_(matrixstack, buffer.getBuffer(this.floorModel.func_228282_a_(FLOOR_TEXTURE)), 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            this.renderExtraEntity(manager, matrixstack, (IRenderTypeBuffer)buffer);
        });
        buffer.func_228461_a_();
        manager.func_178633_a(true);
        RenderSystem.popMatrix();
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void fillGradient(MatrixStack matrixStack, Rectangle vec4d, int color) {
        this.func_238468_a_(matrixStack, (int)vec4d.x, (int)vec4d.y, (int)vec4d.w, (int)vec4d.h, color, color);
    }

    private void fillGradient(MatrixStack matrixStack, Rectangle vec4d, int color, int zLevel) {
        int blitOffset = this.func_230927_p_();
        this.func_230926_e_(zLevel);
        this.fillGradient(matrixStack, vec4d, color);
        this.func_230926_e_(blitOffset);
    }
}

