/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail.AbstractModelDetailsGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.MaidModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ModelDetailsButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.world.World;

public class MaidModelDetailsGui
extends AbstractModelDetailsGui<EntityMaid, MaidModelInfo> {
    private static final ItemStack MAIN_HAND_SWORD = Items.field_151048_u.func_190903_i();
    private static final ItemStack OFF_HAND_SHIELD = Items.field_185159_cQ.func_190903_i();
    private static final ItemStack ARMOR_ITEM = Items.field_151169_ag.func_190903_i();
    private EntityChair chair;
    private volatile boolean isEnableWalk = false;

    public MaidModelDetailsGui(EntityMaid sourceEntity, MaidModelInfo modelInfo) {
        super(sourceEntity, (LivingEntity)((EntityType)InitEntities.MAID.get()).func_200721_a(sourceEntity.field_70170_p), modelInfo);
        ((EntityMaid)this.guiEntity).setModelId(modelInfo.getModelId().toString());
        ((EntityMaid)this.guiEntity).func_230245_c_(true);
        this.initChair();
    }

    private void initChair() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            this.chair = (EntityChair)((EntityType)InitEntities.CHAIR.get()).func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
            if (this.chair != null) {
                this.chair.setModelId("touhou_little_maid:low_stool");
            }
        }
    }

    @Override
    protected void applyReturnButtonLogic() {
        Minecraft.func_71410_x().func_147108_a((Screen)new MaidModelGui((EntityMaid)this.sourceEntity));
    }

    @Override
    protected void initSideButton() {
        ModelDetailsButton begButton = new ModelDetailsButton(2, 17, "gui.touhou_little_maid.skin_details.beg", isStateTriggered -> ((EntityMaid)this.guiEntity).setBegging((boolean)isStateTriggered));
        ModelDetailsButton walkButton = new ModelDetailsButton(2, 30, "gui.touhou_little_maid.skin_details.walk", isStateTriggered -> {
            this.isEnableWalk = isStateTriggered;
        });
        ModelDetailsButton sitButton = new ModelDetailsButton(2, 43, "gui.touhou_little_maid.skin_details.sit", isStateTriggered -> ((EntityMaid)this.guiEntity).func_233686_v_((boolean)isStateTriggered));
        ModelDetailsButton rideButton = new ModelDetailsButton(2, 56, "gui.touhou_little_maid.skin_details.ride", this::applyRideButtonLogic);
        ModelDetailsButton helmetButton = new ModelDetailsButton(2, 69, "gui.touhou_little_maid.skin_details.helmet", isStateTriggered -> this.applyEquipmentButtonLogic(EquipmentSlotType.HEAD, (boolean)isStateTriggered));
        ModelDetailsButton chestPlateButton = new ModelDetailsButton(2, 82, "gui.touhou_little_maid.skin_details.chest_plate", isStateTriggered -> this.applyEquipmentButtonLogic(EquipmentSlotType.CHEST, (boolean)isStateTriggered));
        ModelDetailsButton leggingsButton = new ModelDetailsButton(2, 95, "gui.touhou_little_maid.skin_details.leggings", isStateTriggered -> this.applyEquipmentButtonLogic(EquipmentSlotType.LEGS, (boolean)isStateTriggered));
        ModelDetailsButton bootsButton = new ModelDetailsButton(2, 108, "gui.touhou_little_maid.skin_details.boots", isStateTriggered -> this.applyEquipmentButtonLogic(EquipmentSlotType.FEET, (boolean)isStateTriggered));
        ModelDetailsButton mainHandButton = new ModelDetailsButton(2, 121, "gui.touhou_little_maid.skin_details.main_hand", isStateTriggered -> this.applyEquipmentButtonLogic(EquipmentSlotType.MAINHAND, (boolean)isStateTriggered));
        ModelDetailsButton offHandButton = new ModelDetailsButton(2, 134, "gui.touhou_little_maid.skin_details.off_hand", isStateTriggered -> this.applyEquipmentButtonLogic(EquipmentSlotType.OFFHAND, (boolean)isStateTriggered));
        this.func_230480_a_((Widget)begButton);
        this.func_230480_a_((Widget)walkButton);
        this.func_230480_a_((Widget)sitButton);
        this.func_230480_a_((Widget)rideButton);
        this.func_230480_a_((Widget)helmetButton);
        this.func_230480_a_((Widget)chestPlateButton);
        this.func_230480_a_((Widget)leggingsButton);
        this.func_230480_a_((Widget)bootsButton);
        this.func_230480_a_((Widget)mainHandButton);
        this.func_230480_a_((Widget)offHandButton);
    }

    public void func_231023_e_() {
        ++((EntityMaid)this.guiEntity).field_70173_aa;
        ((EntityMaid)this.guiEntity).field_184618_aE = ((EntityMaid)this.guiEntity).field_70721_aZ;
        float speed = this.isEnableWalk ? 0.5f : 0.0f;
        ((EntityMaid)this.guiEntity).field_70721_aZ += (speed - ((EntityMaid)this.guiEntity).field_70721_aZ) * 0.4f;
        ((EntityMaid)this.guiEntity).field_184619_aG += ((EntityMaid)this.guiEntity).field_70721_aZ;
    }

    @Override
    protected void renderExtraEntity(EntityRendererManager manager, MatrixStack matrix, IRenderTypeBuffer bufferIn) {
        if (((EntityMaid)this.guiEntity).func_184218_aH() && this.chair != null) {
            manager.func_229084_a_((Entity)this.chair, 0.0, -0.95, 0.0, 0.0f, 1.0f, matrix, bufferIn, 0xF000F0);
        }
    }

    private void applyRideButtonLogic(boolean isStateTriggered) {
        if (isStateTriggered && this.chair != null) {
            ((EntityMaid)this.guiEntity).func_184205_a((Entity)this.chair, true);
        } else {
            ((EntityMaid)this.guiEntity).func_233575_bb_();
        }
    }

    private void applyEquipmentButtonLogic(EquipmentSlotType slot, boolean isStateTriggered) {
        if (isStateTriggered) {
            if (slot == EquipmentSlotType.MAINHAND) {
                ((EntityMaid)this.guiEntity).func_184201_a(slot, MAIN_HAND_SWORD);
            } else if (slot == EquipmentSlotType.OFFHAND) {
                ((EntityMaid)this.guiEntity).func_184201_a(slot, OFF_HAND_SHIELD);
            } else {
                ((EntityMaid)this.guiEntity).func_184201_a(slot, ARMOR_ITEM);
            }
        } else {
            ((EntityMaid)this.guiEntity).func_184201_a(slot, ItemStack.field_190927_a);
        }
    }
}

