/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.MaidTabs;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.MaidModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.sound.MaidSoundPackGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidDownloadButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidTabButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ScheduleButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TaskButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.compat.ipn.SortButtonScreen;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidConfigMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidTaskMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.RequestEffectMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendEffectMessage;
import com.github.tartaricacid.touhoulittlemaid.util.GuiTools;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.ToggleWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public abstract class AbstractMaidContainerGui<T extends AbstractMaidContainer>
extends ContainerScreen<T> {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/maid_gui_main.png");
    private static final ResourceLocation SIDE = new ResourceLocation("touhou_little_maid", "textures/gui/maid_gui_side.png");
    private static final ResourceLocation BUTTON = new ResourceLocation("touhou_little_maid", "textures/gui/maid_gui_button.png");
    private static final ResourceLocation TASK = new ResourceLocation("touhou_little_maid", "textures/gui/maid_gui_task.png");
    private static final int TASK_COUNT_PER_PAGE = 12;
    private static int TASK_PAGE = 0;
    private final EntityMaid maid;
    private ToggleWidget home;
    private ToggleWidget pick;
    private ToggleWidget ride;
    private ImageButton info;
    private ImageButton skin;
    private ImageButton sound;
    private ImageButton pageDown;
    private ImageButton pageUp;
    private ImageButton pageClose;
    private ImageButton taskSwitch;
    private MaidDownloadButton modelDownload;
    private ScheduleButton<T> scheduleButton;
    private boolean taskListOpen;
    private int counterTime = 0;

    public AbstractMaidContainerGui(T screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        this.field_147000_g = 256;
        this.field_146999_f = 256;
        this.maid = ((AbstractMaidContainer)this.field_147002_h).getMaid();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.addHomeButton();
        this.addPickButton();
        this.addRideButton();
        this.addDownloadButton();
        this.addStateButton();
        this.addTaskSwitchButton();
        this.addTaskControlButton();
        this.addTaskListButton();
        this.addScheduleButton();
        this.addTabsButton();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.drawEffectInfo(matrixStack);
        this.drawCurrentTaskText(matrixStack);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        matrixStack.func_227861_a_(0.0, 0.0, -100.0);
        this.func_230446_a_(matrixStack);
        this.getMinecraft().field_71446_o.func_110577_a(BG);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        SortButtonScreen.renderBackground(matrixStack, this.field_147003_i + 249, this.field_147009_r + 166);
        this.drawMaidCharacter(x, y);
        this.drawBaseInfoGui(matrixStack);
        this.drawTaskListBg(matrixStack);
    }

    private void drawEffectInfo(MatrixStack matrixStack) {
        if (this.taskListOpen) {
            return;
        }
        List<SendEffectMessage.EffectData> effects = this.maid.getEffects();
        if (!effects.isEmpty()) {
            int yOffset = 5;
            for (SendEffectMessage.EffectData effect : effects) {
                TranslationTextComponent text = new TranslationTextComponent(effect.descriptionId);
                if (effect.amplifier >= 1 && effect.amplifier <= 9) {
                    TranslationTextComponent levelText = new TranslationTextComponent("enchantment.level." + (effect.amplifier + 1));
                    text = text.func_240702_b_(" ").func_230529_a_((ITextComponent)levelText);
                }
                String duration = effect.duration == -1 ? I18n.func_135052_a((String)"effect.duration.infinite", (Object[])new Object[0]) : StringUtils.func_76337_a((int)effect.duration);
                text = text.func_240702_b_(" ").func_240702_b_(duration);
                AbstractMaidContainerGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)text, (int)(this.field_147003_i - this.field_230712_o_.func_238414_a_((ITextProperties)text) - 3), (int)(this.field_147009_r + yOffset + 5), (int)this.getPotionColor(effect.category));
                yOffset += 10;
            }
        }
    }

    private int getPotionColor(int category) {
        switch (category) {
            case 0: {
                return TextFormatting.GREEN.func_211163_e();
            }
            case 1: {
                return TextFormatting.RED.func_211163_e();
            }
        }
        return TextFormatting.BLUE.func_211163_e();
    }

    protected void func_230459_a_(MatrixStack matrixStack, int x, int y) {
        super.func_230459_a_(matrixStack, x, y);
        this.renderTransTooltip(this.home, matrixStack, x, y, "gui.touhou_little_maid.button.home");
        this.renderTransTooltip(this.pick, matrixStack, x, y, "gui.touhou_little_maid.button.pickup");
        this.renderTransTooltip(this.ride, matrixStack, x, y, "gui.touhou_little_maid.button.maid_riding_set");
        this.renderTransTooltip(this.modelDownload, matrixStack, x, y, "gui.touhou_little_maid.button.model_download");
        this.renderTransTooltip(this.skin, matrixStack, x, y, "gui.touhou_little_maid.button.skin");
        this.renderTransTooltip(this.sound, matrixStack, x, y, "gui.touhou_little_maid.button.sound");
        this.renderTransTooltip(this.pageUp, matrixStack, x, y, "gui.touhou_little_maid.task.next_page");
        this.renderTransTooltip(this.pageDown, matrixStack, x, y, "gui.touhou_little_maid.task.previous_page");
        this.renderTransTooltip(this.pageClose, matrixStack, x, y, "gui.touhou_little_maid.task.close");
        this.renderTransTooltip(this.taskSwitch, matrixStack, x, y, "gui.touhou_little_maid.task.switch");
        this.renderMaidInfo(matrixStack, x, y);
        this.renderScheduleInfo(matrixStack, x, y);
        this.renderTaskButtonInfo(matrixStack, x, y);
        this.modelDownload.renderExtraTips(matrixStack);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        this.drawTaskPageCount(matrixStack);
    }

    private void addStateButton() {
        this.skin = new ImageButton(this.field_147003_i + 62, this.field_147009_r + 14, 9, 9, 72, 43, 10, BUTTON, b -> this.getMinecraft().func_147108_a((Screen)new MaidModelGui(this.maid)));
        this.info = new ImageButton(this.field_147003_i + 8, this.field_147009_r + 14, 9, 9, 72, 65, 10, BUTTON, GuiTools.NO_ACTION);
        this.sound = new ImageButton(this.field_147003_i + 52, this.field_147009_r + 14, 9, 9, 144, 43, 10, BUTTON, b -> this.getMinecraft().func_147108_a((Screen)new MaidSoundPackGui(this.maid)));
        this.func_230480_a_((Widget)this.skin);
        this.func_230480_a_((Widget)this.info);
        this.func_230480_a_((Widget)this.sound);
    }

    private void addTaskControlButton() {
        this.pageDown = new ImageButton(this.field_147003_i - 72, this.field_147009_r + 9, 16, 13, 93, 0, 14, TASK, b -> {
            List<IMaidTask> tasks = TaskManager.getTaskIndex();
            if (TASK_PAGE * 12 + 12 < tasks.size()) {
                ++TASK_PAGE;
                this.func_231160_c_();
            }
        });
        this.pageUp = new ImageButton(this.field_147003_i - 89, this.field_147009_r + 9, 16, 13, 110, 0, 14, TASK, b -> {
            if (TASK_PAGE > 0) {
                --TASK_PAGE;
                this.func_231160_c_();
            }
        });
        this.pageClose = new ImageButton(this.field_147003_i - 19, this.field_147009_r + 9, 13, 13, 127, 0, 14, TASK, b -> {
            this.taskListOpen = false;
            this.func_231160_c_();
        });
        this.func_230480_a_((Widget)this.pageUp);
        this.func_230480_a_((Widget)this.pageDown);
        this.func_230480_a_((Widget)this.pageClose);
        this.pageUp.field_230694_p_ = this.taskListOpen;
        this.pageDown.field_230694_p_ = this.taskListOpen;
        this.pageClose.field_230694_p_ = this.taskListOpen;
    }

    private void addTaskListButton() {
        List<IMaidTask> tasks = TaskManager.getTaskIndex();
        if (TASK_PAGE * 12 >= tasks.size()) {
            TASK_PAGE = 0;
        }
        for (int count = 0; count < 12; ++count) {
            int index = TASK_PAGE * 12 + count;
            if (index >= tasks.size()) continue;
            this.drawPerTaskButton(tasks, count, index);
        }
    }

    private void drawPerTaskButton(List<IMaidTask> tasks, int count, int index) {
        IMaidTask maidTask = tasks.get(index);
        TaskButton button = new TaskButton(maidTask, this.field_147003_i - 89, this.field_147009_r + 23 + 19 * count, 83, 19, 93, 28, 20, TASK, 256, 256, b -> NetworkHandler.CHANNEL.sendToServer((Object)new MaidTaskMessage(this.maid.func_145782_y(), maidTask.getUid())), (b, m, x, y) -> GuiUtils.drawHoveringText((MatrixStack)m, this.getTaskTooltips(maidTask), (int)x, (int)y, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)180, (FontRenderer)this.field_230712_o_), StringTextComponent.field_240750_d_);
        this.func_230480_a_((Widget)button);
        button.field_230694_p_ = this.taskListOpen;
    }

    private List<ITextComponent> getTaskTooltips(IMaidTask maidTask) {
        List<Pair<String, Predicate<EntityMaid>>> conditions;
        List<ITextComponent> desc = ParseI18n.keysToTrans(maidTask.getDescription(this.maid), TextFormatting.GRAY);
        if (!desc.isEmpty()) {
            desc.add(0, (ITextComponent)new TranslationTextComponent("task.touhou_little_maid.desc.title").func_240699_a_(TextFormatting.GOLD));
        }
        if (!(conditions = maidTask.getConditionDescription(this.maid)).isEmpty()) {
            desc.add((ITextComponent)new StringTextComponent(" "));
            desc.add((ITextComponent)new TranslationTextComponent("task.touhou_little_maid.desc.condition").func_240699_a_(TextFormatting.GOLD));
        }
        for (Pair<String, Predicate<EntityMaid>> line : conditions) {
            StringTextComponent prefix = new StringTextComponent("- ");
            String key = String.format("task.%s.%s.condition.%s", maidTask.getUid().func_110624_b(), maidTask.getUid().func_110623_a(), line.getFirst());
            TranslationTextComponent condition = new TranslationTextComponent(key);
            if (((Predicate)line.getSecond()).test(this.maid)) {
                condition.func_240699_a_(TextFormatting.GREEN);
            } else {
                condition.func_240699_a_(TextFormatting.RED);
            }
            desc.add((ITextComponent)prefix.func_230529_a_((ITextComponent)condition));
        }
        if (this.getMinecraft().field_71474_y.field_82882_x) {
            desc.add(StringTextComponent.field_240750_d_);
            desc.add((ITextComponent)new TranslationTextComponent("task.touhou_little_maid.advanced.id", new Object[]{maidTask.getUid().func_110623_a()}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        return desc;
    }

    private void addScheduleButton() {
        this.scheduleButton = new ScheduleButton(this.field_147003_i + 9, this.field_147009_r + 187, this);
        this.func_230480_a_((Widget)this.scheduleButton);
    }

    private void addTabsButton() {
        MaidTabButton[] tabs;
        MaidTabs maidTabs = new MaidTabs(this.maid.func_145782_y(), this.field_147003_i, this.field_147009_r);
        for (MaidTabButton button : tabs = maidTabs.getTabs(this)) {
            this.func_230480_a_((Widget)button);
        }
    }

    private void addTaskSwitchButton() {
        this.taskSwitch = new ImageButton(this.field_147003_i + 4, this.field_147009_r + 159, 71, 21, 0, 42, 22, BUTTON, b -> {
            this.taskListOpen = !this.taskListOpen;
            this.func_231160_c_();
        });
        this.func_230480_a_((Widget)this.taskSwitch);
    }

    private void addRideButton() {
        this.ride = new ToggleWidget(this.field_147003_i + 51, this.field_147009_r + 206, 20, 20, this.maid.isRideable()){

            public void func_230982_a_(double mouseX, double mouseY) {
                this.field_191755_p = !this.field_191755_p;
                NetworkHandler.CHANNEL.sendToServer((Object)new MaidConfigMessage(AbstractMaidContainerGui.this.maid.func_145782_y(), AbstractMaidContainerGui.this.maid.isHomeModeEnable(), AbstractMaidContainerGui.this.maid.isPickup(), this.field_191755_p, AbstractMaidContainerGui.this.maid.getSchedule()));
            }
        };
        this.ride.func_191751_a(84, 0, 21, 21, BUTTON);
        this.func_230480_a_((Widget)this.ride);
    }

    private void addPickButton() {
        this.pick = new ToggleWidget(this.field_147003_i + 30, this.field_147009_r + 206, 20, 20, this.maid.isPickup()){

            public void func_230982_a_(double mouseX, double mouseY) {
                this.field_191755_p = !this.field_191755_p;
                NetworkHandler.CHANNEL.sendToServer((Object)new MaidConfigMessage(AbstractMaidContainerGui.this.maid.func_145782_y(), AbstractMaidContainerGui.this.maid.isHomeModeEnable(), this.field_191755_p, AbstractMaidContainerGui.this.maid.isRideable(), AbstractMaidContainerGui.this.maid.getSchedule()));
            }
        };
        this.pick.func_191751_a(42, 0, 21, 21, BUTTON);
        this.func_230480_a_((Widget)this.pick);
    }

    private void addHomeButton() {
        this.home = new ToggleWidget(this.field_147003_i + 9, this.field_147009_r + 206, 20, 20, this.maid.isHomeModeEnable()){

            public void func_230982_a_(double mouseX, double mouseY) {
                this.field_191755_p = !this.field_191755_p;
                NetworkHandler.CHANNEL.sendToServer((Object)new MaidConfigMessage(AbstractMaidContainerGui.this.maid.func_145782_y(), this.field_191755_p, AbstractMaidContainerGui.this.maid.isPickup(), AbstractMaidContainerGui.this.maid.isRideable(), AbstractMaidContainerGui.this.maid.getSchedule()));
            }
        };
        this.home.func_191751_a(0, 0, 21, 21, BUTTON);
        this.func_230480_a_((Widget)this.home);
    }

    private void addDownloadButton() {
        this.modelDownload = new MaidDownloadButton(this.field_147003_i + 20, this.field_147009_r + 230, BUTTON);
        this.func_230480_a_((Widget)this.modelDownload);
    }

    private void drawTaskPageCount(MatrixStack matrixStack) {
        if (this.taskListOpen) {
            String text = String.format("%d/%d", TASK_PAGE + 1, TaskManager.getTaskIndex().size() / 12 + 1);
            this.field_230712_o_.func_238421_b_(matrixStack, text, -48.0f, 12.0f, 0x333333);
        }
    }

    private void drawCurrentTaskText(MatrixStack matrixStack) {
        IMaidTask task = this.maid.getTask();
        this.field_230707_j_.func_175042_a(task.getIcon(), this.field_147003_i + 6, this.field_147009_r + 161);
        List splitTexts = this.field_230712_o_.func_238425_b_((ITextProperties)task.getName(), 42);
        if (!splitTexts.isEmpty()) {
            this.field_230712_o_.func_238422_b_(matrixStack, (IReorderingProcessor)splitTexts.get(0), (float)(this.field_147003_i + 28), (float)(this.field_147009_r + 165), 0x333333);
        }
    }

    private void renderMaidInfo(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.info.func_230449_g_()) {
            ArrayList list = Lists.newArrayList();
            String prefix = "\u00a7a\u2588 ";
            IFormattableTextComponent title = new StringTextComponent("").func_230529_a_((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.info.title").func_240701_a_(new TextFormatting[]{TextFormatting.GOLD, TextFormatting.UNDERLINE})).func_230529_a_((ITextComponent)new StringTextComponent("\u00a7r "));
            if (this.maid.isStruckByLightning()) {
                title.func_230529_a_((ITextComponent)new StringTextComponent("\u2740").func_240699_a_(TextFormatting.DARK_RED));
            }
            if (this.maid.func_190530_aW()) {
                title.func_230529_a_((ITextComponent)new StringTextComponent("\u271f").func_240699_a_(TextFormatting.BLUE));
            }
            list.add(title);
            if (this.maid.func_70902_q() != null) {
                list.add(new StringTextComponent(prefix).func_240699_a_(TextFormatting.WHITE).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.info.owner").func_240702_b_(": ").func_240699_a_(TextFormatting.AQUA)).func_230529_a_(this.maid.func_70902_q().func_145748_c_()));
            }
            CustomPackLoader.MAID_MODELS.getInfo(this.maid.getModelId()).ifPresent(info -> list.add(new StringTextComponent(prefix).func_240699_a_(TextFormatting.WHITE).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.info.model_name").func_240702_b_(": ").func_240699_a_(TextFormatting.AQUA)).func_230529_a_(ParseI18n.parse(info.getName()))));
            list.add(new StringTextComponent(prefix).func_240699_a_(TextFormatting.WHITE).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.info.experience").func_240702_b_(": ").func_240699_a_(TextFormatting.AQUA)).func_240702_b_(String.valueOf(this.maid.getExperience())));
            list.add(new StringTextComponent(prefix).func_240699_a_(TextFormatting.WHITE).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.info.favorability").func_240702_b_(": ").func_240699_a_(TextFormatting.AQUA)).func_240702_b_(String.valueOf(this.maid.getFavorability())));
            list.add(new StringTextComponent(prefix).func_240699_a_(TextFormatting.WHITE).func_230529_a_((ITextComponent)new TranslationTextComponent("block.touhou_little_maid.gomoku").func_240702_b_(": ").func_240699_a_(TextFormatting.AQUA)).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.info.game_skill.gomoku", new Object[]{MaidGomokuAI.getMaidCount(this.maid), MaidGomokuAI.getRank(this.maid)})));
            this.func_243308_b(matrixStack, list, mouseX, mouseY);
        }
    }

    private void renderScheduleInfo(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.scheduleButton.func_230449_g_()) {
            this.func_243308_b(matrixStack, this.scheduleButton.getTooltips(), mouseX, mouseY);
        }
    }

    private void renderTaskButtonInfo(MatrixStack matrixStack, int x, int y) {
        this.field_230710_m_.stream().filter(b -> b instanceof TaskButton).forEach(b -> {
            if (b.func_230449_g_()) {
                b.func_230443_a_(matrixStack, x, y);
            }
        });
    }

    private void drawMaidCharacter(int x, int y) {
        double scale = this.getMinecraft().func_228018_at_().func_198100_s();
        RenderSystem.enableScissor((int)((int)((double)(this.field_147003_i + 6) * scale)), (int)((int)((double)(this.field_147009_r + 107 + 42) * scale)), (int)((int)(67.0 * scale)), (int)((int)(95.0 * scale)));
        InventoryScreen.func_228187_a_((int)(this.field_147003_i + 40), (int)(this.field_147009_r + 100), (int)40, (float)(this.field_147003_i + 40 - x), (float)(this.field_147009_r + 70 - 20 - y), (LivingEntity)this.maid);
        RenderSystem.disableScissor();
    }

    private void drawTaskListBg(MatrixStack matrixStack) {
        if (this.taskListOpen) {
            this.getMinecraft().field_71446_o.func_110577_a(TASK);
            this.func_238474_b_(matrixStack, this.field_147003_i - 93, this.field_147009_r + 5, 0, 0, 92, 251);
        }
    }

    private void drawBaseInfoGui(MatrixStack matrixStack) {
        matrixStack.func_227861_a_(0.0, 0.0, 200.0);
        this.getMinecraft().field_71446_o.func_110577_a(SIDE);
        this.func_238474_b_(matrixStack, this.field_147003_i + 5, this.field_147009_r + 113, 0, 0, 9, 9);
        this.func_238474_b_(matrixStack, this.field_147003_i + 27, this.field_147009_r + 113, 0, 9, 47, 9);
        double hp = this.maid.func_110143_aJ() / this.maid.func_110138_aP();
        this.func_238474_b_(matrixStack, this.field_147003_i + 29, this.field_147009_r + 115, 2, 18, (int)(43.0 * hp), 5);
        this.getMinecraft().field_71466_p.func_238421_b_(matrixStack, String.format("%.0f", Float.valueOf(this.maid.func_110143_aJ())), (float)(this.field_147003_i + 15), (float)(this.field_147009_r + 114), TextFormatting.DARK_GRAY.func_211163_e().intValue());
        this.getMinecraft().field_71446_o.func_110577_a(SIDE);
        this.func_238474_b_(matrixStack, this.field_147003_i + 5, this.field_147009_r + 124, 9, 0, 9, 9);
        this.func_238474_b_(matrixStack, this.field_147003_i + 27, this.field_147009_r + 124, 0, 9, 47, 9);
        double armor = this.maid.func_233637_b_(Attributes.field_233826_i_) / 20.0;
        this.func_238474_b_(matrixStack, this.field_147003_i + 29, this.field_147009_r + 126, 2, 23, (int)(43.0 * armor), 5);
        this.getMinecraft().field_71466_p.func_238421_b_(matrixStack, String.format("%d", this.maid.func_70658_aO()), (float)(this.field_147003_i + 15), (float)(this.field_147009_r + 125), TextFormatting.DARK_GRAY.func_211163_e().intValue());
        this.getMinecraft().field_71446_o.func_110577_a(SIDE);
        this.func_238474_b_(matrixStack, this.field_147003_i + 5, this.field_147009_r + 135, 18, 0, 9, 9);
        this.func_238474_b_(matrixStack, this.field_147003_i + 27, this.field_147009_r + 135, 0, 9, 47, 9);
        int exp = this.maid.getExperience();
        int count = exp / 120;
        double percent = (double)(exp % 120) / 120.0;
        this.func_238474_b_(matrixStack, this.field_147003_i + 29, this.field_147009_r + 137, 2, 28, (int)(43.0 * percent), 5);
        this.getMinecraft().field_71466_p.func_238421_b_(matrixStack, String.format("%d", count), (float)(this.field_147003_i + 15), (float)(this.field_147009_r + 136), TextFormatting.DARK_GRAY.func_211163_e().intValue());
        this.getMinecraft().field_71446_o.func_110577_a(SIDE);
        this.func_238474_b_(matrixStack, this.field_147003_i + 5, this.field_147009_r + 146, 27, 0, 9, 9);
        this.func_238474_b_(matrixStack, this.field_147003_i + 27, this.field_147009_r + 146, 0, 9, 47, 9);
        FavorabilityManager manager = this.maid.getFavorabilityManager();
        double percent2 = manager.getLevelPercent();
        this.func_238474_b_(matrixStack, this.field_147003_i + 29, this.field_147009_r + 148, 2, 33, (int)(43.0 * percent2), 5);
        this.getMinecraft().field_71466_p.func_238421_b_(matrixStack, String.format("%d", manager.getLevel()), (float)(this.field_147003_i + 15), (float)(this.field_147009_r + 147), TextFormatting.DARK_GRAY.func_211163_e().intValue());
        this.getMinecraft().field_71446_o.func_110577_a(SIDE);
        this.func_238474_b_(matrixStack, this.field_147003_i + 94, this.field_147009_r + 7, 107, 0, 149, 21);
        this.func_238474_b_(matrixStack, this.field_147003_i + 6, this.field_147009_r + 178, 0, 47, 67, 25);
    }

    public void func_231023_e_() {
        ++this.counterTime;
        if (this.counterTime % 20 == 0 && this.maid != null) {
            NetworkHandler.CHANNEL.sendToServer((Object)new RequestEffectMessage(this.maid.func_145782_y()));
        }
    }

    public int getGuiLeft() {
        if (this.taskListOpen) {
            return this.field_147003_i - 93;
        }
        return this.field_147003_i;
    }

    public int getXSize() {
        if (this.taskListOpen) {
            return this.field_146999_f + 93;
        }
        return this.field_146999_f;
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    private void renderTransTooltip(ImageButton button, MatrixStack matrixStack, int x, int y, String key) {
        if (button.func_230449_g_()) {
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, Collections.singletonList(new TranslationTextComponent(key)), (int)x, (int)y, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)180, (FontRenderer)this.field_230712_o_);
        }
    }

    private void renderTransTooltip(ToggleWidget button, MatrixStack matrixStack, int x, int y, String key) {
        if (button.func_230449_g_()) {
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, (List)Lists.newArrayList((Object[])new TranslationTextComponent[]{new TranslationTextComponent(key + "." + button.func_191754_c()), new TranslationTextComponent(key + ".desc")}), (int)x, (int)y, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)180, (FontRenderer)this.field_230712_o_);
        }
    }
}

