/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.SkinGuiNumber;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ImageButtonWithId;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class AbstractModelGui<T extends LivingEntity, E extends IModelInfo>
extends Screen {
    public static final Button.IPressable NO_PRESS = b -> {};
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/skin_select.png");
    private static final ResourceLocation SIDE = new ResourceLocation("touhou_little_maid", "textures/gui/skin_select_side.png");
    private static final ResourceLocation EMPTY_ICON = new ResourceLocation("touhou_little_maid", "textures/gui/empty_model_pack_icon.png");
    protected final T entity;
    private final SkinGuiNumber<E> guiNumber;
    private final List<CustomModelPack<E>> modelPackList;

    public AbstractModelGui(T entity, List<CustomModelPack<E>> listPack) {
        super((ITextComponent)new StringTextComponent("Custom Model GUI"));
        this.entity = entity;
        this.modelPackList = listPack;
        this.guiNumber = new SkinGuiNumber(this.modelPackList);
        this.setPageIndex(MathHelper.func_76125_a((int)this.getPageIndex(), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
        this.setPackIndex(MathHelper.func_76125_a((int)this.getPackIndex(), (int)0, (int)(this.guiNumber.getPackSize() - 1)));
        this.setRowIndex(MathHelper.func_76125_a((int)this.getRowIndex(), (int)0, (int)this.guiNumber.getRowSize(this.getPackIndex())));
    }

    protected abstract void drawLeftEntity(int var1, int var2, float var3, float var4);

    protected abstract void drawRightEntity(int var1, int var2, E var3);

    protected abstract void openDetailsGui(T var1, E var2);

    protected abstract void notifyModelChange(T var1, E var2);

    protected abstract void addModelCustomTips(E var1, List<ITextComponent> var2);

    protected abstract int getPackIndex();

    protected abstract void setPackIndex(int var1);

    protected abstract int getRowIndex();

    protected abstract void setRowIndex(int var1);

    protected abstract int getPageIndex();

    protected abstract void setPageIndex(int var1);

    public void func_231160_c_() {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        int startX = this.field_230708_k_ / 2 + 50;
        int startY = this.field_230709_l_ / 2 + 5;
        for (int index = 0; index < 7; ++index) {
            this.addTabButton(startX, startY, index);
        }
        this.func_230480_a_((Widget)new ImageButton(startX + 122, startY - 97, 21, 17, 58, 201, 18, BG, b -> this.getMinecraft().func_222817_e(() -> this.getMinecraft().func_147108_a(null))));
        this.addPageButton(startX, startY);
        this.addModelButton(startX, startY);
    }

    private void addModelButton(int startX, int startY) {
        CustomModelPack<E> pack = this.modelPackList.get(this.getPackIndex());
        int offsetX = -100;
        int offsetY = -35;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        int toIndex = this.guiNumber.modelToIndex(this.getPackIndex(), this.getRowIndex());
        for (IModelInfo modelItem : pack.getModelList().subList(fromIndex, toIndex)) {
            this.func_230480_a_((Widget)new ImageButton(startX + offsetX - 8, startY + offsetY - 26, 15, 24, 41, 201, 24, BG, this.onModelButtonClick(modelItem)));
            if ((offsetX += 20) <= 105) continue;
            offsetX = -100;
            offsetY += 30;
        }
    }

    private void addScrollButton(int startX, int startY) {
        ImageButton upButton = new ImageButton(startX - 128 + 253, startY - 73, 14, 10, 24, 15, 10, SIDE, b -> {
            int row = MathHelper.func_76125_a((int)(this.getRowIndex() - 1), (int)0, (int)this.guiNumber.getRowSize(this.getPackIndex()));
            if (row != this.getRowIndex()) {
                this.setRowIndex(row);
                this.func_231160_c_();
            }
        });
        ImageButton downButton = new ImageButton(startX - 128 + 253, startY - 73 + 156, 14, 10, 38, 15, 10, SIDE, b -> {
            int row = MathHelper.func_76125_a((int)(this.getRowIndex() + 1), (int)0, (int)this.guiNumber.getRowSize(this.getPackIndex()));
            if (row != this.getRowIndex()) {
                this.setRowIndex(row);
                this.func_231160_c_();
            }
        });
        this.func_230480_a_((Widget)upButton);
        this.func_230480_a_((Widget)downButton);
    }

    private Button.IPressable onModelButtonClick(E modelItem) {
        return button -> {
            if (AbstractModelGui.func_231173_s_()) {
                this.openDetailsGui(this.entity, modelItem);
            } else {
                this.notifyModelChange(this.entity, modelItem);
            }
        };
    }

    private void addPageButton(int startX, int startY) {
        Button prePage = new Button(startX - 119, startY - 101, 20, 20, (ITextComponent)new StringTextComponent("<"), b -> {
            this.setRowIndex(0);
            this.setPageIndex(MathHelper.func_76125_a((int)(this.getPageIndex() - 1), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
            this.setPackIndex(this.guiNumber.tabToPackIndex(0, this.getPageIndex()));
            this.func_231160_c_();
        });
        Button nextPage = new Button(startX + 99, startY - 101, 20, 20, (ITextComponent)new StringTextComponent(">"), b -> {
            this.setRowIndex(0);
            this.setPageIndex(MathHelper.func_76125_a((int)(this.getPageIndex() + 1), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
            this.setPackIndex(this.guiNumber.tabToPackIndex(0, this.getPageIndex()));
            this.func_231160_c_();
        });
        if (this.getPageIndex() == 0) {
            prePage.field_230693_o_ = false;
        }
        if (this.getPageIndex() == this.guiNumber.getPageSize() - 1) {
            nextPage.field_230693_o_ = false;
        }
        this.func_230480_a_((Widget)prePage);
        this.func_230480_a_((Widget)nextPage);
    }

    private void addTabButton(int startX, int startY, int index) {
        if (index == this.guiNumber.getTabIndex(this.getPackIndex())) {
            this.func_230480_a_((Widget)new ImageButton(startX - 98 + 28 * index, startY - 108, 28, 31, 116, 224, 0, BG, NO_PRESS));
        } else if (index < this.guiNumber.getTabSize(this.getPackIndex())) {
            this.func_230480_a_((Widget)new ImageButtonWithId(index, startX - 98 + 28 * index, startY - 105, 28, 25, 116, 194, 0, BG, b -> {
                this.setRowIndex(0);
                this.setPackIndex(this.guiNumber.tabToPackIndex(((ImageButtonWithId)b).getIndex(), this.getPageIndex()));
                this.func_231160_c_();
            }));
        } else {
            ImageButton buttonImage = new ImageButton(startX - 98 + 28 * index, startY - 105, 28, 25, 116, 194, 0, BG, NO_PRESS);
            buttonImage.field_230694_p_ = false;
            this.func_230480_a_((Widget)buttonImage);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.func_227861_a_(0.0, 0.0, -100.0);
        int middleX = this.field_230708_k_ / 2 + 50;
        int middleY = this.field_230709_l_ / 2 + 5;
        this.func_230446_a_(matrixStack);
        this.getMinecraft().field_71446_o.func_110577_a(BG);
        this.func_238474_b_(matrixStack, middleX - 128, middleY - 80, 0, 0, 256, 180);
        this.getMinecraft().field_71446_o.func_110577_a(SIDE);
        this.func_238474_b_(matrixStack, middleX - 128 + 250, middleY - 80, 0, 0, 24, 180);
        this.drawScrollSide(matrixStack, middleX, middleY);
        this.drawButton(matrixStack, mouseX, mouseY, partialTicks);
        this.drawTabIcon(matrixStack, middleX, middleY);
        double scale = this.getMinecraft().func_228018_at_().func_198100_s();
        RenderSystem.enableScissor((int)0, (int)0, (int)((int)((double)(middleX - 128) * scale)), (int)((int)((double)this.field_230709_l_ * scale)));
        this.drawLeftEntity(middleX, middleY, mouseX, mouseY);
        RenderSystem.disableScissor();
        this.drawEntity(matrixStack, middleX, middleY);
        this.drawTooltips(matrixStack, mouseX, mouseY, middleX, middleY);
        this.addScrollButton(middleX, middleY);
    }

    private void drawButton(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (Widget button : this.field_230710_m_) {
            button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    private void drawScrollSide(MatrixStack matrixStack, int middleX, int middleY) {
        if (this.guiNumber.canScroll(this.getPackIndex(), this.getRowIndex())) {
            this.func_238474_b_(matrixStack, middleX - 128 + 254, middleY - 61 + (int)(127.0f * this.guiNumber.getCurrentScroll(this.getPackIndex(), this.getRowIndex())), 24, 0, 12, 15);
        } else {
            this.func_238474_b_(matrixStack, middleX - 128 + 254, middleY - 61 + (int)(127.0f * this.guiNumber.getCurrentScroll(this.getPackIndex(), this.getRowIndex())), 36, 0, 12, 15);
        }
    }

    private void drawTabIcon(MatrixStack matrixStack, int middleX, int middleY) {
        int size = this.guiNumber.getTabSize(this.getPackIndex());
        for (int index = 0; index < size; ++index) {
            CustomModelPack<E> pack = this.modelPackList.get(this.guiNumber.tabToPackIndex(index, this.getPageIndex()));
            ResourceLocation icon = pack.getIcon();
            if (icon == null) continue;
            Texture iconTexture = Minecraft.func_71410_x().field_71446_o.func_229267_b_(icon);
            if (iconTexture == null) {
                icon = EMPTY_ICON;
            }
            if (pack.getIconAnimation() == CustomModelPack.AnimationState.UNCHECK) {
                this.checkIconAnimation(pack, icon);
            }
            if (pack.getIconAnimation() == CustomModelPack.AnimationState.FALSE) {
                this.getMinecraft().field_71446_o.func_110577_a(icon);
                AbstractModelGui.func_238463_a_((MatrixStack)matrixStack, (int)(middleX - 92 + 28 * index), (int)(middleY - 98), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                continue;
            }
            this.getMinecraft().field_71446_o.func_110577_a(icon);
            int time = this.getTickTime() / pack.getIconDelay();
            int iconIndex = time % pack.getIconAspectRatio();
            AbstractModelGui.func_238463_a_((MatrixStack)matrixStack, (int)(middleX - 92 + 28 * index), (int)(middleY - 98), (float)0.0f, (float)(iconIndex * 16), (int)16, (int)16, (int)16, (int)(16 * pack.getIconAspectRatio()));
        }
    }

    private int getTickTime() {
        return (int)System.currentTimeMillis() / 50;
    }

    private void checkIconAnimation(CustomModelPack<E> pack, ResourceLocation icon) {
        Texture iconText = this.getMinecraft().field_71446_o.func_229267_b_(icon);
        if (iconText instanceof SizeTexture) {
            int height;
            int width = ((SizeTexture)iconText).getWidth();
            if (width >= (height = ((SizeTexture)iconText).getHeight())) {
                pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
            } else {
                pack.setIconAnimation(CustomModelPack.AnimationState.TRUE);
                pack.setIconAspectRatio(height / width);
            }
        } else {
            pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
        }
    }

    private void drawEntity(MatrixStack matrixStack, int middleX, int middleY) {
        CustomModelPack<E> pack = this.modelPackList.get(this.getPackIndex());
        this.drawPackInfoText(matrixStack, pack, middleX, middleY);
        int offsetX = -100;
        int offsetY = -38;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        int toIndex = this.guiNumber.modelToIndex(this.getPackIndex(), this.getRowIndex());
        for (IModelInfo modelItem : pack.getModelList().subList(fromIndex, toIndex)) {
            this.drawRightEntity(middleX + offsetX, middleY + offsetY, modelItem);
            if ((offsetX += 20) <= 105) continue;
            offsetX = -100;
            offsetY += 30;
        }
    }

    private void drawPackInfoText(MatrixStack matrixStack, CustomModelPack<E> pack, int middleX, int middleY) {
        int offsetY = -80;
        int sideMiddleX = (middleX - 128) / 2;
        ITextComponent packName = ParseI18n.parse(pack.getPackName());
        List packSplitName = this.field_230712_o_.func_238420_b_().func_238362_b_((ITextProperties)packName, middleX - 128 - 20, Style.field_240709_b_);
        for (ITextProperties properties : packSplitName) {
            AbstractModelGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)properties.getString(), (int)sideMiddleX, (int)(middleY + (offsetY += 10)), (int)0xFFFFFF);
        }
        for (ITextComponent str : ParseI18n.parse(pack.getDescription())) {
            List split = this.field_230712_o_.func_238420_b_().func_238362_b_((ITextProperties)str, middleX - 128 - 20, Style.field_240709_b_);
            for (ITextProperties properties : split) {
                AbstractModelGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)properties.getString(), (int)sideMiddleX, (int)(middleY + (offsetY += 10)), (int)TextFormatting.DARK_GRAY.func_211163_e());
            }
        }
        if (!pack.getAuthor().isEmpty()) {
            for (List textList : Lists.partition(pack.getAuthor(), (int)2)) {
                AbstractModelGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent(textList.toString()).func_240699_a_(TextFormatting.GOLD), (int)sideMiddleX, (int)(middleY + (offsetY += 10)), (int)0xFFFFFF);
            }
        }
        if (pack.getVersion() != null) {
            AbstractModelGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.skin.text.version", new Object[]{pack.getVersion()}).func_240699_a_(TextFormatting.DARK_AQUA), (int)sideMiddleX, (int)(middleY + (offsetY += 10)), (int)0xFFFFFF);
        }
        if (pack.getDate() != null) {
            AbstractModelGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.skin.text.date", new Object[]{pack.getDate()}).func_240699_a_(TextFormatting.GREEN), (int)sideMiddleX, (int)(middleY + (offsetY += 10)), (int)0xFFFFFF);
        }
        AbstractModelGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)String.format("%s/%s", this.getPageIndex() + 1, this.guiNumber.getPageSize()), (int)middleX, (int)(middleY - 120), (int)0xFFFFFF);
    }

    private void drawTooltips(MatrixStack matrixStack, int mouseX, int mouseY, int middleX, int middleY) {
        boolean yInRange;
        boolean isyInRange;
        boolean isxInRange;
        CustomModelPack<E> pack = this.modelPackList.get(this.getPackIndex());
        int offsetX = -100;
        int offsetY = -35;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        int toIndex = this.guiNumber.modelToIndex(this.getPackIndex(), this.getRowIndex());
        for (IModelInfo modelItem : pack.getModelList().subList(fromIndex, toIndex)) {
            isxInRange = middleX + offsetX - 8 < mouseX && mouseX < middleX + offsetX + 7;
            boolean bl = isyInRange = middleY + offsetY - 23 < mouseY && mouseY < middleY + offsetY + 1;
            if (isxInRange && isyInRange) {
                ArrayList<String> str = new ArrayList<String>();
                str.add(modelItem.getName());
                str.addAll(modelItem.getDescription());
                List<ITextComponent> tooltips = ParseI18n.parse(str);
                this.addModelCustomTips(modelItem, tooltips);
                if (!modelItem.getName().equals("{gui.touhou_little_maid.model_gui.easter_egg.encrypt}") && !modelItem.getName().equals("{gui.touhou_little_maid.model_gui.easter_egg.normal}")) {
                    tooltips.add((ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.skin.tooltips.show_details").func_240701_a_(new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.ITALIC}));
                }
                this.func_243308_b(matrixStack, tooltips, mouseX, mouseY);
            }
            if ((offsetX += 20) <= 105) continue;
            offsetX = -100;
            offsetY += 30;
        }
        int size = this.guiNumber.getTabSize(this.getPackIndex());
        for (int index = 0; index < size; ++index) {
            isxInRange = middleX - 98 + 28 * index < mouseX && mouseX < middleX - 98 + 28 * index + 28;
            boolean bl = isyInRange = middleY - 108 < mouseY && mouseY < middleY - 108 + 31;
            if (!isxInRange || !isyInRange) continue;
            CustomModelPack<E> hoverPack = this.modelPackList.get(this.guiNumber.tabToPackIndex(index, this.getPageIndex()));
            this.func_238652_a_(matrixStack, ParseI18n.parse(hoverPack.getPackName()), mouseX, mouseY);
        }
        boolean xInRange = middleX + 122 < mouseX && mouseX < middleX + 143;
        boolean bl = yInRange = middleY - 97 < mouseY && mouseY < middleY - 80;
        if (xInRange && yInRange) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.skin.button.close"), mouseX, mouseY);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            int row;
            int index = 0;
            if (delta > 0.0) {
                index = 1;
            }
            if (delta < 0.0) {
                index = -1;
            }
            if ((row = MathHelper.func_76125_a((int)(this.getRowIndex() - index), (int)0, (int)this.guiNumber.getRowSize(this.getPackIndex()))) != this.getRowIndex()) {
                this.setRowIndex(row);
                this.func_231160_c_();
                return true;
            }
        }
        return super.func_231043_a_(mouseX, mouseY, delta);
    }

    public boolean func_231177_au__() {
        return false;
    }
}

