/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.FoxScrollMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetScrollData;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;

public class FoxScrollScreen
extends Screen {
    private static final int PER_PAGE_COUNT = 5;
    private final Map<String, List<FoxScrollMessage.FoxScrollData>> data;
    private int leftPos;
    private int topPos;
    private String selectDim;
    private int page = 0;

    public FoxScrollScreen(Map<String, List<FoxScrollMessage.FoxScrollData>> data) {
        super((ITextComponent)new StringTextComponent("Red Fox Scroll"));
        this.data = data;
        if (!this.data.isEmpty()) {
            this.selectDim = (String)this.data.keySet().stream().findFirst().get();
        }
    }

    protected void func_231160_c_() {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.leftPos = (this.field_230708_k_ - 400) / 2;
        this.topPos = (this.field_230709_l_ - 208) / 2;
        this.addDimensionButtons();
        this.addPointButtons();
    }

    private void addPointButtons() {
        if (StringUtils.isNotBlank((CharSequence)this.selectDim) && this.data.containsKey(this.selectDim)) {
            List<FoxScrollMessage.FoxScrollData> scrollData = this.data.get(this.selectDim);
            if (scrollData.size() > 5) {
                this.func_230480_a_((Widget)new FlatColorButton(this.leftPos + 400 - 20, this.topPos, 20, 20, (ITextComponent)new StringTextComponent("\u2191"), b -> {
                    if (this.page > 0) {
                        --this.page;
                        this.func_231160_c_();
                    }
                }));
                this.func_230480_a_((Widget)new FlatColorButton(this.leftPos + 400 - 20, this.topPos + 208 - 20, 20, 20, (ITextComponent)new StringTextComponent("\u2193"), b -> {
                    if (this.page < (scrollData.size() - 1) / 5) {
                        ++this.page;
                        this.func_231160_c_();
                    }
                }));
            }
            int offsetIn = this.topPos;
            for (int i = this.page * 5; i < this.page * 5 + 5; ++i) {
                if (i >= scrollData.size()) continue;
                FoxScrollMessage.FoxScrollData info = scrollData.get(i);
                this.func_230480_a_((Widget)new FlatColorButton(this.leftPos + 400 - 90, offsetIn + 11, 60, 20, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.fox_scroll.track"), b -> NetworkHandler.CHANNEL.sendToServer((Object)new SetScrollData(this.selectDim, info.getPos()))));
                offsetIn += 42;
            }
        }
    }

    private void addDimensionButtons() {
        int offset = this.topPos;
        for (String dim : this.data.keySet()) {
            StringTextComponent name = new StringTextComponent(dim);
            FlatColorButton dimButton = new FlatColorButton(this.leftPos, offset, 150, 19, (ITextComponent)name, b -> {
                this.selectDim = dim;
                this.page = 0;
                this.func_231160_c_();
            });
            if (dim.equals(this.selectDim)) {
                dimButton.setSelect(true);
            }
            this.func_230480_a_((Widget)dimButton);
            offset += 21;
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.func_230446_a_(matrixStack);
        if (this.data.isEmpty()) {
            int x = this.field_230708_k_ / 2;
            int y = this.field_230709_l_ / 2 - 5;
            FoxScrollScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.fox_scroll.empty"), (int)x, (int)y, (int)0xFF0000);
            return;
        }
        this.renderMain(matrixStack);
        super.func_230430_a_(matrixStack, pMouseX, pMouseY, pPartialTick);
    }

    private void renderMain(MatrixStack matrixStack) {
        if (StringUtils.isNotBlank((CharSequence)this.selectDim) && this.data.containsKey(this.selectDim)) {
            List<FoxScrollMessage.FoxScrollData> scrollData = this.data.get(this.selectDim);
            boolean inSameDim = this.selectDim.equals(this.getPlayerDimension());
            BlockPos playerPos = this.getPlayerPos();
            int offsetIn = this.topPos;
            for (int i = this.page * 5; i < this.page * 5 + 5; ++i) {
                TranslationTextComponent distanceText;
                if (i >= scrollData.size()) continue;
                FoxScrollMessage.FoxScrollData info = scrollData.get(i);
                BlockPos pos = info.getPos();
                if (inSameDim) {
                    int distance = (int)Math.sqrt(playerPos.func_177951_i((Vector3i)pos));
                    distanceText = new TranslationTextComponent("gui.touhou_little_maid.fox_scroll.distance.same_dimension", new Object[]{distance});
                } else {
                    distanceText = new TranslationTextComponent("gui.touhou_little_maid.fox_scroll.distance.different_dimension");
                }
                TranslationTextComponent posText = new TranslationTextComponent("gui.touhou_little_maid.fox_scroll.position", new Object[]{pos.func_229422_x_()});
                FoxScrollScreen.func_238467_a_((MatrixStack)matrixStack, (int)(this.leftPos + 152), (int)offsetIn, (int)(this.leftPos + 400 - 22), (int)(offsetIn + 40), (int)-279420309);
                FoxScrollScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)info.getName(), (int)(this.leftPos + 160), (int)(offsetIn + 4), (int)TextFormatting.GOLD.func_211163_e());
                this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)posText, (float)(this.leftPos + 160), (float)(offsetIn + 16), TextFormatting.GRAY.func_211163_e().intValue());
                this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)distanceText, (float)(this.leftPos + 160), (float)(offsetIn + 28), TextFormatting.GRAY.func_211163_e().intValue());
                offsetIn += 42;
            }
            if (scrollData.size() > 5) {
                String pageText = String.format("%d/%d", this.page + 1, (scrollData.size() - 1) / 5 + 1);
                FoxScrollScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)pageText, (int)(this.leftPos + 400 - 8), (int)(this.topPos + 104 - 5), (int)TextFormatting.GRAY.func_211163_e());
            }
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    private BlockPos getPlayerPos() {
        if (this.getMinecraft().field_71439_g != null) {
            return this.getMinecraft().field_71439_g.func_233580_cy_();
        }
        return BlockPos.field_177992_a;
    }

    @Nullable
    private String getPlayerDimension() {
        if (this.getMinecraft().field_71439_g != null) {
            return this.getMinecraft().field_71439_g.field_70170_p.func_234923_W_().func_240901_a_().toString();
        }
        return null;
    }
}

