/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.sound;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.SoundElementButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.SoundPackButton;
import com.github.tartaricacid.touhoulittlemaid.client.sound.CustomSoundLoader;
import com.github.tartaricacid.touhoulittlemaid.client.sound.data.MaidSoundInstance;
import com.github.tartaricacid.touhoulittlemaid.client.sound.pojo.SoundPackInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetMaidSoundIdMessage;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.AudioStreamBuffer;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class MaidSoundPackGui
extends Screen {
    private static final ResourceLocation ICON = new ResourceLocation("touhou_little_maid", "textures/gui/maid_custom_sound.png");
    private final int packPerSize = 4;
    private final int soundPerSize = 13;
    private final EntityMaid maid;
    private String selectSoundId = null;
    private int startX;
    private int startY;
    private int packPage = 0;
    private int soundPage = 0;
    private int packMaxPage = 0;
    private int soundMaxPage = 0;

    public MaidSoundPackGui(EntityMaid maid) {
        super((ITextComponent)new StringTextComponent("Maid Custom Sound Pack GUI"));
        this.maid = maid;
    }

    protected void func_231160_c_() {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.startX = (this.field_230708_k_ - 400) / 2;
        this.startY = (this.field_230709_l_ - 220) / 2;
        this.packMaxPage = (CustomSoundLoader.CACHE.size() - 1) / 4;
        this.soundMaxPage = 0;
        this.addSoundPackButtons();
        this.addPackPageButtons();
        if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId)) {
            this.addSoundElementButtons();
            this.addSoundOtherButtons();
            this.addSoundElementPageButtons();
        }
    }

    private void addPackPageButtons() {
        this.func_230480_a_((Widget)new FlatColorButton(this.startX + 5, this.startY + 201, 32, 16, (ITextComponent)new StringTextComponent("<"), b -> {
            if (this.packPage > 0) {
                --this.packPage;
                this.func_231160_c_();
            }
        }));
        this.func_230480_a_((Widget)new FlatColorButton(this.startX + 203, this.startY + 201, 32, 16, (ITextComponent)new StringTextComponent(">"), b -> {
            if ((this.packPage + 1) * 4 < CustomSoundLoader.CACHE.size()) {
                ++this.packPage;
                this.func_231160_c_();
            }
        }));
    }

    private void addSoundElementButtons() {
        int yOffset = 41;
        boolean otherColor = false;
        Map<ResourceLocation, List<AudioStreamBuffer>> buffers = CustomSoundLoader.getSoundCache(this.selectSoundId).getBuffers();
        ArrayList<ResourceLocation> soundIds = new ArrayList<ResourceLocation>(buffers.keySet());
        this.soundMaxPage = (buffers.size() - 1) / 13;
        int startSoundIndex = this.soundPage * 13;
        if (startSoundIndex >= soundIds.size()) {
            this.soundPage = 0;
            startSoundIndex = 0;
        }
        int endSoundIndex = Math.min(soundIds.size(), startSoundIndex + 13);
        for (int i = startSoundIndex; i < endSoundIndex; ++i) {
            ResourceLocation soundEvent = (ResourceLocation)soundIds.get(i);
            this.func_230480_a_((Widget)new SoundElementButton(this.startX + 245, this.startY + yOffset, 152, 12, soundEvent, buffers.get(soundEvent), otherColor, b -> {
                SoundElementButton soundButton = (SoundElementButton)b;
                SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundButton.getSoundEvent());
                if (this.field_230706_i_ != null && event != null) {
                    this.field_230706_i_.func_147118_V().func_147682_a((ISound)new MaidSoundInstance(event, this.selectSoundId, this.maid, true));
                }
            }).setTooltips("tooltips.touhou_little_maid.custom_sound.play_sound"));
            otherColor = !otherColor;
            yOffset += 12;
        }
    }

    private void addSoundOtherButtons() {
        this.func_230480_a_((Widget)new FlatColorButton(this.startX + 245, this.startY + 19, 110, 18, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.custom_sound.pack.apply"), b -> {
            if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId)) {
                this.maid.setSoundPackId(this.selectSoundId);
                NetworkHandler.CHANNEL.sendToServer((Object)new SetMaidSoundIdMessage(this.maid.func_145782_y(), this.selectSoundId));
                this.func_231160_c_();
            }
        }));
        this.func_230480_a_((Widget)new FlatColorButton(this.startX + 358, this.startY + 19, 18, 18, StringTextComponent.field_240750_d_, b -> {
            String url;
            if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId) && StringUtils.isNotBlank((CharSequence)(url = CustomSoundLoader.getSoundCache(this.selectSoundId).getInfo().getUrl())) && this.field_230706_i_ != null) {
                this.field_230706_i_.func_147108_a((Screen)new ConfirmOpenLinkScreen(yes -> {
                    if (yes) {
                        Util.func_110647_a().func_195640_a(url);
                    }
                    this.field_230706_i_.func_147108_a((Screen)this);
                }, url, false));
            }
        }).setTooltips("tooltips.touhou_little_maid.custom_sound.open_url"));
        this.func_230480_a_((Widget)new FlatColorButton(this.startX + 379, this.startY + 19, 18, 18, StringTextComponent.field_240750_d_, b -> {
            if (this.field_230706_i_ != null) {
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)new MaidSoundInstance((SoundEvent)InitSounds.MAID_CREDIT.get(), this.selectSoundId, this.maid, true));
            }
        }).setTooltips("tooltips.touhou_little_maid.custom_sound.credit"));
    }

    private void addSoundElementPageButtons() {
        this.func_230480_a_((Widget)new FlatColorButton(this.startX + 245, this.startY + 201, 16, 16, (ITextComponent)new StringTextComponent("<"), b -> {
            if (this.soundPage > 0) {
                --this.soundPage;
                this.func_231160_c_();
            }
        }));
        this.func_230480_a_((Widget)new FlatColorButton(this.startX + 381, this.startY + 201, 16, 16, (ITextComponent)new StringTextComponent(">"), b -> {
            Map<ResourceLocation, List<AudioStreamBuffer>> buffersIn;
            if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId) && (this.soundPage + 1) * 13 < (buffersIn = CustomSoundLoader.getSoundCache(this.selectSoundId).getBuffers()).size()) {
                ++this.soundPage;
                this.func_231160_c_();
            }
        }));
    }

    private void addSoundPackButtons() {
        int startPackIndex;
        int yOffset = 19;
        ArrayList<String> soundPackIds = new ArrayList<String>(CustomSoundLoader.CACHE.keySet());
        if (soundPackIds.contains("touhou_little_maid")) {
            Collections.swap(soundPackIds, soundPackIds.indexOf("touhou_little_maid"), 0);
        }
        if ((startPackIndex = this.packPage * 4) >= soundPackIds.size()) {
            this.packPage = 0;
            startPackIndex = 0;
        }
        int endPackIndex = Math.min(soundPackIds.size(), startPackIndex + 4);
        for (int i = startPackIndex; i < endPackIndex; ++i) {
            String soundId = (String)soundPackIds.get(i);
            SoundPackInfo info = CustomSoundLoader.getSoundCache(soundId).getInfo();
            SoundPackButton button = new SoundPackButton(this.startX + 5, this.startY + yOffset, info, b -> {
                this.selectSoundId = soundId;
                this.soundPage = 0;
                this.func_231160_c_();
            });
            if (StringUtils.isNotBlank((CharSequence)info.getDescription())) {
                ITextComponent description = ParseI18n.parse(info.getDescription());
                button.setTooltips(Collections.singletonList(description));
            }
            if (soundId.equals(this.selectSoundId)) {
                button.setSelect(true);
            }
            if (soundId.equals(this.maid.getSoundPackId())) {
                button.setUse(true);
            }
            this.func_230480_a_((Widget)button);
            yOffset += 45;
        }
    }

    public void func_230430_a_(MatrixStack poseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.func_230446_a_(poseStack);
        MaidSoundPackGui.func_238467_a_((MatrixStack)poseStack, (int)this.startX, (int)this.startY, (int)(this.startX + 240), (int)(this.startY + 220), (int)-14013910);
        MaidSoundPackGui.func_238467_a_((MatrixStack)poseStack, (int)(this.startX + 242), (int)this.startY, (int)(this.startX + 400), (int)(this.startY + 220), (int)-14013910);
        MaidSoundPackGui.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.custom_sound.pack.title"), (int)(this.startX + 120), (int)(this.startY + 6), (int)0xFFFFFF);
        MaidSoundPackGui.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.custom_sound.sounds.preview"), (int)(this.startX + 321), (int)(this.startY + 6), (int)0xFFFFFF);
        MaidSoundPackGui.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)String.format("%d/%d", this.packPage + 1, this.packMaxPage + 1), (int)(this.startX + 120), (int)(this.startY + 206), (int)0xBBBBBB);
        super.func_230430_a_(poseStack, pMouseX, pMouseY, pPartialTick);
        if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId)) {
            MaidSoundPackGui.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)String.format("%d/%d", this.soundPage + 1, this.soundMaxPage + 1), (int)(this.startX + 321), (int)(this.startY + 206), (int)0xBBBBBB);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ICON);
            MaidSoundPackGui.func_238463_a_((MatrixStack)poseStack, (int)(this.startX + 359), (int)(this.startY + 20), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)256, (int)256);
            MaidSoundPackGui.func_238463_a_((MatrixStack)poseStack, (int)(this.startX + 380), (int)(this.startY + 20), (float)16.0f, (float)0.0f, (int)16, (int)16, (int)256, (int)256);
        }
        this.field_230710_m_.stream().filter(b -> b instanceof FlatColorButton).forEach(b -> ((FlatColorButton)((Object)b)).renderToolTip(poseStack, this, pMouseX, pMouseY));
    }
}

