/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class PackInfoButton
extends FlatColorButton {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/download_background.png");
    private final DownloadInfo info;

    public PackInfoButton(int pX, int pY, DownloadInfo info, Button.IPressable onPress) {
        super(pX, pY, 268, 46, StringTextComponent.field_240750_d_, onPress);
        this.info = info;
        this.setTooltips(Lists.newArrayList((Object[])new ITextComponent[]{this.getI18nFormatDesc(info.getDesc()), this.getI18nFormatLicense(info.getLicense())}));
    }

    @Override
    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float pPartialTick) {
        int count;
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(BG);
        if (this.isSelect) {
            this.func_238468_a_(matrixStack, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, -14774017, -14774017);
        } else if (this.info.getStatus() != DownloadStatus.DOWNLOADED) {
            this.func_238468_a_(matrixStack, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, -12369342, -12369342);
        }
        if (this.info.getStatus() == DownloadStatus.NEED_UPDATE) {
            this.func_238474_b_(matrixStack, this.field_230690_l_ + 240, this.field_230691_m_ + 15, 48, 16, 16, 16);
        }
        if (this.func_230449_g_()) {
            this.func_238468_a_(matrixStack, this.field_230690_l_, this.field_230691_m_ + 1, this.field_230690_l_ + 1, this.field_230691_m_ + this.field_230689_k_ - 1, -790560, -790560);
            this.func_238468_a_(matrixStack, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + 1, -790560, -790560);
            this.func_238468_a_(matrixStack, this.field_230690_l_ + this.field_230688_j_ - 1, this.field_230691_m_ + 1, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_ - 1, -790560, -790560);
            this.func_238468_a_(matrixStack, this.field_230690_l_, this.field_230691_m_ + this.field_230689_k_ - 1, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, -790560, -790560);
        }
        if ((count = this.info.getTypeCount()) == 3) {
            this.func_238474_b_(matrixStack, this.field_230690_l_ + 7, this.field_230691_m_ + 7, 0, 96, 32, 32);
        } else if (count == 2) {
            if (!this.info.hasType(DownloadInfo.TypeEnum.MAID)) {
                this.func_238474_b_(matrixStack, this.field_230690_l_ + 7, this.field_230691_m_ + 7, 64, 64, 32, 32);
            } else if (!this.info.hasType(DownloadInfo.TypeEnum.CHAIR)) {
                this.func_238474_b_(matrixStack, this.field_230690_l_ + 7, this.field_230691_m_ + 7, 32, 64, 32, 32);
            } else {
                this.func_238474_b_(matrixStack, this.field_230690_l_ + 7, this.field_230691_m_ + 7, 0, 64, 32, 32);
            }
        } else if (this.info.hasType(DownloadInfo.TypeEnum.MAID)) {
            this.func_238474_b_(matrixStack, this.field_230690_l_ + 7, this.field_230691_m_ + 7, 0, 32, 32, 32);
        } else if (this.info.hasType(DownloadInfo.TypeEnum.CHAIR)) {
            this.func_238474_b_(matrixStack, this.field_230690_l_ + 7, this.field_230691_m_ + 7, 32, 32, 32, 32);
        } else {
            this.func_238474_b_(matrixStack, this.field_230690_l_ + 7, this.field_230691_m_ + 7, 64, 32, 32, 32);
        }
        int i = this.getFGColor();
        this.renderString(matrixStack, minecraft.field_71466_p, i | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24);
        if (this.info.getStatus() == DownloadStatus.DOWNLOADED) {
            this.func_238468_a_(matrixStack, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, 2133008930, 2133008930);
        }
    }

    @Override
    public void renderString(MatrixStack matrixStack, FontRenderer font, int pColor) {
        int startX = this.field_230690_l_ + 50;
        int startY = this.field_230691_m_ + 4;
        TranslationTextComponent packName = new TranslationTextComponent(this.info.getName());
        PackInfoButton.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)font, (ITextComponent)packName, (int)startX, (int)startY, (int)TextFormatting.WHITE.func_211163_e());
        PackInfoButton.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)font, (String)this.getI18nFormatFileVersion(this.info.getVersion()), (int)(startX + 5 + font.func_238414_a_((ITextProperties)packName)), (int)startY, (int)TextFormatting.GREEN.func_211163_e());
        PackInfoButton.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)font, (ITextComponent)this.getI18nFormatFileSize(this.info.getFormatFileSize()), (int)startX, (int)(startY + 10), (int)TextFormatting.GOLD.func_211163_e());
        PackInfoButton.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)font, (ITextComponent)this.getI18nFormatAuthor(this.info.getAuthor()), (int)startX, (int)(startY + 20), (int)TextFormatting.AQUA.func_211163_e());
        PackInfoButton.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)font, (ITextComponent)this.getI18nFormatFileTime(this.info.getFormatData()), (int)startX, (int)(startY + 30), (int)TextFormatting.GRAY.func_211163_e());
    }

    private String getI18nFormatFileVersion(String version) {
        return "\u00a7nv" + version;
    }

    private TranslationTextComponent getI18nFormatAuthor(List<String> authors) {
        String str = String.join((CharSequence)I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.author.delimiter", (Object[])new Object[0]), authors);
        return new TranslationTextComponent("gui.touhou_little_maid.resources_download.author", new Object[]{str});
    }

    private TranslationTextComponent getI18nFormatFileSize(String size) {
        return new TranslationTextComponent("gui.touhou_little_maid.resources_download.file_size", new Object[]{size});
    }

    private TranslationTextComponent getI18nFormatFileTime(String time) {
        return new TranslationTextComponent("gui.touhou_little_maid.resources_download.upload_time", new Object[]{time});
    }

    private IFormattableTextComponent getI18nFormatLicense(String license) {
        return new TranslationTextComponent("gui.touhou_little_maid.resources_download.license", new Object[]{license}).func_240699_a_(TextFormatting.DARK_PURPLE).func_240699_a_(TextFormatting.ITALIC);
    }

    private IFormattableTextComponent getI18nFormatDesc(String desc) {
        return new TranslationTextComponent(desc).func_240699_a_(TextFormatting.GRAY);
    }
}

