/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidConfigMessage;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ScheduleButton<T extends AbstractMaidContainer>
extends Button {
    private static final ResourceLocation BUTTON = new ResourceLocation("touhou_little_maid", "textures/gui/maid_gui_button.png");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");
    private final EntityMaid maid;
    private MaidSchedule mode;

    public ScheduleButton(int x, int y, AbstractMaidContainerGui<T> gui) {
        super(x, y, 61, 13, StringTextComponent.field_240750_d_, b -> {});
        this.maid = gui.getMaid();
        this.mode = this.maid.getSchedule();
    }

    public void func_230930_b_() {
        int index = this.mode.ordinal() + 1;
        int length = MaidSchedule.values().length;
        this.mode = MaidSchedule.values()[index % length];
        NetworkHandler.CHANNEL.sendToServer((Object)new MaidConfigMessage(this.maid.func_145782_y(), this.maid.isHomeModeEnable(), this.maid.isPickup(), this.maid.isRideable(), this.mode));
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(BUTTON);
        RenderSystem.enableDepthTest();
        ScheduleButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)82.0f, (float)(43 + 14 * this.mode.ordinal()), (int)this.field_230688_j_, (int)this.field_230689_k_, (int)256, (int)256);
    }

    public List<ITextComponent> getTooltips() {
        int time = (int)(this.maid.field_70170_p.func_72820_D() % 24000L);
        int hour = (time / 1000 + 6) % 24;
        int minute = time % 1000 * 60 / 1000;
        Activity activity = this.maid.getScheduleDetail();
        ArrayList out = Lists.newArrayList();
        out.add(new StringTextComponent(String.format("\u00a7n%s\u00a77 %s:%s", this.getScheduleTransText(), DECIMAL_FORMAT.format(hour), DECIMAL_FORMAT.format(minute))));
        switch (this.mode) {
            case ALL: {
                out.add(new StringTextComponent(String.format("\u00a7a\u2588 00:00-24:00 %s", this.getActivityTransText(Activity.field_221367_c))));
                break;
            }
            case NIGHT: {
                if (activity == Activity.field_221367_c) {
                    out.add(new StringTextComponent(String.format("\u00a7a\u2588 18:00-06:00 %s", this.getActivityTransText(Activity.field_221367_c))));
                } else {
                    out.add(new StringTextComponent(String.format("\u00a78\u2588 18:00-06:00 %s", this.getActivityTransText(Activity.field_221367_c))));
                }
                if (activity == Activity.field_221369_e) {
                    out.add(new StringTextComponent(String.format("\u00a7a\u2588 06:00-14:00 %s", this.getActivityTransText(Activity.field_221369_e))));
                } else {
                    out.add(new StringTextComponent(String.format("\u00a78\u2588 06:00-14:00 %s", this.getActivityTransText(Activity.field_221369_e))));
                }
                if (activity == Activity.field_221366_b) {
                    out.add(new StringTextComponent(String.format("\u00a7a\u2588 14:00-18:00 %s", this.getActivityTransText(Activity.field_221366_b))));
                    break;
                }
                out.add(new StringTextComponent(String.format("\u00a78\u2588 14:00-18:00 %s", this.getActivityTransText(Activity.field_221366_b))));
                break;
            }
            default: {
                if (activity == Activity.field_221367_c) {
                    out.add(new StringTextComponent(String.format("\u00a7a\u2588 06:00-18:00 %s", this.getActivityTransText(Activity.field_221367_c))));
                } else {
                    out.add(new StringTextComponent(String.format("\u00a78\u2588 06:00-18:00 %s", this.getActivityTransText(Activity.field_221367_c))));
                }
                if (activity == Activity.field_221366_b) {
                    out.add(new StringTextComponent(String.format("\u00a7a\u2588 18:00-22:00 %s", this.getActivityTransText(Activity.field_221366_b))));
                } else {
                    out.add(new StringTextComponent(String.format("\u00a78\u2588 18:00-22:00 %s", this.getActivityTransText(Activity.field_221366_b))));
                }
                if (activity == Activity.field_221369_e) {
                    out.add(new StringTextComponent(String.format("\u00a7a\u2588 22:00-06:00 %s", this.getActivityTransText(Activity.field_221369_e))));
                    break;
                }
                out.add(new StringTextComponent(String.format("\u00a78\u2588 22:00-06:00 %s", this.getActivityTransText(Activity.field_221369_e))));
            }
        }
        out.add(new TranslationTextComponent("tooltips.touhou_little_maid.schedule.desc"));
        return out;
    }

    public String getScheduleTransText() {
        return I18n.func_135052_a((String)("gui.touhou_little_maid.schedule." + this.mode.name().toLowerCase(Locale.US)), (Object[])new Object[0]);
    }

    public String getActivityTransText(Activity activity) {
        return I18n.func_135052_a((String)("gui.touhou_little_maid.activity." + activity.func_221364_a()), (Object[])new Object[0]);
    }
}

