/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.sound.pojo.SoundPackInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;

public class SoundPackButton
extends FlatColorButton {
    private static final ResourceLocation ICON = new ResourceLocation("touhou_little_maid", "textures/gui/maid_custom_sound.png");
    private final SoundPackInfo info;
    private boolean isUse = false;

    public SoundPackButton(int pX, int pY, SoundPackInfo info, Button.IPressable onPress) {
        super(pX, pY, 230, 43, StringTextComponent.field_240750_d_, onPress);
        this.info = info;
    }

    @Override
    public void func_230431_b_(MatrixStack poseStack, int mouseX, int mouseY, float pPartialTick) {
        super.func_230431_b_(poseStack, mouseX, mouseY, pPartialTick);
        ResourceLocation icon = this.info.getIcon();
        if (icon == null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ICON);
            SoundPackButton.func_238463_a_((MatrixStack)poseStack, (int)(this.field_230690_l_ + 4), (int)(this.field_230691_m_ + 5), (float)0.0f, (float)16.0f, (int)32, (int)32, (int)256, (int)256);
        } else {
            if (this.info.getIconAnimation() == CustomModelPack.AnimationState.UNCHECK) {
                this.checkIconAnimation(this.info, icon);
            }
            if (this.info.getIconAnimation() == CustomModelPack.AnimationState.FALSE) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(icon);
                SoundPackButton.func_238463_a_((MatrixStack)poseStack, (int)(this.field_230690_l_ + 4), (int)(this.field_230691_m_ + 5), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            } else {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(icon);
                int time = this.getTickTime() / this.info.getIconDelay();
                int iconIndex = time % this.info.getIconAspectRatio();
                SoundPackButton.func_238463_a_((MatrixStack)poseStack, (int)(this.field_230690_l_ + 4), (int)(this.field_230691_m_ + 5), (float)0.0f, (float)(iconIndex * 32), (int)32, (int)32, (int)32, (int)(32 * this.info.getIconAspectRatio()));
            }
        }
        if (this.isUse) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ICON);
            SoundPackButton.func_238463_a_((MatrixStack)poseStack, (int)(this.field_230690_l_ + this.func_230998_h_() - 20), (int)(this.field_230691_m_ + 13), (float)32.0f, (float)0.0f, (int)16, (int)16, (int)256, (int)256);
        }
    }

    @Override
    public void renderString(MatrixStack poseStack, FontRenderer font, int pColor) {
        int startX = this.field_230690_l_ + 42;
        int startY = this.field_230691_m_ + 7;
        ITextComponent packName = ParseI18n.parse(this.info.getPackName());
        String version = this.info.getVersion();
        List<String> author = this.info.getAuthor();
        String date = this.info.getDate();
        SoundPackButton.func_238475_b_((MatrixStack)poseStack, (FontRenderer)font, (ITextComponent)packName, (int)startX, (int)startY, (int)TextFormatting.WHITE.func_211163_e());
        if (StringUtils.isNotBlank((CharSequence)version)) {
            int titleWidth = font.func_238414_a_((ITextProperties)packName);
            SoundPackButton.func_238476_c_((MatrixStack)poseStack, (FontRenderer)font, (String)("\u00a7nv" + version), (int)(startX + titleWidth + 5), (int)startY, (int)TextFormatting.AQUA.func_211163_e());
        }
        if (!author.isEmpty()) {
            String authorListText = StringUtils.joinWith((String)I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.author.delimiter", (Object[])new Object[0]), (Object[])new Object[]{author});
            String authorText = I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.author", (Object[])new Object[]{authorListText});
            SoundPackButton.func_238476_c_((MatrixStack)poseStack, (FontRenderer)font, (String)authorText, (int)startX, (int)(startY += 10), (int)TextFormatting.GOLD.func_211163_e());
        }
        if (StringUtils.isNotBlank((CharSequence)date)) {
            TranslationTextComponent dateText = new TranslationTextComponent("gui.touhou_little_maid.skin.text.date", new Object[]{date});
            SoundPackButton.func_238475_b_((MatrixStack)poseStack, (FontRenderer)font, (ITextComponent)dateText, (int)startX, (int)(startY += 10), (int)TextFormatting.GREEN.func_211163_e());
        }
    }

    private int getTickTime() {
        return (int)System.currentTimeMillis() / 50;
    }

    private void checkIconAnimation(SoundPackInfo info, ResourceLocation icon) {
        Texture iconText = Minecraft.func_71410_x().field_71446_o.func_229267_b_(icon);
        if (iconText instanceof SizeTexture) {
            int height;
            int width = ((SizeTexture)iconText).getWidth();
            if (width >= (height = ((SizeTexture)iconText).getHeight())) {
                info.setIconAnimation(CustomModelPack.AnimationState.FALSE);
            } else {
                info.setIconAnimation(CustomModelPack.AnimationState.TRUE);
                info.setIconAspectRatio(height / width);
            }
        } else {
            info.setIconAnimation(CustomModelPack.AnimationState.FALSE);
        }
    }

    public boolean isUse() {
        return this.isUse;
    }

    public void setUse(boolean use) {
        this.isUse = use;
    }
}

