/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.init;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.item.PerspectiveBakedModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.item.ReplaceableBakedModel;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class InitSpecialItemRender {
    private static final List<Pair<ModelResourceLocation, ModelResourceLocation>> PERSPECTIVE_MODEL_LIST = Lists.newArrayList();
    private static final List<Triple<ModelResourceLocation, ModelResourceLocation, Supplier<Boolean>>> REPLACEABLE_MODEL_LIST = Lists.newArrayList();
    private static final ResourceLocation LIFE_POINT = new ResourceLocation("touhou_little_maid", "life_point");
    private static final ResourceLocation POINT_ITEM = new ResourceLocation("touhou_little_maid", "point_item");

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Item> event) {
        InitSpecialItemRender.addInHandModel((Item)InitItems.HAKUREI_GOHEI.get());
        InitSpecialItemRender.addInHandModel((Item)InitItems.EXTINGUISHER.get());
        InitSpecialItemRender.addInHandModel((Item)InitItems.CAMERA.get());
        InitSpecialItemRender.addInHandModel((Item)InitItems.MAID_BEACON.get());
        InitSpecialItemRender.addReplaceableModel(Items.field_190929_cY, LIFE_POINT, () -> (Boolean)VanillaConfig.REPLACE_TOTEM_TEXTURE.get());
        InitSpecialItemRender.addReplaceableModel(Items.field_151062_by, POINT_ITEM, () -> (Boolean)VanillaConfig.REPLACE_XP_BOTTLE_TEXTURE.get());
    }

    @SubscribeEvent
    public static void onBakedModel(ModelBakeEvent event) {
        Object model;
        Map registry = event.getModelRegistry();
        for (Pair<ModelResourceLocation, ModelResourceLocation> pair : PERSPECTIVE_MODEL_LIST) {
            model = new PerspectiveBakedModel((IBakedModel)registry.get(pair.getLeft()), (IBakedModel)registry.get(pair.getRight()));
            registry.put(pair.getLeft(), model);
        }
        for (Triple triple : REPLACEABLE_MODEL_LIST) {
            model = new ReplaceableBakedModel((IBakedModel)registry.get(triple.getLeft()), (IBakedModel)registry.get(triple.getMiddle()), (Supplier)triple.getRight());
            registry.put(triple.getLeft(), model);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        PERSPECTIVE_MODEL_LIST.forEach(pair -> ModelLoader.addSpecialModel((ResourceLocation)((ResourceLocation)pair.getRight())));
        REPLACEABLE_MODEL_LIST.forEach(triple -> ModelLoader.addSpecialModel((ResourceLocation)((ResourceLocation)triple.getMiddle())));
    }

    public static void addInHandModel(Item item) {
        ResourceLocation res = item.getRegistryName();
        if (res != null) {
            ModelResourceLocation rawName = ModelLoader.getInventoryVariant((String)res.toString());
            ModelResourceLocation inHandName = ModelLoader.getInventoryVariant((String)(res.toString() + "_in_hand"));
            PERSPECTIVE_MODEL_LIST.add((Pair<ModelResourceLocation, ModelResourceLocation>)Pair.of((Object)rawName, (Object)inHandName));
        }
    }

    public static void addReplaceableModel(Item item, ResourceLocation replacedModel, Supplier<Boolean> isReplace) {
        ResourceLocation res = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
        if (res != null) {
            ModelResourceLocation rawModelResourceLocation = new ModelResourceLocation(res, "inventory");
            ModelResourceLocation replacedModelResourceLocation = new ModelResourceLocation(replacedModel, "inventory");
            REPLACEABLE_MODEL_LIST.add((Triple<ModelResourceLocation, ModelResourceLocation, Supplier<Boolean>>)Triple.of((Object)rawModelResourceLocation, (Object)replacedModelResourceLocation, isReplace));
        }
    }
}

