/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.model;

import com.github.tartaricacid.touhoulittlemaid.client.animation.CustomJsAnimationManger;
import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.IAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.EntityChairWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.EntityMaidWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.BedrockVersion;
import com.github.tartaricacid.touhoulittlemaid.client.model.ModelFaceFloatBox;
import com.github.tartaricacid.touhoulittlemaid.client.model.ModelFloatBox;
import com.github.tartaricacid.touhoulittlemaid.client.model.ModelRendererWithOffset;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.BedrockModelPOJO;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.BonesItem;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.CubesItem;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.Description;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.FaceUVsItem;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.script.Invocable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BedrockModel<T extends LivingEntity>
extends EntityModel<T> {
    protected final HashMap<String, ModelRendererWrapper> modelMap = new HashMap();
    private final HashMap<String, BonesItem> indexBones = new HashMap();
    private final List<ModelRenderer> shouldRender = new LinkedList<ModelRenderer>();
    private final EntityMaidWrapper entityMaidWrapper = new EntityMaidWrapper();
    private final EntityChairWrapper entityChairWrapper = new EntityChairWrapper();
    private AxisAlignedBB renderBoundingBox;
    private List<Object> animations = Lists.newArrayList();
    private List<ModelRenderer> cubes = Lists.newArrayList();

    public BedrockModel() {
        super(RenderType::func_228644_e_);
        this.renderBoundingBox = new AxisAlignedBB(-1.0, 0.0, -1.0, 1.0, 2.0, 1.0);
    }

    public BedrockModel(BedrockModelPOJO pojo, BedrockVersion version) {
        super(RenderType::func_228644_e_);
        if (version == BedrockVersion.LEGACY) {
            this.loadLegacyModel(pojo);
        }
        if (version == BedrockVersion.NEW) {
            this.loadNewModel(pojo);
        }
    }

    protected void loadNewModel(BedrockModelPOJO pojo) {
        assert (pojo.getGeometryModelNew() != null);
        pojo.getGeometryModelNew().deco();
        Description description = pojo.getGeometryModelNew().getDescription();
        this.field_78090_t = description.getTextureWidth();
        this.field_78089_u = description.getTextureHeight();
        List<Float> offset = description.getVisibleBoundsOffset();
        float offsetX = offset.get(0).floatValue();
        float offsetY = offset.get(1).floatValue();
        float offsetZ = offset.get(2).floatValue();
        float width = description.getVisibleBoundsWidth() / 2.0f;
        float height = description.getVisibleBoundsHeight() / 2.0f;
        this.renderBoundingBox = new AxisAlignedBB((double)(offsetX - width), (double)(offsetY - height), (double)(offsetZ - width), (double)(offsetX + width), (double)(offsetY + height), (double)(offsetZ + width));
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            this.indexBones.put(bones.getName(), bones);
            this.modelMap.put(bones.getName(), new ModelRendererWrapper(new ModelRendererWithOffset((Model)this)));
        }
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            String name = bones.getName();
            List<Float> rotation = bones.getRotation();
            String parent = bones.getParent();
            ModelRendererWithOffset model = this.modelMap.get(name).getModelRenderer();
            model.field_78809_i = bones.isMirror();
            model.func_78793_a(this.convertPivot(bones, 0), this.convertPivot(bones, 1), this.convertPivot(bones, 2));
            if (rotation != null) {
                this.setRotationAngle(model, this.convertRotation(rotation.get(0).floatValue()), this.convertRotation(rotation.get(1).floatValue()), this.convertRotation(rotation.get(2).floatValue()));
            }
            if (parent != null) {
                this.modelMap.get(parent).getModelRenderer().func_78792_a(model);
            } else {
                this.shouldRender.add(model);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                List<Float> uv = cube.getUv();
                FaceUVsItem faceUv = cube.getFaceUv();
                List<Float> size = cube.getSize();
                List<Float> cubeRotation = cube.getRotation();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                if (cubeRotation == null) {
                    if (faceUv == null) {
                        model.field_78804_l.add((Object)new ModelFloatBox(uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror, this.field_78090_t, this.field_78089_u));
                        continue;
                    }
                    model.field_78804_l.add((Object)new ModelFaceFloatBox(this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, this.field_78090_t, this.field_78089_u, faceUv));
                    continue;
                }
                ModelRendererWithOffset cubeRenderer = new ModelRendererWithOffset((Model)this);
                cubeRenderer.func_78793_a(this.convertPivot(bones, cube, 0), this.convertPivot(bones, cube, 1), this.convertPivot(bones, cube, 2));
                this.setRotationAngle(cubeRenderer, this.convertRotation(cubeRotation.get(0).floatValue()), this.convertRotation(cubeRotation.get(1).floatValue()), this.convertRotation(cubeRotation.get(2).floatValue()));
                if (faceUv == null) {
                    cubeRenderer.field_78804_l.add((Object)new ModelFloatBox(uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(cube, 0), this.convertOrigin(cube, 1), this.convertOrigin(cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror, this.field_78090_t, this.field_78089_u));
                } else {
                    cubeRenderer.field_78804_l.add((Object)new ModelFaceFloatBox(this.convertOrigin(cube, 0), this.convertOrigin(cube, 1), this.convertOrigin(cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, this.field_78090_t, this.field_78089_u, faceUv));
                }
                model.func_78792_a(cubeRenderer);
            }
        }
    }

    protected void loadLegacyModel(BedrockModelPOJO pojo) {
        assert (pojo.getGeometryModelLegacy() != null);
        pojo.getGeometryModelLegacy().deco();
        this.field_78090_t = pojo.getGeometryModelLegacy().getTextureWidth();
        this.field_78089_u = pojo.getGeometryModelLegacy().getTextureHeight();
        List<Float> offset = pojo.getGeometryModelLegacy().getVisibleBoundsOffset();
        float offsetX = offset.get(0).floatValue();
        float offsetY = offset.get(1).floatValue();
        float offsetZ = offset.get(2).floatValue();
        float width = pojo.getGeometryModelLegacy().getVisibleBoundsWidth() / 2.0f;
        float height = pojo.getGeometryModelLegacy().getVisibleBoundsHeight() / 2.0f;
        this.renderBoundingBox = new AxisAlignedBB((double)(offsetX - width), (double)(offsetY - height), (double)(offsetZ - width), (double)(offsetX + width), (double)(offsetY + height), (double)(offsetZ + width));
        for (BonesItem bones : pojo.getGeometryModelLegacy().getBones()) {
            this.indexBones.put(bones.getName(), bones);
            this.modelMap.put(bones.getName(), new ModelRendererWrapper(new ModelRendererWithOffset((Model)this)));
        }
        for (BonesItem bones : pojo.getGeometryModelLegacy().getBones()) {
            String name = bones.getName();
            List<Float> rotation = bones.getRotation();
            String parent = bones.getParent();
            ModelRendererWithOffset model = this.modelMap.get(name).getModelRenderer();
            model.field_78809_i = bones.isMirror();
            model.func_78793_a(this.convertPivot(bones, 0), this.convertPivot(bones, 1), this.convertPivot(bones, 2));
            if (rotation != null) {
                this.setRotationAngle(model, this.convertRotation(rotation.get(0).floatValue()), this.convertRotation(rotation.get(1).floatValue()), this.convertRotation(rotation.get(2).floatValue()));
            }
            if (parent != null) {
                this.modelMap.get(parent).getModelRenderer().func_78792_a(model);
            } else {
                this.shouldRender.add(model);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                List<Float> uv = cube.getUv();
                List<Float> size = cube.getSize();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                model.field_78804_l.add((Object)new ModelFloatBox(uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror, this.field_78090_t, this.field_78089_u));
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.animations != null) {
            Invocable invocable = (Invocable)((Object)CustomJsAnimationManger.NASHORN);
            if (entityIn instanceof EntityMaid) {
                this.setupMaidAnim((EntityMaid)((Object)entityIn), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, invocable);
                return;
            }
            if (entityIn instanceof EntityChair) {
                this.setupChairAnim((EntityChair)((Object)entityIn), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, invocable);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        for (ModelRenderer model : this.shouldRender) {
            model.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        }
    }

    private void setupMaidAnim(EntityMaid entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Invocable invocable) {
        try {
            for (Object animation : this.animations) {
                if (animation instanceof IAnimation) {
                    ((IAnimation)animation).setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, 0.0f, entityIn, this.modelMap);
                    continue;
                }
                this.entityMaidWrapper.setData(entityIn, this.field_217112_c, this.field_217113_d);
                invocable.invokeMethod(animation, "animation", this.entityMaidWrapper, Float.valueOf(limbSwing), Float.valueOf(limbSwingAmount), Float.valueOf(ageInTicks), Float.valueOf(netHeadYaw), Float.valueOf(headPitch), Float.valueOf(0.0625f), this.modelMap);
                this.entityMaidWrapper.clearData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CustomPackLoader.MAID_MODELS.removeAnimation(entityIn.getModelId());
        }
    }

    private void setupChairAnim(EntityChair entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Invocable invocable) {
        try {
            for (Object animation : this.animations) {
                if (animation instanceof IAnimation) {
                    ((IAnimation)animation).setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, 0.0f, entityIn, this.modelMap);
                    continue;
                }
                this.entityChairWrapper.setData(entityIn);
                invocable.invokeMethod(animation, "animation", this.entityChairWrapper, Float.valueOf(limbSwing), Float.valueOf(limbSwingAmount), Float.valueOf(ageInTicks), Float.valueOf(netHeadYaw), Float.valueOf(headPitch), Float.valueOf(0.0625f), this.modelMap);
                this.entityChairWrapper.clearData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CustomPackLoader.CHAIR_MODELS.removeAnimation(entityIn.getModelId());
        }
    }

    private void setRotationAngle(ModelRendererWithOffset modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
        modelRenderer.setInitRotationAngle(x, y, z);
    }

    public void translateToHand(HandSide sideIn, MatrixStack matrixStackIn) {
        ModelRenderer arm = this.getArm(sideIn);
        if (arm != null) {
            arm.func_228307_a_(matrixStackIn);
        }
    }

    public boolean hasBackpackPositioningModel() {
        return this.modelMap.get("backpackPositioningBone") != null;
    }

    public ModelRenderer getBackpackPositioningModel() {
        return this.modelMap.get("backpackPositioningBone").getModelRenderer();
    }

    @Nullable
    private ModelRenderer getArm(HandSide sideIn) {
        return sideIn == HandSide.LEFT ? this.modelMap.get("armLeft").getModelRenderer() : this.modelMap.get("armRight").getModelRenderer();
    }

    public boolean hasHead() {
        return this.modelMap.containsKey("head");
    }

    public ModelRenderer getHead() {
        return this.modelMap.get("head").getModelRenderer();
    }

    public boolean hasLeftArm() {
        return this.modelMap.containsKey("armLeft");
    }

    public boolean hasRightArm() {
        return this.modelMap.containsKey("armRight");
    }

    public boolean hasArmPositioningModel(HandSide side) {
        ModelRendererWrapper arm = side == HandSide.LEFT ? this.modelMap.get("armLeftPositioningBone") : this.modelMap.get("armRightPositioningBone");
        return arm != null;
    }

    public void translateToPositioningHand(HandSide sideIn, MatrixStack matrixStackIn) {
        ModelRendererWithOffset arm;
        ModelRendererWithOffset modelRendererWithOffset = arm = sideIn == HandSide.LEFT ? this.modelMap.get("armLeftPositioningBone").getModelRenderer() : this.modelMap.get("armRightPositioningBone").getModelRenderer();
        if (arm != null) {
            arm.func_228307_a_(matrixStackIn);
        }
    }

    public boolean hasWaistPositioningModel(HandSide side) {
        ModelRendererWrapper waist = side == HandSide.LEFT ? this.modelMap.get("waistLeftPositioningBone") : this.modelMap.get("waistRightPositioningBone");
        return waist != null;
    }

    public void translateToPositioningWaist(HandSide sideIn, MatrixStack poseStack) {
        ModelRendererWithOffset waist;
        ModelRendererWithOffset modelRendererWithOffset = waist = sideIn == HandSide.LEFT ? this.modelMap.get("waistLeftPositioningBone").getModelRenderer() : this.modelMap.get("waistRightPositioningBone").getModelRenderer();
        if (waist != null) {
            waist.func_228307_a_(poseStack);
        }
    }

    public void accept(ModelRenderer modelRenderer) {
        if (this.cubes == null) {
            this.cubes = Lists.newArrayList();
        }
        this.cubes.add(modelRenderer);
    }

    private float convertPivot(BonesItem bones, int index) {
        if (bones.getParent() != null) {
            if (index == 1) {
                return this.indexBones.get(bones.getParent()).getPivot().get(index).floatValue() - bones.getPivot().get(index).floatValue();
            }
            return bones.getPivot().get(index).floatValue() - this.indexBones.get(bones.getParent()).getPivot().get(index).floatValue();
        }
        if (index == 1) {
            return 24.0f - bones.getPivot().get(index).floatValue();
        }
        return bones.getPivot().get(index).floatValue();
    }

    private float convertPivot(BonesItem parent, CubesItem cube, int index) {
        assert (cube.getPivot() != null);
        if (index == 1) {
            return parent.getPivot().get(index).floatValue() - cube.getPivot().get(index).floatValue();
        }
        return cube.getPivot().get(index).floatValue() - parent.getPivot().get(index).floatValue();
    }

    private float convertOrigin(BonesItem bone, CubesItem cube, int index) {
        if (index == 1) {
            return bone.getPivot().get(index).floatValue() - cube.getOrigin().get(index).floatValue() - cube.getSize().get(index).floatValue();
        }
        return cube.getOrigin().get(index).floatValue() - bone.getPivot().get(index).floatValue();
    }

    private float convertOrigin(CubesItem cube, int index) {
        assert (cube.getPivot() != null);
        if (index == 1) {
            return cube.getPivot().get(index).floatValue() - cube.getOrigin().get(index).floatValue() - cube.getSize().get(index).floatValue();
        }
        return cube.getOrigin().get(index).floatValue() - cube.getPivot().get(index).floatValue();
    }

    private float convertRotation(float degree) {
        return (float)((double)degree * Math.PI / 180.0);
    }

    public void setAnimations(@Nullable List<Object> animations) {
        this.animations = animations;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderBoundingBox;
    }
}

