/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.overlay;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class MaidTipsOverlay {
    private static final ResourceLocation ICON = new ResourceLocation("touhou_little_maid", "textures/gui/maid_tips_icon.png");
    private static final Map<Item, ITextComponent> TIPS = Maps.newHashMap();

    public static void init() {
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.compass.tips", Items.field_151111_aL);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.golden_apple.tips", Items.field_151153_ao, Items.field_196100_at);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.potion.tips", Items.field_151068_bn);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.milk_bucket.tips", Items.field_151117_aB);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.script_book.tips", Items.field_151099_bA, Items.field_151164_bB);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.glass_bottle.tips", Items.field_151069_bo);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.name_tag.tips", Items.field_151057_cb);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.lead.tips", Items.field_151058_ca);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.debug_stick.tips", Items.field_196180_eI);
    }

    private static ITextComponent checkSpecialTips(ItemStack mainhandItem, EntityMaid maid, ClientPlayerEntity player) {
        if (!maid.func_152114_e((LivingEntity)player) && maid.getNtrItem().test(mainhandItem)) {
            return new TranslationTextComponent("overlay.touhou_little_maid.ntr_item.tips");
        }
        if (maid.func_152114_e((LivingEntity)player) && maid.hasBackpack() && mainhandItem.func_77973_b().func_206844_a((ITag)Tags.Items.SHEARS)) {
            return new TranslationTextComponent("overlay.touhou_little_maid.remove_backpack.tips");
        }
        return null;
    }

    @SubscribeEvent
    public static void render(RenderGameOverlayEvent.Text event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        GameSettings options = minecraft.field_71474_y;
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        if (!(minecraft.field_71456_v instanceof ForgeIngameGui)) {
            return;
        }
        ForgeIngameGui gui = (ForgeIngameGui)minecraft.field_71456_v;
        if (!options.func_243230_g().func_243192_a()) {
            return;
        }
        if (minecraft.field_71442_b == null || minecraft.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
            return;
        }
        if (!(minecraft.field_71476_x instanceof EntityRayTraceResult)) {
            return;
        }
        EntityRayTraceResult result = (EntityRayTraceResult)minecraft.field_71476_x;
        if (!(result.func_216348_a() instanceof EntityMaid)) {
            return;
        }
        EntityMaid maid = (EntityMaid)result.func_216348_a();
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player == null) {
            return;
        }
        if (!maid.func_70089_S()) {
            return;
        }
        ITextComponent tip = null;
        if (maid.func_152114_e((LivingEntity)player)) {
            tip = TIPS.get(player.func_184614_ca().func_77973_b());
        }
        if (tip == null) {
            tip = MaidTipsOverlay.checkSpecialTips(player.func_184614_ca(), maid, player);
        }
        if (tip != null) {
            int screenWidth = minecraft.func_228018_at_().func_198107_o();
            int screenHeight = minecraft.func_228018_at_().func_198087_p();
            MatrixStack poseStack = event.getMatrixStack();
            List split = minecraft.field_71466_p.func_238425_b_((ITextProperties)tip, 150);
            int offset = screenHeight / 2 - 5 - split.size() * 10;
            Minecraft.func_71410_x().func_175599_af().func_175042_a(player.func_184614_ca(), screenWidth / 2 - 8, offset);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ICON);
            AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)(screenWidth / 2 + 2), (int)(offset - 4), (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
            offset += 18;
            for (IReorderingProcessor sequence : split) {
                int width = minecraft.field_71466_p.func_243245_a(sequence);
                minecraft.field_71466_p.func_238407_a_(poseStack, sequence, (float)(screenWidth - width) / 2.0f, (float)offset, 0xFFFFFF);
                offset += 10;
            }
        }
    }

    private static void addTips(String key, Item ... items) {
        for (Item item : items) {
            TIPS.put(item, (ITextComponent)new TranslationTextComponent(key));
        }
    }
}

