/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatText;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.MaidChatBubbles;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.tuple.Pair;

public class ChatBubbleRenderer {
    private static final List<Pair<Long, ChatText>> TMP_CHAT_BUBBLES = Lists.newArrayList();
    private static final RenderState.AlphaState DEFAULT_ALPHA = new RenderState.AlphaState(0.003921569f);
    private static final String LEFT_ARROW = "left_arrow";
    private static final String MIDDLE_ARROW = "middle_arrow";
    private static final String RIGHT_ARROW = "right_arrow";

    public static void renderChatBubble(EntityMaidRenderer renderer, EntityMaid maid, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        double distance = renderer.func_177068_d().func_229099_b_((Entity)maid);
        if (ForgeHooksClient.isNameplateInRenderDistance((Entity)maid, (double)distance)) {
            ChatBubbleRenderer.getTmpChatBubbles(maid);
            FontRenderer font = renderer.func_76983_a();
            if (TMP_CHAT_BUBBLES.size() == 1) {
                Pair<Long, ChatText> chatBubble = TMP_CHAT_BUBBLES.get(0);
                ChatText chatText = (ChatText)chatBubble.getRight();
                RenderData data = new RenderData(renderer, maid, matrixStack, buffer, MIDDLE_ARROW);
                if (chatText.isText()) {
                    ITextComponent parseText = ParseI18n.parse(chatText.getText());
                    int width = font.func_238414_a_((ITextProperties)parseText);
                    ChatBubbleRenderer.renderChatBubbleBody(0, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data, d -> ChatBubbleRenderer.renderText(parseText, 0, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d));
                }
                if (chatText.isIcon()) {
                    ChatBubbleRenderer.renderChatBubbleBody(0, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data, d -> ChatBubbleRenderer.renderIcon(0, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText.getIconPath(), d));
                }
                return;
            }
            if (TMP_CHAT_BUBBLES.size() == 2) {
                int startX;
                int startX2;
                int fullWidth;
                int width;
                Pair<Long, ChatText> chatBubble1 = TMP_CHAT_BUBBLES.get(0);
                Pair<Long, ChatText> chatBubble2 = TMP_CHAT_BUBBLES.get(1);
                ChatText chatText1 = (ChatText)chatBubble1.getRight();
                ChatText chatText2 = (ChatText)chatBubble2.getRight();
                RenderData data1 = new RenderData(renderer, maid, matrixStack, buffer, RIGHT_ARROW);
                RenderData data2 = new RenderData(renderer, maid, matrixStack, buffer, LEFT_ARROW);
                if (chatText1.isText()) {
                    ITextComponent parseText1 = ParseI18n.parse(chatText1.getText());
                    width = font.func_238414_a_((ITextProperties)parseText1);
                    fullWidth = (width / 20 + 2) * 20;
                    startX2 = -fullWidth / 2 - 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX2, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data1, d -> ChatBubbleRenderer.renderText(parseText1, startX2, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d));
                }
                if (chatText1.isIcon()) {
                    int fullWidth2 = 60;
                    startX = -fullWidth2 / 2 - 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data1, d -> ChatBubbleRenderer.renderIcon(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText1.getIconPath(), d));
                }
                if (chatText2.isText()) {
                    ITextComponent parseText2 = ParseI18n.parse(chatText2.getText());
                    width = font.func_238414_a_((ITextProperties)parseText2);
                    fullWidth = (width / 20 + 2) * 20;
                    startX2 = fullWidth / 2 + 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX2, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data2, d -> ChatBubbleRenderer.renderText(parseText2, startX2, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d));
                }
                if (chatText2.isIcon()) {
                    int fullWidth3 = 60;
                    startX = fullWidth3 / 2 + 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data2, d -> ChatBubbleRenderer.renderIcon(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText2.getIconPath(), d));
                }
                return;
            }
            if (TMP_CHAT_BUBBLES.size() == 3) {
                int startX;
                int startX3;
                int fullWidth;
                int width;
                Pair<Long, ChatText> chatBubble1 = TMP_CHAT_BUBBLES.get(0);
                Pair<Long, ChatText> chatBubble2 = TMP_CHAT_BUBBLES.get(1);
                Pair<Long, ChatText> chatBubble3 = TMP_CHAT_BUBBLES.get(2);
                ChatText chatText1 = (ChatText)chatBubble1.getRight();
                ChatText chatText2 = (ChatText)chatBubble2.getRight();
                ChatText chatText3 = (ChatText)chatBubble3.getRight();
                RenderData data1 = new RenderData(renderer, maid, matrixStack, buffer, RIGHT_ARROW);
                RenderData data2 = new RenderData(renderer, maid, matrixStack, buffer, LEFT_ARROW);
                RenderData data3 = new RenderData(renderer, maid, matrixStack, buffer, MIDDLE_ARROW);
                if (chatText1.isText()) {
                    ITextComponent parseText1 = ParseI18n.parse(chatText1.getText());
                    width = font.func_238414_a_((ITextProperties)parseText1);
                    fullWidth = (width / 20 + 2) * 20;
                    startX3 = -fullWidth / 2 - 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX3, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data1, d -> ChatBubbleRenderer.renderText(parseText1, startX3, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d));
                }
                if (chatText1.isIcon()) {
                    int fullWidth4 = 60;
                    startX = -fullWidth4 / 2 - 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data1, d -> ChatBubbleRenderer.renderIcon(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText1.getIconPath(), d));
                }
                if (chatText2.isText()) {
                    ITextComponent parseText2 = ParseI18n.parse(chatText2.getText());
                    width = font.func_238414_a_((ITextProperties)parseText2);
                    fullWidth = (width / 20 + 2) * 20;
                    startX3 = fullWidth / 2 + 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX3, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data2, d -> ChatBubbleRenderer.renderText(parseText2, startX3, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d));
                }
                if (chatText2.isIcon()) {
                    int fullWidth5 = 60;
                    startX = fullWidth5 / 2 + 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data2, d -> ChatBubbleRenderer.renderIcon(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText2.getIconPath(), d));
                }
                if (chatText3.isText()) {
                    ITextComponent parseText3 = ParseI18n.parse(chatText3.getText());
                    width = font.func_238414_a_((ITextProperties)parseText3);
                    ChatBubbleRenderer.renderChatBubbleBody(0, -62 + ChatBubbleRenderer.getRenderYOffset(maid), width, data3, d -> ChatBubbleRenderer.renderText(parseText3, 0, -62 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d));
                }
                if (chatText3.isIcon()) {
                    ChatBubbleRenderer.renderChatBubbleBody(0, -62 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data3, d -> ChatBubbleRenderer.renderIcon(0, -62 + ChatBubbleRenderer.getRenderYOffset(maid), chatText3.getIconPath(), d));
                }
            }
        }
    }

    private static int getRenderYOffset(EntityMaid maid) {
        if (maid.func_70608_bn()) {
            return 48;
        }
        return 0;
    }

    private static void renderText(ITextComponent chatText, int startX, int startY, int width, int packedLight, RenderData data) {
        FontRenderer font = data.renderer.func_76983_a();
        font.func_243247_a(chatText, (float)(-width) / 2.0f + (float)startX, (float)(startY + 6), -16777216, false, data.matrixStack.func_227866_c_().func_227870_a_(), data.buffer, false, 0, packedLight);
    }

    private static void renderIcon(int startX, int startY, ResourceLocation iconPath, RenderData data) {
        IVertexBuilder iconVertexBuilder = data.buffer.getBuffer(ChatBubbleRenderer.chatBubbleRender(iconPath));
        Texture texture = Minecraft.func_71410_x().field_71446_o.func_229267_b_(iconPath);
        if (texture instanceof SizeTexture) {
            int textureWidth;
            SizeTexture sizeTexture = (SizeTexture)texture;
            int textureHeight = sizeTexture.getHeight();
            int count = textureHeight / ((textureWidth = sizeTexture.getWidth()) / 3);
            if (count <= 1) {
                ChatBubbleRenderer.drawIcon(data.matrixStack, iconVertexBuilder, startX - 30, startY, 0.0f, 0.0f, 1.0f);
            } else {
                int iconDelay = ((RenderData)data).maid.field_70173_aa / 2 % count;
                float vStart = 1.0f / (float)count * (float)iconDelay;
                float vEnd = 1.0f / (float)count * (float)(iconDelay + 1);
                ChatBubbleRenderer.drawIcon(data.matrixStack, iconVertexBuilder, startX - 30, startY, 0.0f, vStart, vEnd);
            }
        }
    }

    private static float getChatBubbleStartHeight(EntityMaidRenderer renderer, EntityMaid maid) {
        float height = maid.func_213302_cg() + 0.75f;
        if (((BedrockModel)renderer.func_217764_d()).hasHead()) {
            height = (24.0f - ((BedrockModel)renderer.func_217764_d()).getHead().field_78797_d) * 0.0625f + 0.75f;
        }
        return height;
    }

    private static void getTmpChatBubbles(EntityMaid maid) {
        MaidChatBubbles chatBubble = maid.getChatBubble();
        Pair<Long, ChatText> bubble1 = chatBubble.getBubble1();
        Pair<Long, ChatText> bubble2 = chatBubble.getBubble2();
        Pair<Long, ChatText> bubble3 = chatBubble.getBubble3();
        TMP_CHAT_BUBBLES.clear();
        if (bubble1 != MaidChatBubbles.EMPTY) {
            TMP_CHAT_BUBBLES.add(bubble1);
        }
        if (bubble2 != MaidChatBubbles.EMPTY) {
            TMP_CHAT_BUBBLES.add(bubble2);
        }
        if (bubble3 != MaidChatBubbles.EMPTY) {
            TMP_CHAT_BUBBLES.add(bubble3);
        }
    }

    private static void renderChatBubbleBody(int startX, int startY, int stringWidth, RenderData data, Consumer<RenderData> consumer) {
        ResourceLocation bg = data.renderer.getMainInfo().getChatBubble().getBg();
        float height = ChatBubbleRenderer.getChatBubbleStartHeight(data.renderer, data.maid);
        int count = stringWidth / 20;
        int fullWidth = (count + 2) * 20;
        int leftStartX = -fullWidth / 2 + startX;
        int rightStartX = fullWidth / 2 - 20 + startX;
        int middleStartX = -fullWidth / 2 + 20 + startX;
        data.matrixStack.func_227860_a_();
        data.matrixStack.func_227861_a_(0.0, (double)height, 0.0);
        data.matrixStack.func_227863_a_(data.renderer.func_177068_d().func_229098_b_());
        data.matrixStack.func_227862_a_(-0.025f, -0.025f, 0.025f);
        IVertexBuilder vertexBuilder = data.buffer.getBuffer(ChatBubbleRenderer.chatBubbleRender(bg));
        ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, leftStartX, startY, 0.2f, 0, 0);
        for (int i = 0; i < count; ++i) {
            ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, middleStartX, startY, 0.2f, 1, 0);
            middleStartX += 20;
        }
        ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, rightStartX, startY, 0.2f, 2, 0);
        if (LEFT_ARROW.equals(data.arrow)) {
            ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, leftStartX - 10, startY + 10, 0.19f, 0, 1);
        }
        if (MIDDLE_ARROW.equals(data.arrow)) {
            ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, startX - 10, startY + 10, 0.19f, 1, 1);
        }
        if (RIGHT_ARROW.equals(data.arrow)) {
            ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, rightStartX + 10, startY + 10, 0.19f, 2, 1);
        }
        consumer.accept(data);
        data.matrixStack.func_227865_b_();
    }

    public static void drawBg(MatrixStack matrixStack, IVertexBuilder builder, int x, int y, float z, int uIndex, int vIndex) {
        float height = 20.0f;
        float width = 20.0f;
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        float u0 = (float)uIndex / 3.0f;
        float u1 = (float)(uIndex + 1) / 3.0f;
        float v0 = (float)vIndex / 2.0f;
        float v1 = (float)(vIndex + 1) / 2.0f;
        ChatBubbleRenderer.vertex(matrix4f, builder, x, (float)y + height, z, u0, v1);
        ChatBubbleRenderer.vertex(matrix4f, builder, (float)x + width, (float)y + height, z, u1, v1);
        ChatBubbleRenderer.vertex(matrix4f, builder, (float)x + width, y, z, u1, v0);
        ChatBubbleRenderer.vertex(matrix4f, builder, x, y, z, u0, v0);
    }

    public static void drawIcon(MatrixStack matrixStack, IVertexBuilder builder, int x, int y, float z, float vStart, float vEnd) {
        float height = 20.0f;
        float width = 60.0f;
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        ChatBubbleRenderer.vertex(matrix4f, builder, x, (float)y + height, z, 0.0f, vEnd);
        ChatBubbleRenderer.vertex(matrix4f, builder, (float)x + width, (float)y + height, z, 1.0f, vEnd);
        ChatBubbleRenderer.vertex(matrix4f, builder, (float)x + width, y, z, 1.0f, vStart);
        ChatBubbleRenderer.vertex(matrix4f, builder, x, y, z, 0.0f, vStart);
    }

    private static void vertex(Matrix4f matrix4f, IVertexBuilder builder, float x, float y, float z, float u, float v) {
        builder.func_227888_a_(matrix4f, x, y, z).func_225583_a_(u, v).func_181675_d();
    }

    private static RenderType chatBubbleRender(ResourceLocation locationIn) {
        RenderType.State compositeState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(locationIn, false, false)).func_228713_a_(DEFAULT_ALPHA).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"chat_bubble", (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)255, (boolean)true, (boolean)false, (RenderType.State)compositeState);
    }

    private static class RenderData {
        private final EntityMaidRenderer renderer;
        private final EntityMaid maid;
        private final MatrixStack matrixStack;
        private final IRenderTypeBuffer buffer;
        private final String arrow;

        public RenderData(EntityMaidRenderer renderer, EntityMaid maid, MatrixStack matrixStack, IRenderTypeBuffer buffer, String arrow) {
            this.renderer = renderer;
            this.maid = maid;
            this.matrixStack = matrixStack;
            this.buffer = buffer;
            this.arrow = arrow;
        }
    }
}

