/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.EntityBoxModel;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBox;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class EntityBoxRender
extends EntityRenderer<EntityBox> {
    private final List<ResourceLocation> texturesGroup = Lists.newArrayList();
    private final EntityModel<EntityBox> boxModel = new EntityBoxModel();

    public EntityBoxRender(EntityRendererManager manager) {
        super(manager);
        IntStream.range(0, 7).forEach(this::addBoxTexture);
    }

    public void render(EntityBox entityBox, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLight) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStack.func_227861_a_(0.0, -1.501, 0.0);
        this.boxModel.func_225597_a_((Entity)entityBox, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        RenderType renderType = RenderType.func_228644_e_((ResourceLocation)this.getTextureLocation(entityBox));
        IVertexBuilder buffer = bufferIn.getBuffer(renderType);
        this.boxModel.func_225598_a_(matrixStack, buffer, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public ResourceLocation getTextureLocation(EntityBox entity) {
        return this.texturesGroup.get(entity.getTextureIndex());
    }

    private void addBoxTexture(int index) {
        String fileName = String.format("textures/entity/box/cake_box_%s.png", index);
        this.texturesGroup.add(new ResourceLocation("touhou_little_maid", fileName));
    }
}

