/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.GeckoEntityChairRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3f;

public class EntityChairRenderer
extends LivingRenderer<EntityChair, BedrockModel<EntityChair>> {
    public static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/empty.png");
    private static final String DEFAULT_CHAIR_ID = "touhou_little_maid:cushion";
    public static boolean renderHitBox = true;
    private ChairModelInfo chairInfo;
    private List<Object> chairAnimations;
    private GeckoEntityChairRenderer geckoEntityChairRenderer;

    public EntityChairRenderer(EntityRendererManager rendererManager) {
        super(rendererManager, new BedrockModel(), 0.5f);
        this.geckoEntityChairRenderer = new GeckoEntityChairRenderer(rendererManager);
    }

    public void render(EntityChair chair, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (this.canShowHitBox((PlayerEntity)player) && renderHitBox) {
            this.renderHitBox(chair, matrixStackIn, bufferIn);
        } else {
            this.renderChair(chair, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    private boolean canShowHitBox(@Nullable PlayerEntity player) {
        if (player != null && player.func_225608_bj_()) {
            return player.func_184614_ca().func_77973_b() == InitItems.CHAIR_SHOW.get();
        }
        return false;
    }

    private void renderHitBox(EntityChair chair, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        AxisAlignedBB axisalignedbb = chair.func_174813_aQ().func_72317_d(-chair.func_226277_ct_(), -chair.func_226278_cu_(), -chair.func_226281_cx_());
        WorldRenderer.func_228430_a_((MatrixStack)matrixStackIn, (IVertexBuilder)bufferIn.getBuffer(RenderType.func_228659_m_()), (AxisAlignedBB)axisalignedbb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void renderChair(EntityChair chair, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        CustomPackLoader.CHAIR_MODELS.getModel(DEFAULT_CHAIR_ID).ifPresent(model -> {
            this.field_77045_g = model;
        });
        CustomPackLoader.CHAIR_MODELS.getInfo(DEFAULT_CHAIR_ID).ifPresent(info -> {
            this.chairInfo = info;
        });
        this.chairAnimations = null;
        CustomPackLoader.CHAIR_MODELS.getModel(chair.getModelId()).ifPresent(model -> {
            this.field_77045_g = model;
        });
        CustomPackLoader.CHAIR_MODELS.getInfo(chair.getModelId()).ifPresent(info -> {
            this.chairInfo = info;
        });
        CustomPackLoader.CHAIR_MODELS.getAnimation(chair.getModelId()).ifPresent(animations -> {
            this.chairAnimations = animations;
        });
        if (this.chairInfo.isGeckoModel()) {
            this.geckoEntityChairRenderer.setMainInfo(this.chairInfo);
            this.geckoEntityChairRenderer.func_225623_a_((Entity)chair, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            return;
        }
        ((BedrockModel)this.field_77045_g).setAnimations(this.chairAnimations);
        GlWrapper.setMatrixStack(matrixStackIn);
        super.func_225623_a_((LivingEntity)chair, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        GlWrapper.clearMatrixStack();
    }

    protected void scale(EntityChair chair, MatrixStack matrixStackIn, float partialTickTime) {
        float scale = this.chairInfo.getRenderEntityScale();
        matrixStackIn.func_227862_a_(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(EntityChair entity) {
        if (this.chairInfo == null) {
            return DEFAULT_TEXTURE;
        }
        return this.chairInfo.getTexture();
    }

    protected void setupRotations(EntityChair chair, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
    }

    protected boolean shouldShowName(EntityChair entity) {
        return entity.func_94059_bO();
    }
}

