/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.api.event.client.RenderMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.ChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.GeckoEntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBackItem;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBanner;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBipedHead;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidHeldItem;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.models.MaidModels;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.InGameMaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class EntityMaidRenderer
extends MobRenderer<EntityMaid, BedrockModel<EntityMaid>> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/empty.png");
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    private final GeckoEntityMaidRenderer geckoEntityMaidRenderer;
    private MaidModelInfo mainInfo;
    private List<Object> mainAnimations = Lists.newArrayList();

    public EntityMaidRenderer(EntityRendererManager manager) {
        super(manager, new BedrockModel(), 0.5f);
        this.func_177094_a(new LayerMaidHeldItem(this));
        this.func_177094_a(new LayerMaidBipedHead(this));
        this.func_177094_a(new LayerMaidBackpack(this));
        this.func_177094_a(new LayerMaidBackItem(this));
        this.func_177094_a(new LayerMaidBanner(this));
        this.geckoEntityMaidRenderer = new GeckoEntityMaidRenderer(manager);
    }

    public void render(EntityMaid entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        CustomPackLoader.MAID_MODELS.getModel(DEFAULT_MODEL_ID).ifPresent(model -> {
            this.field_77045_g = model;
        });
        CustomPackLoader.MAID_MODELS.getInfo(DEFAULT_MODEL_ID).ifPresent(info -> {
            this.mainInfo = info;
        });
        CustomPackLoader.MAID_MODELS.getAnimation(DEFAULT_MODEL_ID).ifPresent(animations -> {
            this.mainAnimations = animations;
        });
        MaidModels.ModelData eventModelData = new MaidModels.ModelData((BedrockModel)this.field_77045_g, this.mainInfo, this.mainAnimations);
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderMaidEvent(entity, eventModelData))) {
            BedrockModel<EntityMaid> bedrockModel = eventModelData.getModel();
            if (bedrockModel != null) {
                this.field_77045_g = bedrockModel;
            }
            this.mainInfo = eventModelData.getInfo();
            this.mainAnimations = eventModelData.getAnimations();
        } else {
            CustomPackLoader.MAID_MODELS.getModel(entity.getModelId()).ifPresent(model -> {
                this.field_77045_g = model;
            });
            CustomPackLoader.MAID_MODELS.getInfo(entity.getModelId()).ifPresent(info -> {
                this.mainInfo = info;
            });
            CustomPackLoader.MAID_MODELS.getAnimation(entity.getModelId()).ifPresent(animations -> {
                this.mainAnimations = animations;
            });
        }
        if (InGameMaidConfig.INSTANCE.isShowChatBubble()) {
            ChatBubbleRenderer.renderChatBubble(this, entity, matrixStackIn, bufferIn, packedLightIn);
        }
        if (this.mainInfo.isGeckoModel()) {
            this.geckoEntityMaidRenderer.setMainInfo(this.mainInfo);
            this.geckoEntityMaidRenderer.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            return;
        }
        ((BedrockModel)this.field_77045_g).setAnimations(this.mainAnimations);
        GlWrapper.setMatrixStack(matrixStackIn);
        super.func_225623_a_((MobEntity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        GlWrapper.clearMatrixStack();
    }

    protected void scale(EntityMaid maid, MatrixStack matrixStackIn, float partialTickTime) {
        float scale = this.mainInfo.getRenderEntityScale();
        matrixStackIn.func_227862_a_(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(EntityMaid maid) {
        if (this.mainInfo == null) {
            return DEFAULT_TEXTURE;
        }
        return this.mainInfo.getTexture();
    }

    public MaidModelInfo getMainInfo() {
        return this.mainInfo;
    }
}

