/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class EntityPowerPointRenderer
extends EntityRenderer<EntityPowerPoint> {
    private static final ResourceLocation POWER_POINT_TEXTURES = new ResourceLocation("touhou_little_maid", "textures/entity/power_point.png");
    private static final RenderType RENDER_TYPE = RenderType.func_239268_f_((ResourceLocation)POWER_POINT_TEXTURES);

    public EntityPowerPointRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    private static void vertex(IVertexBuilder bufferIn, Matrix4f pose, Matrix3f normal, double x, double y, double texU, double texV, int packedLight) {
        bufferIn.func_227888_a_(pose, (float)x, (float)y, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_((float)texU, (float)texV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public void render(EntityPowerPoint entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        int texIndex = entity.getIcon();
        int remainder = texIndex % 4;
        int quotient = texIndex / 4;
        double texPos1 = (double)(remainder * 16) / 64.0;
        double texPos2 = (double)(remainder * 16 + 16) / 64.0;
        double texPos3 = (double)(quotient * 16) / 64.0;
        double texPos4 = (double)(quotient * 16 + 16) / 64.0;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.1, 0.0);
        matrixStack.func_227863_a_(this.field_76990_c.func_229098_b_());
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227862_a_(0.3f, 0.3f, 0.3f);
        IVertexBuilder buffer = bufferIn.getBuffer(RENDER_TYPE);
        MatrixStack.Entry matrixStackLast = matrixStack.func_227866_c_();
        Matrix4f pose = matrixStackLast.func_227870_a_();
        Matrix3f normal = matrixStackLast.func_227872_b_();
        EntityPowerPointRenderer.vertex(buffer, pose, normal, -1.0, -0.25, texPos1, texPos4, packedLightIn);
        EntityPowerPointRenderer.vertex(buffer, pose, normal, 1.0, -0.25, texPos2, texPos4, packedLightIn);
        EntityPowerPointRenderer.vertex(buffer, pose, normal, 1.0, 1.75, texPos2, texPos3, packedLightIn);
        EntityPowerPointRenderer.vertex(buffer, pose, normal, -1.0, 1.75, texPos1, texPos3, packedLightIn);
        matrixStack.func_227865_b_();
    }

    public ResourceLocation getTextureLocation(EntityPowerPoint entity) {
        return POWER_POINT_TEXTURES;
    }
}

