/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.TombstoneModel;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class EntityTombstoneRenderer
extends EntityRenderer<EntityTombstone> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/tombstone.png");
    private static final ResourceLocation THE_NETHER_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/tombstone_the_nether.png");
    private static final ResourceLocation THE_END_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/tombstone_the_end.png");
    private static final ResourceLocation TWILIGHT_FOREST_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/tombstone_twilight_forest.png");
    private static final ResourceLocation TWILIGHT_FOREST_NAME = new ResourceLocation("twilightforest", "twilight_forest");
    private static final int NAME_SHOW_DISTANCE = 64;
    private final TombstoneModel tombstoneModel = new TombstoneModel();

    public EntityTombstoneRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void render(EntityTombstone tombstone, float entityYaw, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer bufferIn, int packedLight) {
        poseStack.func_227860_a_();
        poseStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        poseStack.func_227861_a_(0.0, -1.501, 0.0);
        this.tombstoneModel.func_225597_a_(tombstone, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        RenderType renderType = RenderType.func_228644_e_((ResourceLocation)this.getTextureLocation(tombstone));
        IVertexBuilder buffer = bufferIn.getBuffer(renderType);
        this.tombstoneModel.func_225598_a_(poseStack, buffer, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.func_227865_b_();
        if (this.shouldShowName(tombstone)) {
            this.renderNameTag(tombstone, (ITextComponent)new TranslationTextComponent("entity.touhou_little_maid.tombstone.display").func_240701_a_(new TextFormatting[]{TextFormatting.GOLD, TextFormatting.UNDERLINE}), 1.6f, poseStack, bufferIn, packedLight);
            this.renderNameTag(tombstone, tombstone.getMaidName(), 1.85f, poseStack, bufferIn, packedLight);
        }
    }

    protected boolean shouldShowName(EntityTombstone tombstone) {
        return !tombstone.getMaidName().equals(StringTextComponent.field_240750_d_);
    }

    public ResourceLocation getTextureLocation(EntityTombstone entity) {
        ResourceLocation dimension = entity.field_70170_p.func_234923_W_().func_240901_a_();
        if (dimension.equals((Object)World.field_234919_h_.func_240901_a_())) {
            return THE_NETHER_TEXTURE;
        }
        if (dimension.equals((Object)World.field_234920_i_.func_240901_a_())) {
            return THE_END_TEXTURE;
        }
        if (dimension.equals((Object)TWILIGHT_FOREST_NAME)) {
            return TWILIGHT_FOREST_TEXTURE;
        }
        return DEFAULT_TEXTURE;
    }

    private void renderNameTag(EntityTombstone tombstone, ITextComponent component, float yOffset, MatrixStack poseStack, IRenderTypeBuffer bufferSource, int packedLight) {
        double distance = this.field_76990_c.func_229099_b_((Entity)tombstone);
        if (distance < 4096.0) {
            poseStack.func_227860_a_();
            poseStack.func_227861_a_(0.0, (double)yOffset, 0.0);
            poseStack.func_227863_a_(this.field_76990_c.func_229098_b_());
            poseStack.func_227862_a_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = poseStack.func_227866_c_().func_227870_a_();
            FontRenderer font = this.func_76983_a();
            float width = -font.func_238414_a_((ITextProperties)component) / 2;
            font.func_243247_a(component, width, 0.0f, -1, false, matrix4f, bufferSource, false, 0, packedLight);
            poseStack.func_227865_b_();
        }
    }
}

