/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.EntityYukkuriModel;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.SlimeRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class EntityYukkuriSlimeRender
extends MobRenderer<SlimeEntity, EntityYukkuriModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/yukkuri.png");
    private final SlimeRenderer vanillaRender;

    public EntityYukkuriSlimeRender(EntityRendererManager context) {
        super(context, (EntityModel)new EntityYukkuriModel(), 0.25f);
        this.vanillaRender = new SlimeRenderer(context);
    }

    public void render(SlimeEntity slime, float yaw, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffer, int packedLight) {
        if (((Boolean)VanillaConfig.REPLACE_SLIME_MODEL.get()).booleanValue()) {
            this.renderYukkuri(slime, yaw, partialTicks, poseStack, buffer, packedLight);
        } else {
            this.vanillaRender.func_225623_a_(slime, yaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    private void renderYukkuri(SlimeEntity slime, float yaw, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffer, int packedLight) {
        this.field_76989_e = 0.25f * (float)slime.func_70809_q();
        super.func_225623_a_((MobEntity)slime, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void scale(SlimeEntity slime, MatrixStack poseStack, float partialTicks) {
        poseStack.func_227862_a_(0.999f, 0.999f, 0.999f);
        poseStack.func_227861_a_(0.0, (double)0.001f, 0.0);
        float slimeSize = slime.func_70809_q();
        float tmp = MathHelper.func_219799_g((float)partialTicks, (float)slime.field_70812_c, (float)slime.field_70811_b) / (slimeSize * 0.5f + 1.0f);
        float scale = 1.0f / (tmp + 1.0f);
        poseStack.func_227862_a_(scale * slimeSize, 1.0f / scale * slimeSize, scale * slimeSize);
    }

    public ResourceLocation getTextureLocation(SlimeEntity slime) {
        return TEXTURE;
    }
}

