/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.ExperienceOrbRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class ReplaceExperienceOrbRenderer
extends EntityRenderer<ExperienceOrbEntity> {
    private static final ResourceLocation POINT_ITEM_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/point_item.png");
    private static final RenderType RENDER_TYPE = RenderType.func_228640_c_((ResourceLocation)POINT_ITEM_TEXTURE);
    private final ExperienceOrbRenderer vanillaRender;

    public ReplaceExperienceOrbRenderer(EntityRendererManager context) {
        super(context);
        this.field_76989_e = 0.15f;
        this.field_76987_f = 0.75f;
        this.vanillaRender = new ExperienceOrbRenderer(context);
    }

    private static void vertex(IVertexBuilder pConsumer, Matrix4f pMatrix, Matrix3f pMatrixNormal, float pX, float pY, int pRed, int pGreen, int pBlue, float pTexU, float pTexV, int pPackedLight) {
        pConsumer.func_227888_a_(pMatrix, pX, pY, 0.0f).func_225586_a_(pRed, pGreen, pBlue, 128).func_225583_a_(pTexU, pTexV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(pPackedLight).func_227887_a_(pMatrixNormal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    protected int getBlockLightLevel(ExperienceOrbEntity pEntity, BlockPos pPos) {
        return MathHelper.func_76125_a((int)(super.func_225624_a_((Entity)pEntity, pPos) + 7), (int)0, (int)15);
    }

    public void render(ExperienceOrbEntity orb, float pEntityYaw, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffer, int packedLight) {
        if (((Boolean)VanillaConfig.REPLACE_XP_TEXTURE.get()).booleanValue()) {
            this.renderPointItem(orb, pEntityYaw, partialTicks, poseStack, buffer, packedLight);
        } else {
            this.vanillaRender.func_225623_a_(orb, pEntityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    private void renderPointItem(ExperienceOrbEntity orb, float pEntityYaw, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffer, int packedLight) {
        poseStack.func_227860_a_();
        int icon = orb.func_70528_g();
        float texU1 = (float)(icon % 4 * 16) / 64.0f;
        float texU2 = (float)(icon % 4 * 16 + 16) / 64.0f;
        float texV2 = (float)(icon / 4 * 16) / 64.0f;
        float texV1 = (float)(icon / 4 * 16 + 16) / 64.0f;
        poseStack.func_227861_a_(0.0, (double)0.1f, 0.0);
        poseStack.func_227863_a_(this.field_76990_c.func_229098_b_());
        poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        poseStack.func_227862_a_(0.3f, 0.3f, 0.3f);
        IVertexBuilder consumer = buffer.getBuffer(RENDER_TYPE);
        MatrixStack.Entry lasted = poseStack.func_227866_c_();
        Matrix4f pose = lasted.func_227870_a_();
        Matrix3f normal = lasted.func_227872_b_();
        ReplaceExperienceOrbRenderer.vertex(consumer, pose, normal, -0.5f, -0.25f, 255, 255, 255, texU1, texV1, packedLight);
        ReplaceExperienceOrbRenderer.vertex(consumer, pose, normal, 0.5f, -0.25f, 255, 255, 255, texU2, texV1, packedLight);
        ReplaceExperienceOrbRenderer.vertex(consumer, pose, normal, 0.5f, 0.75f, 255, 255, 255, texU2, texV2, packedLight);
        ReplaceExperienceOrbRenderer.vertex(consumer, pose, normal, -0.5f, 0.75f, 255, 255, 255, texU1, texV2, packedLight);
        poseStack.func_227865_b_();
        super.func_225623_a_((Entity)orb, pEntityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(ExperienceOrbEntity pEntity) {
        return POINT_ITEM_TEXTURE;
    }
}

