/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.client.model.MaidBannerModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.GeckoEntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.InGameMaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.BannerTileEntityRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BannerItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class GeckoLayerMaidBanner<T extends LivingEntity>
extends GeoLayerRenderer<T> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/maid_banner.png");
    private final GeckoEntityMaidRenderer renderer;
    private final MaidBannerModel bannerModel;

    public GeckoLayerMaidBanner(GeckoEntityMaidRenderer renderer) {
        super(renderer);
        this.renderer = renderer;
        this.bannerModel = new MaidBannerModel();
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (livingEntity instanceof EntityMaid && ((EntityMaid)((Object)livingEntity)).getBackpackShowItem().func_77973_b() instanceof BannerItem) {
            EntityMaid maid = (EntityMaid)((Object)livingEntity);
            BannerItem bannerItem = (BannerItem)maid.getBackpackShowItem().func_77973_b();
            if (!this.renderer.getMainInfo().isShowBackpack() || !InGameMaidConfig.INSTANCE.isShowBackItem() || maid.func_70608_bn() || maid.func_82150_aj()) {
                return;
            }
            GeoModel geoModel = this.entityRenderer.getGeoModel();
            if (geoModel != null && !geoModel.backpackBones.isEmpty()) {
                matrixStack.func_227860_a_();
                this.translateToBackpack(matrixStack, geoModel);
                matrixStack.func_227861_a_(0.0, -1.5, 0.02);
                matrixStack.func_227862_a_(0.65f, 0.65f, 0.65f);
                matrixStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(5.0f));
                IVertexBuilder buffer = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)TEXTURE));
                this.bannerModel.func_225598_a_(matrixStack, buffer, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                List list = BannerTileEntity.func_230138_a_((DyeColor)bannerItem.func_195948_b(), (ListNBT)BannerTileEntity.func_230139_a_((ItemStack)maid.getBackpackShowItem()));
                BannerTileEntityRenderer.func_230180_a_((MatrixStack)matrixStack, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (int)OverlayTexture.field_229196_a_, (ModelRenderer)this.bannerModel.getBanner(), (RenderMaterial)ModelBakery.field_229315_f_, (boolean)true, (List)list);
                matrixStack.func_227865_b_();
            }
        }
    }

    private void translateToBackpack(MatrixStack poseStack, GeoModel geoModel) {
        int size = geoModel.backpackBones.size();
        for (int i = 0; i < size - 1; ++i) {
            RenderUtils.prepMatrixForBone(poseStack, geoModel.backpackBones.get(i));
        }
        GeoBone lastBone = geoModel.backpackBones.get(size - 1);
        RenderUtils.translateMatrixToBone(poseStack, lastBone);
        RenderUtils.translateToPivotPoint(poseStack, lastBone);
        RenderUtils.rotateMatrixAroundBone(poseStack, lastBone);
        RenderUtils.scaleMatrixForBone(poseStack, lastBone);
    }
}

