/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.GeckoEntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.IPlantable;
import org.apache.commons.lang3.StringUtils;

public class GeckoLayerMaidBipedHead<T extends LivingEntity>
extends GeoLayerRenderer<T> {
    private static final String SKULL_OWNER_TAG = "SkullOwner";
    private final GeckoEntityMaidRenderer maidRenderer;

    public GeckoLayerMaidBipedHead(GeckoEntityMaidRenderer entityRendererIn) {
        super(entityRendererIn);
        this.maidRenderer = entityRendererIn;
    }

    @Override
    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, LivingEntity entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entityLivingBaseIn instanceof EntityMaid && this.maidRenderer.getGeoModel() != null) {
            Block block;
            ItemStack stack;
            EntityMaid maid = (EntityMaid)entityLivingBaseIn;
            ItemStack head = maid.func_184582_a(EquipmentSlotType.HEAD);
            GeoModel geoModel = this.maidRenderer.getGeoModel();
            if (!head.func_190926_b() && this.maidRenderer.getMainInfo().isShowCustomHead() && !geoModel.headBones.isEmpty()) {
                Item item = head.func_77973_b();
                matrixStackIn.func_227860_a_();
                this.translateToHead(matrixStackIn, geoModel);
                if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof AbstractSkullBlock) {
                    AbstractSkullBlock skullBlock = (AbstractSkullBlock)((BlockItem)item).func_179223_d();
                    matrixStackIn.func_227862_a_(-1.1875f, 1.1875f, -1.1875f);
                    GameProfile gameprofile = this.getSkullGameProfile(head);
                    matrixStackIn.func_227861_a_(-0.5, 0.0, -0.5);
                    SkullTileEntityRenderer.func_228879_a_(null, (float)180.0f, (SkullBlock.ISkullType)skullBlock.func_196292_N_(), (GameProfile)gameprofile, (float)limbSwing, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn);
                }
                matrixStackIn.func_227865_b_();
            }
            if ((stack = maid.getMaidInv().getStackInSlot(5)).func_77973_b() instanceof BlockItem && this.maidRenderer.getMainInfo().isShowCustomHead() && !geoModel.headBones.isEmpty() && (block = ((BlockItem)stack.func_77973_b()).func_179223_d()) instanceof IPlantable && !(block instanceof DoublePlantBlock)) {
                BlockState plant = ((IPlantable)block).getPlant((IBlockReader)maid.field_70170_p, maid.func_233580_cy_());
                matrixStackIn.func_227860_a_();
                this.translateToHead(matrixStackIn, geoModel);
                matrixStackIn.func_227862_a_(-0.8f, 0.8f, -0.8f);
                matrixStackIn.func_227861_a_(-0.5, 0.625, -0.5);
                Minecraft.func_71410_x().func_175602_ab().func_228791_a_(plant, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_);
                matrixStackIn.func_227865_b_();
            }
        }
    }

    @Nullable
    private GameProfile getSkullGameProfile(ItemStack head) {
        CompoundNBT nbt;
        GameProfile gameProfile = null;
        if (head.func_77942_o() && (nbt = head.func_77978_p()) != null) {
            String skullOwner;
            if (nbt.func_150297_b(SKULL_OWNER_TAG, 10)) {
                gameProfile = NBTUtil.func_152459_a((CompoundNBT)nbt.func_74775_l(SKULL_OWNER_TAG));
            } else if (nbt.func_150297_b(SKULL_OWNER_TAG, 8) && !StringUtils.isBlank((CharSequence)(skullOwner = nbt.func_74779_i(SKULL_OWNER_TAG))) && (gameProfile = SkullTileEntity.func_174884_b((GameProfile)new GameProfile(null, skullOwner))) != null) {
                nbt.func_218657_a(SKULL_OWNER_TAG, (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)gameProfile));
            }
        }
        return gameProfile;
    }

    protected void translateToHead(MatrixStack matrixStack, GeoModel geoModel) {
        int size = geoModel.headBones.size();
        for (int i = 0; i < size - 1; ++i) {
            RenderUtils.prepMatrixForBone(matrixStack, geoModel.headBones.get(i));
        }
        GeoBone lastBone = geoModel.headBones.get(size - 1);
        RenderUtils.translateMatrixToBone(matrixStack, lastBone);
        RenderUtils.translateToPivotPoint(matrixStack, lastBone);
        RenderUtils.rotateMatrixAroundBone(matrixStack, lastBone);
        RenderUtils.scaleMatrixForBone(matrixStack, lastBone);
    }
}

