/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeRender;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3f;

public class GeckoLayerMaidHeld<T extends LivingEntity>
extends GeoLayerRenderer<T> {
    private final FirstPersonRenderer itemInHandRenderer = Minecraft.func_71410_x().func_175597_ag();

    public GeckoLayerMaidHeld(IGeoRenderer<T> entityRendererIn) {
        super(entityRendererIn);
    }

    @Override
    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, LivingEntity entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.entityRenderer.getGeoModel() == null) {
            return;
        }
        ItemStack offhandItem = entityLivingBaseIn.func_184592_cb();
        ItemStack mainHandItem = entityLivingBaseIn.func_184614_ca();
        GeoModel geoModel = this.entityRenderer.getGeoModel();
        if (!offhandItem.func_190926_b() || !mainHandItem.func_190926_b()) {
            matrixStackIn.func_227860_a_();
            if (!geoModel.rightHandBones.isEmpty()) {
                if (SlashBladeCompat.isSlashBladeItem(mainHandItem)) {
                    SlashBladeRender.renderMaidMainhandSlashBlade(entityLivingBaseIn, geoModel, matrixStackIn, bufferIn, packedLightIn, mainHandItem, partialTicks);
                } else {
                    this.renderArmWithItem(entityLivingBaseIn, mainHandItem, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HandSide.RIGHT, matrixStackIn, bufferIn, packedLightIn);
                }
            }
            if (!geoModel.leftHandBones.isEmpty()) {
                if (SlashBladeCompat.isSlashBladeItem(offhandItem)) {
                    SlashBladeRender.renderMaidOffhandSlashBlade(geoModel, matrixStackIn, bufferIn, packedLightIn, offhandItem);
                } else {
                    this.renderArmWithItem(entityLivingBaseIn, offhandItem, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HandSide.LEFT, matrixStackIn, bufferIn, packedLightIn);
                }
            }
            matrixStackIn.func_227865_b_();
        }
    }

    protected void renderArmWithItem(LivingEntity livingEntity, ItemStack itemStack, ItemCameraTransforms.TransformType displayContext, HandSide arm, MatrixStack matrixStack, IRenderTypeBuffer bufferSource, int light) {
        if (!itemStack.func_190926_b() && this.entityRenderer.getGeoModel() != null) {
            matrixStack.func_227860_a_();
            this.translateToHand(arm, matrixStack, this.entityRenderer.getGeoModel());
            matrixStack.func_227861_a_(0.0, -0.0625, -0.1);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            boolean isLeftHand = arm == HandSide.LEFT;
            this.itemInHandRenderer.func_228397_a_(livingEntity, itemStack, displayContext, isLeftHand, matrixStack, bufferSource, light);
            matrixStack.func_227865_b_();
        }
    }

    protected void translateToHand(HandSide arm, MatrixStack matrixStack, GeoModel geoModel) {
        if (arm == HandSide.LEFT) {
            int size = geoModel.leftHandBones.size();
            for (int i = 0; i < size - 1; ++i) {
                RenderUtils.prepMatrixForBone(matrixStack, geoModel.leftHandBones.get(i));
            }
            GeoBone lastBone = geoModel.leftHandBones.get(size - 1);
            RenderUtils.translateMatrixToBone(matrixStack, lastBone);
            RenderUtils.translateToPivotPoint(matrixStack, lastBone);
            RenderUtils.rotateMatrixAroundBone(matrixStack, lastBone);
            RenderUtils.scaleMatrixForBone(matrixStack, lastBone);
        } else {
            int size = geoModel.rightHandBones.size();
            for (int i = 0; i < size - 1; ++i) {
                RenderUtils.prepMatrixForBone(matrixStack, geoModel.rightHandBones.get(i));
            }
            GeoBone lastBone = geoModel.rightHandBones.get(size - 1);
            RenderUtils.translateMatrixToBone(matrixStack, lastBone);
            RenderUtils.translateToPivotPoint(matrixStack, lastBone);
            RenderUtils.rotateMatrixAroundBone(matrixStack, lastBone);
            RenderUtils.scaleMatrixForBone(matrixStack, lastBone);
        }
    }
}

