/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer;

import com.github.tartaricacid.touhoulittlemaid.client.model.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeRender;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3f;

public class LayerMaidHeldItem
extends LayerRenderer<EntityMaid, BedrockModel<EntityMaid>> {
    public LayerMaidHeldItem(EntityMaidRenderer maidRenderer) {
        super((IEntityRenderer)maidRenderer);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityMaid maid, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack mainRightItem = maid.func_184614_ca();
        ItemStack offLeftItem = maid.func_184592_cb();
        BedrockModel model = (BedrockModel)this.func_215332_c();
        if (!mainRightItem.func_190926_b() && model.hasRightArm()) {
            if (SlashBladeCompat.isSlashBladeItem(mainRightItem)) {
                SlashBladeRender.renderMaidMainhandSlashBlade(maid, model, matrixStackIn, bufferIn, packedLightIn, mainRightItem, partialTicks);
            } else {
                this.renderArmWithItem(maid, mainRightItem, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HandSide.RIGHT, matrixStackIn, bufferIn, packedLightIn);
            }
        }
        if (!offLeftItem.func_190926_b() && model.hasLeftArm()) {
            if (SlashBladeCompat.isSlashBladeItem(offLeftItem)) {
                SlashBladeRender.renderMaidOffhandSlashBlade(model, matrixStackIn, bufferIn, packedLightIn, offLeftItem);
            } else {
                this.renderArmWithItem(maid, offLeftItem, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HandSide.LEFT, matrixStackIn, bufferIn, packedLightIn);
            }
        }
    }

    private void renderArmWithItem(EntityMaid maid, ItemStack itemStack, ItemCameraTransforms.TransformType transformTypeIn, HandSide handSide, MatrixStack matrixStack, IRenderTypeBuffer typeBuffer, int combinedLightIn) {
        if (!itemStack.func_190926_b()) {
            matrixStack.func_227860_a_();
            boolean isLeft = handSide == HandSide.LEFT;
            ((BedrockModel)this.func_215332_c()).translateToHand(handSide, matrixStack);
            if (((BedrockModel)this.func_215332_c()).hasArmPositioningModel(handSide)) {
                ((BedrockModel)this.func_215332_c()).translateToPositioningHand(handSide, matrixStack);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrixStack.func_227861_a_(0.0, 0.125, -0.0625);
            } else {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrixStack.func_227861_a_((double)(isLeft ? -1 : 1) / 16.0, 0.125, -0.525);
            }
            Minecraft.func_71410_x().func_175597_ag().func_228397_a_((LivingEntity)maid, itemStack, transformTypeIn, isLeft, matrixStack, typeBuffer, combinedLightIn);
            matrixStack.func_227865_b_();
        }
    }
}

