/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.texture;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class FilePackTexture
extends SizeTexture {
    private final ResourceLocation texturePath;
    private final Path rootPath;
    private int width = 16;
    private int height = 16;

    public FilePackTexture(Path rootPath, ResourceLocation texturePath) {
        this.rootPath = rootPath;
        this.texturePath = texturePath;
    }

    @Override
    public boolean isExist() {
        File textureFile = this.rootPath.resolve("assets").resolve(this.texturePath.func_110624_b()).resolve(this.texturePath.func_110623_a()).toFile();
        return textureFile.isFile();
    }

    public void func_195413_a(IResourceManager manager) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::doLoad);
        } else {
            this.doLoad();
        }
    }

    private void doLoad() {
        File textureFile = this.rootPath.resolve("assets").resolve(this.texturePath.func_110624_b()).resolve(this.texturePath.func_110623_a()).toFile();
        if (textureFile.isFile()) {
            try (InputStream stream = Files.newInputStream(textureFile.toPath(), new OpenOption[0]);){
                NativeImage imageIn = NativeImage.func_195713_a((InputStream)stream);
                this.width = imageIn.func_195702_a();
                this.height = imageIn.func_195714_b();
                TextureUtil.func_225681_a_((int)this.func_110552_b(), (int)0, (int)this.width, (int)this.height);
                imageIn.func_227789_a_(0, 0, 0, 0, 0, this.width, this.height, false, false, false, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

