/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.texture;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class ZipPackTexture
extends SizeTexture {
    private final ResourceLocation texturePath;
    private final Path zipFilePath;
    private int width = 16;
    private int height = 16;

    public ZipPackTexture(String zipFilePath, ResourceLocation texturePath) {
        this.zipFilePath = Paths.get(zipFilePath, new String[0]);
        this.texturePath = texturePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isExist() {
        try (ZipFile zipFile = new ZipFile(this.zipFilePath.toFile());){
            ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", this.texturePath.func_110624_b(), this.texturePath.func_110623_a()));
            boolean bl = entry != null;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void func_195413_a(IResourceManager manager) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::doLoad);
        } else {
            this.doLoad();
        }
    }

    private void doLoad() {
        try (ZipFile zipFile = new ZipFile(this.zipFilePath.toFile());){
            ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", this.texturePath.func_110624_b(), this.texturePath.func_110623_a()));
            if (entry == null) {
                return;
            }
            try (InputStream stream = zipFile.getInputStream(entry);){
                NativeImage imageIn = NativeImage.func_195713_a((InputStream)stream);
                this.width = imageIn.func_195702_a();
                this.height = imageIn.func_195714_b();
                TextureUtil.func_225681_a_((int)this.func_110552_b(), (int)0, (int)this.width, (int)this.height);
                imageIn.func_227789_a_(0, 0, 0, 0, 0, this.width, this.height, false, false, false, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

