/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.client.model.StatueBaseModel;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGarageKit;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class TileEntityGarageKitRenderer
extends TileEntityRenderer<TileEntityGarageKit> {
    private static final StatueBaseModel BASE_MODEL = new StatueBaseModel();
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/statue_base.png");

    public TileEntityGarageKitRenderer(TileEntityRendererDispatcher render) {
        super(render);
    }

    public void render(TileEntityGarageKit te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        matrixStack.func_227861_a_(1.0, 0.5, 1.0);
        matrixStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
        IVertexBuilder buffer = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)TEXTURE));
        BASE_MODEL.func_225598_a_(matrixStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
        CompoundNBT data = te.getExtraData();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (data.isEmpty() || world == null) {
            return;
        }
        EntityType.func_220327_a((String)data.func_74779_i("id")).ifPresent(arg_0 -> this.lambda$render$0(te, matrixStack, bufferIn, combinedLightIn, data, (World)world, arg_0));
    }

    private void renderEntity(TileEntityGarageKit te, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, CompoundNBT data, World world, EntityType<?> type) throws ExecutionException {
        Entity entity = (Entity)EntityCacheUtil.ENTITY_CACHE.get(type, () -> {
            Entity e = type.func_200721_a(world);
            if (e == null) {
                return new EntityMaid(world);
            }
            return e;
        });
        entity.func_70020_e(data);
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            EntityCacheUtil.clearMaidDataResidue(maid, true);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        matrixStack.func_227861_a_(1.0, 0.21328125, 1.0);
        switch (te.getFacing()) {
            case EAST: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                break;
            }
            case WEST: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            default: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            }
        }
        EntityRendererManager render = Minecraft.func_71410_x().func_175598_ae();
        boolean isShowHitBox = render.func_178634_b();
        render.func_178629_b(false);
        render.func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrixStack, bufferIn, combinedLightIn);
        render.func_178629_b(isShowHitBox);
        matrixStack.func_227865_b_();
    }

    private /* synthetic */ void lambda$render$0(TileEntityGarageKit te, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, CompoundNBT data, World world, EntityType type) {
        try {
            this.renderEntity(te, matrixStack, bufferIn, combinedLightIn, data, world, type);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

