/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGomoku;
import com.github.tartaricacid.touhoulittlemaid.client.model.GomokuModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.PieceModel;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGomoku;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TileEntityGomokuRenderer
extends TileEntityRenderer<TileEntityGomoku> {
    private static final ResourceLocation CHECKER_BOARD_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/gomoku.png");
    private static final ResourceLocation BLACK_PIECE_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/black_piece.png");
    private static final ResourceLocation WHITE_PIECE_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/white_piece.png");
    private static final int TIPS_RENDER_DISTANCE = 16;
    private static final int PIECE_RENDER_DISTANCE = 24;
    private final GomokuModel CHECKER_BOARD_MODEL = new GomokuModel();
    private final PieceModel PIECE_MODEL = new PieceModel();

    public TileEntityGomokuRenderer(TileEntityRendererDispatcher context) {
        super(context);
    }

    public void render(TileEntityGomoku gomoku, float partialTick, MatrixStack poseStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderChessboard(gomoku, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        this.renderPiece(gomoku, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        this.renderLatestChessTips(gomoku, poseStack, bufferIn, combinedLightIn);
        this.renderTipsText(gomoku, poseStack, bufferIn, combinedLightIn);
    }

    private void renderLatestChessTips(TileEntityGomoku gomoku, MatrixStack poseStack, IRenderTypeBuffer bufferIn, int combinedLightIn) {
        if (!gomoku.getLatestChessPoint().equals(Point.NULL) && this.inRenderDistance(gomoku, 24)) {
            ActiveRenderInfo camera = this.field_228858_b_.field_217666_g;
            Point point = gomoku.getLatestChessPoint();
            poseStack.func_227860_a_();
            poseStack.func_227861_a_(-0.42, 0.25, -0.42);
            poseStack.func_227861_a_((double)point.x * 0.1316, 0.0, (double)point.y * 0.1316);
            poseStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(180.0f + camera.func_216778_f()));
            poseStack.func_227862_a_(0.015625f, -0.015625f, 0.015625f);
            float width = (float)(-this.field_228858_b_.field_147557_n.func_78256_a("\u25bc") / 2) + 0.5f;
            this.field_228858_b_.field_147557_n.func_228079_a_("\u25bc", width, -1.5f, 0xFF0000, false, poseStack.func_227866_c_().func_227870_a_(), bufferIn, false, 0, combinedLightIn);
            poseStack.func_227865_b_();
        }
    }

    private void renderChessboard(TileEntityGomoku gomoku, MatrixStack poseStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Direction facing = (Direction)gomoku.func_195044_w().func_177229_b((Property)BlockGomoku.FACING);
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.5, 1.5, 0.5);
        poseStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
        poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(facing.func_176736_b() * 90)));
        IVertexBuilder checkerBoardBuff = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)CHECKER_BOARD_TEXTURE));
        this.CHECKER_BOARD_MODEL.func_225598_a_(poseStack, checkerBoardBuff, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.func_227865_b_();
    }

    private void renderPiece(TileEntityGomoku gomoku, MatrixStack poseStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (this.inRenderDistance(gomoku, 24)) {
            int[][] chessData;
            poseStack.func_227860_a_();
            poseStack.func_227861_a_(0.5, 1.5, 0.5);
            poseStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
            poseStack.func_227861_a_(0.92, -0.1, -1.055);
            for (int[] row : chessData = gomoku.getChessData()) {
                for (int j = 0; j < chessData[0].length; ++j) {
                    poseStack.func_227861_a_(0.0, 0.0, 0.1316);
                    if (row[j] == 1) {
                        IVertexBuilder blackPieceBuff = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)BLACK_PIECE_TEXTURE));
                        this.PIECE_MODEL.func_225598_a_(poseStack, blackPieceBuff, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                    if (row[j] != 2) continue;
                    IVertexBuilder whitePieceBuff = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)WHITE_PIECE_TEXTURE));
                    this.PIECE_MODEL.func_225598_a_(poseStack, whitePieceBuff, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                poseStack.func_227861_a_(-0.1316, 0.0, -1.974);
            }
            poseStack.func_227865_b_();
        }
    }

    private void renderTipsText(TileEntityGomoku gomoku, MatrixStack poseStack, IRenderTypeBuffer bufferIn, int combinedLightIn) {
        if (!gomoku.isInProgress() && this.inRenderDistance(gomoku, 16)) {
            ActiveRenderInfo camera = this.field_228858_b_.field_217666_g;
            IFormattableTextComponent resetTips = new TranslationTextComponent("message.touhou_little_maid.gomoku.reset").func_240699_a_(TextFormatting.UNDERLINE).func_240699_a_(TextFormatting.AQUA);
            IFormattableTextComponent roundText = new TranslationTextComponent("message.touhou_little_maid.gomoku.round", new Object[]{gomoku.getChessCounter()}).func_240699_a_(TextFormatting.WHITE);
            IFormattableTextComponent preRoundIcon = new StringTextComponent("\u23f9 ").func_240699_a_(TextFormatting.GREEN);
            IFormattableTextComponent postRoundIcon = new StringTextComponent(" \u23f9").func_240699_a_(TextFormatting.GREEN);
            IFormattableTextComponent roundTips = preRoundIcon.func_230529_a_((ITextComponent)roundText).func_230529_a_((ITextComponent)postRoundIcon);
            IFormattableTextComponent loseTips = gomoku.isPlayerTurn() ? new TranslationTextComponent("message.touhou_little_maid.gomoku.win").func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.DARK_PURPLE) : new TranslationTextComponent("message.touhou_little_maid.gomoku.lose").func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.DARK_PURPLE);
            float loseTipsWidth = -this.field_228858_b_.field_147557_n.func_238414_a_((ITextProperties)loseTips) / 2;
            float resetTipsWidth = -this.field_228858_b_.field_147557_n.func_238414_a_((ITextProperties)resetTips) / 2;
            float roundTipsWidth = -this.field_228858_b_.field_147557_n.func_238414_a_((ITextProperties)roundTips) / 2;
            poseStack.func_227860_a_();
            poseStack.func_227861_a_(0.5, 0.75, 0.5);
            poseStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(180.0f + camera.func_216778_f()));
            poseStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(camera.func_216777_e()));
            poseStack.func_227862_a_(0.03f, -0.03f, 0.03f);
            this.field_228858_b_.field_147557_n.func_243247_a((ITextComponent)loseTips, loseTipsWidth, -10.0f, 0xFFFFFF, true, poseStack.func_227866_c_().func_227870_a_(), bufferIn, false, 0, combinedLightIn);
            poseStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            this.field_228858_b_.field_147557_n.func_243247_a((ITextComponent)roundTips, roundTipsWidth, -30.0f, 0xFFFFFF, true, poseStack.func_227866_c_().func_227870_a_(), bufferIn, false, 0, combinedLightIn);
            this.field_228858_b_.field_147557_n.func_243247_a((ITextComponent)resetTips, resetTipsWidth, 0.0f, 0xFFFFFF, true, poseStack.func_227866_c_().func_227870_a_(), bufferIn, false, 0, combinedLightIn);
            poseStack.func_227865_b_();
        }
    }

    private boolean inRenderDistance(TileEntityGomoku gomoku, int distance) {
        BlockPos pos = gomoku.func_174877_v();
        return this.field_228858_b_.field_217666_g.func_216785_c().func_186679_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) < (double)(distance * distance);
    }

    public boolean shouldRenderOffScreen(TileEntityGomoku te) {
        return true;
    }
}

