/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.client.model.StatueBaseModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.ItemGarageKit;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class TileEntityItemStackGarageKitRenderer
extends ItemStackTileEntityRenderer {
    private static final StatueBaseModel BASE_MODEL = new StatueBaseModel();
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/statue_base.png");

    public void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        matrixStack.func_227861_a_(1.0, 0.5, 1.0);
        matrixStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
        IVertexBuilder buffer = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)TEXTURE));
        BASE_MODEL.func_225598_a_(matrixStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
        CompoundNBT data = ItemGarageKit.getMaidData(stack);
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (data.isEmpty() || world == null) {
            return;
        }
        EntityType.func_220327_a((String)data.func_74779_i("id")).ifPresent(arg_0 -> this.lambda$renderByItem$0(matrixStack, bufferIn, combinedLightIn, data, (World)world, arg_0));
    }

    private void renderEntity(MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, CompoundNBT data, World world, EntityType<?> type) throws ExecutionException {
        Entity entity = (Entity)EntityCacheUtil.ENTITY_CACHE.get(type, () -> {
            Entity e = type.func_200721_a(world);
            if (e == null) {
                return new EntityMaid(world);
            }
            return e;
        });
        float renderItemScale = 1.0f;
        entity.func_70020_e(data);
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            EntityCacheUtil.clearMaidDataResidue(maid, true);
            if (data.func_150297_b("ModelId", 8)) {
                String modelId = data.func_74779_i("ModelId");
                renderItemScale = CustomPackLoader.MAID_MODELS.getModelRenderItemScale(modelId);
            }
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        matrixStack.func_227862_a_(renderItemScale, renderItemScale, renderItemScale);
        matrixStack.func_227861_a_(1.0, 0.21328125, 1.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        EntityRendererManager render = Minecraft.func_71410_x().func_175598_ae();
        boolean isShowHitBox = render.func_178634_b();
        render.func_178629_b(false);
        RenderSystem.runAsFancy(() -> render.func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrixStack, bufferIn, combinedLightIn));
        render.func_178629_b(isShowHitBox);
        matrixStack.func_227865_b_();
    }

    private /* synthetic */ void lambda$renderByItem$0(MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, CompoundNBT data, World world, EntityType type) {
        try {
            this.renderEntity(matrixStack, bufferIn, combinedLightIn, data, world, type);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

