/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.block.BlockGomoku;
import com.github.tartaricacid.touhoulittlemaid.client.model.ShrineModel;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityShrine;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class TileEntityShrineRenderer
extends TileEntityRenderer<TileEntityShrine> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/shrine.png");
    private final ShrineModel model = new ShrineModel();

    public TileEntityShrineRenderer(TileEntityRendererDispatcher context) {
        super(context);
    }

    public void render(TileEntityShrine shrine, float partialTick, MatrixStack poseStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Direction facing = (Direction)shrine.func_195044_w().func_177229_b((Property)BlockGomoku.FACING);
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.5, 1.5, 0.5);
        poseStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
        poseStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_((float)(180 - facing.func_176736_b() * 90)));
        IVertexBuilder buffer = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)TEXTURE));
        this.model.func_225598_a_(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.func_227865_b_();
        World level = shrine.func_145831_w();
        if (level == null) {
            return;
        }
        ItemStack stack = shrine.getStorageItem();
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.5, 0.85, 0.5);
        poseStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        float deg = ((float)level.func_82737_E() + partialTick) % 360.0f;
        poseStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(deg));
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, combinedLightIn, combinedOverlayIn, poseStack, bufferIn);
        poseStack.func_227865_b_();
    }
}

