/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.command.arguments.HandleTypeArgument;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class MaidNumCommand {
    private static final String MAID_NUM_NAME = "maid_num";
    private static final String GET_NAME = "get";
    private static final String HANDLE_NAME = "handle";
    private static final String TARGETS_NAME = "targets";
    private static final String COUNT_NAME = "count";

    public static LiteralArgumentBuilder<CommandSource> get() {
        LiteralArgumentBuilder pack = Commands.func_197057_a((String)MAID_NUM_NAME);
        RequiredArgumentBuilder targets = Commands.func_197056_a((String)TARGETS_NAME, (ArgumentType)EntityArgument.func_197094_d());
        RequiredArgumentBuilder count = Commands.func_197056_a((String)COUNT_NAME, (ArgumentType)IntegerArgumentType.integer((int)0));
        RequiredArgumentBuilder handleType = Commands.func_197056_a((String)HANDLE_NAME, (ArgumentType)HandleTypeArgument.type());
        pack.then(Commands.func_197057_a((String)GET_NAME).then(targets.executes(MaidNumCommand::getMaidNum)));
        pack.then(handleType.then(targets.then(count.executes(MaidNumCommand::handleMaidNum))));
        return pack;
    }

    private static int handleMaidNum(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection players = EntityArgument.func_197090_e(context, (String)TARGETS_NAME);
        int count = IntegerArgumentType.getInteger(context, (String)COUNT_NAME);
        String type = HandleTypeArgument.getType(context, HANDLE_NAME);
        for (PlayerEntity player : players) {
            switch (type) {
                case "set": {
                    player.getCapability(MaidNumCapabilityProvider.MAID_NUM_CAP, null).ifPresent(power -> power.set(count));
                    break;
                }
                case "add": {
                    player.getCapability(MaidNumCapabilityProvider.MAID_NUM_CAP, null).ifPresent(power -> power.add(count));
                    break;
                }
                case "min": {
                    player.getCapability(MaidNumCapabilityProvider.MAID_NUM_CAP, null).ifPresent(power -> power.min(count));
                    break;
                }
            }
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.touhou_little_maid.maid_num.handle.info", new Object[]{players.size()}), true);
        return 1;
    }

    private static int getMaidNum(CommandContext<CommandSource> context) throws CommandSyntaxException {
        for (PlayerEntity player : EntityArgument.func_197090_e(context, (String)TARGETS_NAME)) {
            player.getCapability(MaidNumCapabilityProvider.MAID_NUM_CAP, null).ifPresent(maidNum -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.touhou_little_maid.maid_num.get.info", new Object[]{player.func_195047_I_(), maidNum.get()}), false));
        }
        return 1;
    }
}

