/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.command.arguments.HandleTypeArgument;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class PowerCommand {
    private static final String POWER_NAME = "power";
    private static final String GET_NAME = "get";
    private static final String HANDLE_NAME = "handle";
    private static final String TARGETS_NAME = "targets";
    private static final String COUNT_NAME = "count";

    public static LiteralArgumentBuilder<CommandSource> get() {
        LiteralArgumentBuilder pack = Commands.func_197057_a((String)POWER_NAME);
        RequiredArgumentBuilder targets = Commands.func_197056_a((String)TARGETS_NAME, (ArgumentType)EntityArgument.func_197094_d());
        RequiredArgumentBuilder count = Commands.func_197056_a((String)COUNT_NAME, (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)5.0f));
        RequiredArgumentBuilder handleType = Commands.func_197056_a((String)HANDLE_NAME, (ArgumentType)HandleTypeArgument.type());
        pack.then(Commands.func_197057_a((String)GET_NAME).then(targets.executes(PowerCommand::getPower)));
        pack.then(handleType.then(targets.then(count.executes(PowerCommand::handlePower))));
        return pack;
    }

    private static int handlePower(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection players = EntityArgument.func_197090_e(context, (String)TARGETS_NAME);
        float count = FloatArgumentType.getFloat(context, (String)COUNT_NAME);
        String type = HandleTypeArgument.getType(context, HANDLE_NAME);
        for (PlayerEntity player : players) {
            switch (type) {
                case "set": {
                    player.getCapability(PowerCapabilityProvider.POWER_CAP, null).ifPresent(power -> power.set(count));
                    break;
                }
                case "add": {
                    player.getCapability(PowerCapabilityProvider.POWER_CAP, null).ifPresent(power -> power.add(count));
                    break;
                }
                case "min": {
                    player.getCapability(PowerCapabilityProvider.POWER_CAP, null).ifPresent(power -> power.min(count));
                    break;
                }
            }
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.touhou_little_maid.power.handle.info", new Object[]{players.size()}), true);
        return 1;
    }

    private static int getPower(CommandContext<CommandSource> context) throws CommandSyntaxException {
        for (PlayerEntity player : EntityArgument.func_197090_e(context, (String)TARGETS_NAME)) {
            player.getCapability(PowerCapabilityProvider.POWER_CAP, null).ifPresent(power -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.touhou_little_maid.power.get.info", new Object[]{player.func_195047_I_(), Float.valueOf(power.get())}), false));
        }
        return 1;
    }
}

