/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.jei.altar;

import com.github.tartaricacid.touhoulittlemaid.compat.jei.altar.AltarRecipeWrapper;
import com.mojang.blaze3d.matrix.MatrixStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class AltarRecipeCategory
implements IRecipeCategory<AltarRecipeWrapper> {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "altar");
    private static final ResourceLocation ALTAR_ICON = new ResourceLocation("touhou_little_maid", "textures/gui/altar_icon.png");
    private static final ResourceLocation POWER_ICON = new ResourceLocation("touhou_little_maid", "textures/entity/power_point.png");
    private final IDrawableStatic bgDraw;
    private final IDrawable slotDraw;
    private final IDrawableStatic altarDraw;
    private final IDrawableStatic powerDraw;

    public AltarRecipeCategory(IGuiHelper guiHelper) {
        this.bgDraw = guiHelper.createBlankDrawable(160, 125);
        this.slotDraw = guiHelper.getSlotDrawable();
        this.altarDraw = guiHelper.drawableBuilder(ALTAR_ICON, 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.powerDraw = guiHelper.drawableBuilder(POWER_ICON, 32, 0, 16, 16).setTextureSize(64, 64).build();
    }

    public void setIngredients(AltarRecipeWrapper recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, recipe.getInputs());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
    }

    public void draw(AltarRecipeWrapper recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        int darkGray = 0x555555;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String result = I18n.func_135052_a((String)"jei.touhou_little_maid.altar_craft.result", (Object[])new Object[]{I18n.func_135052_a((String)recipe.getLangKey(), (Object[])new Object[0])});
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.8f, 0.8f, 0.8f);
        this.powerDraw.draw(matrixStack, 90, 50);
        matrixStack.func_227865_b_();
        font.func_238421_b_(matrixStack, String.format("\u00d7%.2f", Float.valueOf(recipe.getPowerCost())), 65.0f, 55.0f, darkGray);
        font.func_238421_b_(matrixStack, result, (float)(this.bgDraw.getWidth() - font.func_78256_a(result)) / 2.0f, 85.0f, darkGray);
    }

    public void setRecipe(IRecipeLayout recipeLayout, AltarRecipeWrapper recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 40, 35);
        guiItemStacks.init(1, true, 40, 55);
        guiItemStacks.init(2, true, 60, 15);
        guiItemStacks.init(3, true, 80, 15);
        guiItemStacks.init(4, true, 100, 35);
        guiItemStacks.init(5, true, 100, 55);
        guiItemStacks.init(6, false, 140, 5);
        guiItemStacks.setBackground(0, this.slotDraw);
        guiItemStacks.setBackground(1, this.slotDraw);
        guiItemStacks.setBackground(2, this.slotDraw);
        guiItemStacks.setBackground(3, this.slotDraw);
        guiItemStacks.setBackground(4, this.slotDraw);
        guiItemStacks.setBackground(5, this.slotDraw);
        guiItemStacks.setBackground(6, this.slotDraw);
        guiItemStacks.set(ingredients);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends AltarRecipeWrapper> getRecipeClass() {
        return AltarRecipeWrapper.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"jei.touhou_little_maid.altar_craft.title", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.bgDraw;
    }

    public IDrawable getIcon() {
        return this.altarDraw;
    }
}

