/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.jei.altar;

import com.github.tartaricacid.touhoulittlemaid.compat.jei.altar.AltarRecipeWrapper;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;

public final class AltarRecipeMaker {
    private final RecipeManager recipeManager;

    private AltarRecipeMaker() {
        ClientWorld world = Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e);
        this.recipeManager = world.func_199532_z();
    }

    public static AltarRecipeMaker getInstance() {
        return new AltarRecipeMaker();
    }

    public List<AltarRecipeWrapper> getAltarRecipes() {
        List altarRecipesMap = this.recipeManager.func_241447_a_(InitRecipes.ALTAR_CRAFTING);
        ArrayList recipes = Lists.newArrayList();
        for (AltarRecipe recipe : altarRecipesMap) {
            String langKey;
            ResourceLocation recipeId = recipe.func_199560_c();
            ItemStack output = recipe.func_77571_b();
            if (!recipe.isItemCraft()) {
                output = ((Item)InitItems.ENTITY_PLACEHOLDER.get()).func_190903_i();
                ItemEntityPlaceholder.setRecipeId(output, recipe.func_199560_c());
            }
            String namespace = recipeId.func_110624_b().toLowerCase(Locale.US);
            if (recipe.isItemCraft()) {
                langKey = String.format("jei.%s.altar_craft.%s.result", namespace, "item_craft");
            } else {
                Path path = Paths.get(recipeId.func_110623_a().toLowerCase(Locale.US), new String[0]);
                langKey = String.format("jei.%s.altar_craft.%s.result", namespace, path.getFileName());
            }
            recipes.add(new AltarRecipeWrapper((List<Ingredient>)recipe.func_192400_c(), output, recipe.getPowerCost(), langKey));
        }
        return recipes;
    }
}

