/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.slashblade;

import com.github.tartaricacid.touhoulittlemaid.client.model.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.init.SBItems;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlashBladeRender {
    public static void renderSlashBlade(MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int lightIn, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        stack.getCapability(CapabilitySlashBlade.BLADESTATE).ifPresent(bladeState -> {
            ResourceLocation texture = bladeState.getTexture().orElse(BladeModelManager.resourceDefaultTexture);
            WavefrontObject obj = BladeModelManager.getInstance().getModel((ResourceLocation)bladeState.getModel().orElse(null));
            String part = bladeState.isBroken() ? "blade_damaged" : "blade";
            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)part, (ResourceLocation)texture, (MatrixStack)matrixStack, (IRenderTypeBuffer)bufferIn, (int)lightIn);
            BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)(part + "_luminous"), (ResourceLocation)texture, (MatrixStack)matrixStack, (IRenderTypeBuffer)bufferIn, (int)lightIn);
            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)"sheath", (ResourceLocation)texture, (MatrixStack)matrixStack, (IRenderTypeBuffer)bufferIn, (int)lightIn);
            BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)"sheath_luminous", (ResourceLocation)texture, (MatrixStack)matrixStack, (IRenderTypeBuffer)bufferIn, (int)lightIn);
        });
    }

    public static void renderMaidBackSlashBlade(MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int lightIn, ItemStack stack) {
        matrixStack.func_227861_a_(0.9, -0.25, 0.05);
        matrixStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(15.0f));
        matrixStack.func_227862_a_(0.007f, 0.007f, 0.007f);
        SlashBladeRender.renderSlashBlade(matrixStack, bufferIn, lightIn, stack);
    }

    public static void renderGeckoMaidBackSlashBlade(MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int lightIn, ItemStack stack) {
        matrixStack.func_227861_a_(1.25, -0.25, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(15.0f));
        matrixStack.func_227862_a_(0.01f, 0.01f, 0.01f);
        SlashBladeRender.renderSlashBlade(matrixStack, bufferIn, lightIn, stack);
    }

    public static void renderMaidMainhandSlashBlade(EntityMaid maid, BedrockModel<EntityMaid> model, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int lightIn, ItemStack stack, float partialTicks) {
        if (stack.func_77973_b() == SBItems.slashblade) {
            matrixStack.func_227860_a_();
            if (model.hasWaistPositioningModel(HandSide.LEFT)) {
                model.translateToPositioningWaist(HandSide.LEFT, matrixStack);
            } else {
                matrixStack.func_227861_a_(0.25, 0.85, 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-20.0f));
            }
            matrixStack.func_227861_a_(0.0, 0.0, -0.5);
            matrixStack.func_227862_a_(0.007f, 0.007f, 0.007f);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            if (stack.func_190926_b()) {
                return;
            }
            stack.getCapability(CapabilitySlashBlade.BLADESTATE).ifPresent(bladeState -> {
                ResourceLocation texture = bladeState.getTexture().orElse(BladeModelManager.resourceDefaultTexture);
                WavefrontObject obj = BladeModelManager.getInstance().getModel((ResourceLocation)bladeState.getModel().orElse(null));
                String part = bladeState.isBroken() ? "blade_damaged" : "blade";
                BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)"sheath", (ResourceLocation)texture, (MatrixStack)matrixStack, (IRenderTypeBuffer)bufferIn, (int)lightIn);
                BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)"sheath_luminous", (ResourceLocation)texture, (MatrixStack)matrixStack, (IRenderTypeBuffer)bufferIn, (int)lightIn);
                long time = maid.field_70170_p.func_82737_E() - bladeState.getLastActionTime();
                if (time < 5L) {
                    float i = (float)time + partialTicks;
                    matrixStack.func_227861_a_(0.0, 0.0, -71.42857142857143);
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(60.0f + i * 48.0f));
                    matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                }
                BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)part, (ResourceLocation)texture, (MatrixStack)matrixStack, (IRenderTypeBuffer)bufferIn, (int)lightIn);
                BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)(part + "_luminous"), (ResourceLocation)texture, (MatrixStack)matrixStack, (IRenderTypeBuffer)bufferIn, (int)lightIn);
            });
            matrixStack.func_227865_b_();
        }
    }

    public static void renderMaidMainhandSlashBlade(LivingEntity maid, GeoModel model, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int lightIn, ItemStack stack, float partialTicks) {
        if (stack.func_77973_b() == SBItems.slashblade) {
            matrixStack.func_227860_a_();
            if (!model.leftWaistBones.isEmpty()) {
                SlashBladeRender.translateToWaist(HandSide.LEFT, matrixStack, model);
            } else {
                matrixStack.func_227861_a_(-0.25, 1.25, 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(20.0f));
            }
            matrixStack.func_227861_a_(0.0, 0.0, -0.7);
            matrixStack.func_227862_a_(0.01f, 0.01f, 0.01f);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            if (stack.func_190926_b()) {
                return;
            }
            stack.getCapability(CapabilitySlashBlade.BLADESTATE).ifPresent(bladeState -> {
                ResourceLocation texture = bladeState.getTexture().orElse(BladeModelManager.resourceDefaultTexture);
                WavefrontObject obj = BladeModelManager.getInstance().getModel((ResourceLocation)bladeState.getModel().orElse(null));
                String part = bladeState.isBroken() ? "blade_damaged" : "blade";
                BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)"sheath", (ResourceLocation)texture, (MatrixStack)matrixStack, (IRenderTypeBuffer)bufferIn, (int)lightIn);
                BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)"sheath_luminous", (ResourceLocation)texture, (MatrixStack)matrixStack, (IRenderTypeBuffer)bufferIn, (int)lightIn);
                long time = maid.field_70170_p.func_82737_E() - bladeState.getLastActionTime();
                if (time < 5L) {
                    float i = (float)time + partialTicks;
                    matrixStack.func_227861_a_(0.0, 0.0, -71.42857142857143);
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(60.0f + i * 48.0f));
                    matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                }
                BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)part, (ResourceLocation)texture, (MatrixStack)matrixStack, (IRenderTypeBuffer)bufferIn, (int)lightIn);
                BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)(part + "_luminous"), (ResourceLocation)texture, (MatrixStack)matrixStack, (IRenderTypeBuffer)bufferIn, (int)lightIn);
            });
            matrixStack.func_227865_b_();
        }
    }

    public static void renderMaidOffhandSlashBlade(BedrockModel<EntityMaid> model, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int lightIn, ItemStack stack) {
        if (stack.func_77973_b() == SBItems.slashblade) {
            matrixStack.func_227860_a_();
            if (model.hasWaistPositioningModel(HandSide.RIGHT)) {
                model.translateToPositioningWaist(HandSide.RIGHT, matrixStack);
            } else {
                matrixStack.func_227861_a_(-0.25, 0.85, 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-5.0f));
            }
            matrixStack.func_227861_a_(0.0, 0.0, -0.5);
            matrixStack.func_227862_a_(0.007f, 0.007f, 0.007f);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            SlashBladeRender.renderSlashBlade(matrixStack, bufferIn, lightIn, stack);
            matrixStack.func_227865_b_();
        }
    }

    public static void renderMaidOffhandSlashBlade(GeoModel model, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int lightIn, ItemStack stack) {
        if (stack.func_77973_b() == SBItems.slashblade) {
            matrixStack.func_227860_a_();
            if (!model.rightWaistBones.isEmpty()) {
                SlashBladeRender.translateToWaist(HandSide.RIGHT, matrixStack, model);
            } else {
                matrixStack.func_227861_a_(0.25, 1.25, 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(5.0f));
            }
            matrixStack.func_227861_a_(0.0, 0.0, -0.7);
            matrixStack.func_227862_a_(0.01f, 0.01f, 0.01f);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            SlashBladeRender.renderSlashBlade(matrixStack, bufferIn, lightIn, stack);
            matrixStack.func_227865_b_();
        }
    }

    private static void translateToWaist(HandSide arm, MatrixStack poseStack, GeoModel geoModel) {
        if (arm == HandSide.LEFT) {
            int size = geoModel.leftWaistBones.size();
            for (int i = 0; i < size - 1; ++i) {
                RenderUtils.prepMatrixForBone(poseStack, geoModel.leftWaistBones.get(i));
            }
            GeoBone lastBone = geoModel.leftWaistBones.get(size - 1);
            RenderUtils.translateMatrixToBone(poseStack, lastBone);
            RenderUtils.translateToPivotPoint(poseStack, lastBone);
            RenderUtils.rotateMatrixAroundBone(poseStack, lastBone);
            RenderUtils.scaleMatrixForBone(poseStack, lastBone);
        } else {
            int size = geoModel.rightWaistBones.size();
            for (int i = 0; i < size - 1; ++i) {
                RenderUtils.prepMatrixForBone(poseStack, geoModel.rightWaistBones.get(i));
            }
            GeoBone lastBone = geoModel.rightWaistBones.get(size - 1);
            RenderUtils.translateMatrixToBone(poseStack, lastBone);
            RenderUtils.translateToPivotPoint(poseStack, lastBone);
            RenderUtils.rotateMatrixAroundBone(poseStack, lastBone);
            RenderUtils.scaleMatrixForBone(poseStack, lastBone);
        }
    }
}

