/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.crafting;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.inventory.AltarRecipeInventory;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.RecipeMatcher;
import org.apache.commons.lang3.StringUtils;

public class AltarRecipe
implements IRecipe<AltarRecipeInventory> {
    private final ResourceLocation id;
    private final EntityType<?> entityType;
    @Nullable
    private final CompoundNBT extraData;
    private final float powerCost;
    private final NonNullList<Ingredient> inputs;
    private final boolean isItemCraft;
    private final ItemStack resultItem;
    private final Ingredient copyInput;
    @Nullable
    private final String copyTag;

    public AltarRecipe(ResourceLocation id, EntityType<?> entityType, @Nullable CompoundNBT extraData, float powerCost, Ingredient copyInput, @Nullable String copyTag, Ingredient ... inputs) {
        Preconditions.checkArgument((0 < inputs.length && inputs.length <= 6 ? 1 : 0) != 0, (Object)"Ingredients count is illegal!");
        this.id = id;
        this.entityType = entityType;
        this.isItemCraft = entityType == EntityType.field_200765_E;
        this.resultItem = this.isItemCraft && extraData != null ? ItemStack.func_199557_a((CompoundNBT)extraData.func_74775_l("Item")) : ItemStack.field_190927_a;
        this.copyInput = copyInput;
        this.copyTag = copyTag;
        this.extraData = extraData;
        this.powerCost = powerCost;
        this.inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])this.fillInputs(inputs));
    }

    public AltarRecipe(ResourceLocation id, EntityType<?> entityType, @Nullable CompoundNBT extraData, float powerCost, Ingredient ... inputs) {
        this(id, entityType, extraData, powerCost, Ingredient.field_193370_a, (String)null, inputs);
    }

    public boolean matches(AltarRecipeInventory inv, World worldIn) {
        return RecipeMatcher.findMatches(inv.getItems(), this.inputs) != null;
    }

    public ItemStack assemble(AltarRecipeInventory inv) {
        return this.func_77571_b().func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    public ItemStack func_77571_b() {
        return this.resultItem;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)InitRecipes.ALTAR_RECIPE_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return InitRecipes.ALTAR_CRAFTING;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack func_222128_h() {
        return ((Item)InitItems.HAKUREI_GOHEI.get()).func_190903_i();
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    @Nullable
    public CompoundNBT getExtraData() {
        return this.extraData;
    }

    public float getPowerCost() {
        return this.powerCost;
    }

    public Ingredient getCopyInput() {
        return this.copyInput;
    }

    @Nullable
    public String getCopyTag() {
        return this.copyTag;
    }

    public void spawnOutputEntity(ServerWorld world, BlockPos pos, @Nullable AltarRecipeInventory inventory) {
        if (this.extraData != null) {
            CompoundNBT nbt = this.extraData.func_74737_b();
            nbt.func_74778_a("id", Objects.requireNonNull(this.entityType.getRegistryName()).toString());
            Entity resultEntity = EntityType.func_220335_a((CompoundNBT)nbt, (World)world, e -> {
                e.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), e.field_70177_z, e.field_70125_A);
                this.finalizeSpawn(world, pos, (Entity)e);
                return e;
            });
            if (resultEntity != null) {
                this.finalizeSpawn(world, pos, resultEntity);
                this.copyIngredientTag(inventory, resultEntity);
                world.func_242106_g(resultEntity);
            }
            return;
        }
        this.entityType.func_220342_a(world, null, null, null, pos, SpawnReason.SPAWN_EGG, true, true);
    }

    private void copyIngredientTag(@Nullable AltarRecipeInventory inventory, Entity resultEntity) {
        CompoundNBT data;
        ItemStack matchStack;
        if (inventory != null && this.copyInput != Ingredient.field_193370_a && !(matchStack = inventory.getMatchIngredient(this.copyInput)).func_190926_b() && (data = StringUtils.isEmpty((CharSequence)this.copyTag) ? matchStack.func_77978_p() : matchStack.func_179543_a(this.copyTag)) != null && !data.isEmpty()) {
            if (resultEntity instanceof LivingEntity) {
                ((LivingEntity)resultEntity).func_70037_a(data);
            }
            if (resultEntity instanceof ItemEntity) {
                ((ItemEntity)resultEntity).func_70037_a(data);
            }
        }
    }

    public boolean isItemCraft() {
        return this.isItemCraft;
    }

    private void finalizeSpawn(ServerWorld world, BlockPos pos, @Nullable Entity entity) {
        if (entity instanceof MobEntity) {
            ((MobEntity)entity).func_213386_a((IServerWorld)world, world.func_175649_E(pos), SpawnReason.SPAWN_EGG, null, null);
        }
    }

    private Ingredient[] fillInputs(Ingredient[] inputs) {
        Ingredient[] newInputs = new Ingredient[6];
        for (int i = 0; i < 6; ++i) {
            newInputs[i] = i < inputs.length ? inputs[i] : Ingredient.field_193370_a;
        }
        return newInputs;
    }
}

