/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.crafting;

import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCraftingHelper;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public class AltarRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<AltarRecipe> {
    public AltarRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        EntityCraftingHelper.Output output = EntityCraftingHelper.getEntityData(JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
        float powerCost = JSONUtils.func_151217_k((JsonObject)json, (String)"power");
        JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
        ArrayList inputs = Lists.newArrayList();
        for (JsonElement e : ingredients) {
            inputs.add(Ingredient.func_199802_a((JsonElement)e));
        }
        return new AltarRecipe(recipeId, output.getType(), output.getData(), powerCost, output.getCopyInput(), output.getCopyTag(), inputs.toArray(new Ingredient[0]));
    }

    @Nullable
    public AltarRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        Optional typeOptional = EntityType.func_220327_a((String)buffer.func_218666_n());
        if (typeOptional.isPresent()) {
            EntityType entityType = (EntityType)typeOptional.get();
            CompoundNBT extraData = buffer.func_150793_b();
            float powerCost = buffer.readFloat();
            Ingredient copyInput = Ingredient.func_199566_b((PacketBuffer)buffer);
            String copyTag = buffer.func_218666_n();
            Ingredient[] inputs = new Ingredient[buffer.func_150792_a()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.func_199566_b((PacketBuffer)buffer);
            }
            return new AltarRecipe(recipeId, entityType, extraData, powerCost, copyInput, copyTag, inputs);
        }
        throw new JsonParseException("Entity Type Tag Not Found");
    }

    public void toNetwork(PacketBuffer buffer, AltarRecipe recipe) {
        ResourceLocation name = recipe.getEntityType().getRegistryName();
        if (name == null) {
            throw new JsonParseException("Entity Type Tag Not Found");
        }
        buffer.func_180714_a(name.toString());
        buffer.func_150786_a(recipe.getExtraData());
        buffer.writeFloat(recipe.getPowerCost());
        recipe.getCopyInput().func_199564_a(buffer);
        if (StringUtils.isEmpty((CharSequence)recipe.getCopyTag())) {
            buffer.func_180714_a("");
        } else {
            buffer.func_180714_a(recipe.getCopyTag());
        }
        buffer.func_150787_b(recipe.func_192400_c().size());
        for (Ingredient input : recipe.func_192400_c()) {
            input.func_199564_a(buffer);
        }
    }
}

