/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.data;

import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.util.NBTToJson;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.RegistryObject;
import org.apache.commons.lang3.StringUtils;

public class AltarRecipeProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final DataGenerator generator;
    private final List<AltarRecipe> recipes = Lists.newArrayList();

    public AltarRecipeProvider(DataGenerator generator) {
        this.generator = generator;
    }

    protected void registerRecipes() {
        Ingredient gunpowder = Ingredient.func_199805_a((ITag)Tags.Items.GUNPOWDER);
        Ingredient blazePowder = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151065_br});
        Ingredient paper = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151121_aF});
        Ingredient stick = Ingredient.func_199805_a((ITag)Tags.Items.RODS_WOODEN);
        Ingredient obsidian = Ingredient.func_199805_a((ITag)Tags.Items.OBSIDIAN);
        Ingredient redstone = Ingredient.func_199805_a((ITag)Tags.Items.DUSTS_REDSTONE);
        Ingredient dyeCyan = Ingredient.func_199805_a((ITag)Tags.Items.DYES_CYAN);
        Ingredient dyeOrange = Ingredient.func_199805_a((ITag)Tags.Items.DYES_ORANGE);
        Ingredient dyeRed = Ingredient.func_199805_a((ITag)Tags.Items.DYES_RED);
        Ingredient dyeBlue = Ingredient.func_199805_a((ITag)Tags.Items.DYES_BLUE);
        Ingredient dyeYellow = Ingredient.func_199805_a((ITag)Tags.Items.DYES_YELLOW);
        Ingredient dyeLime = Ingredient.func_199805_a((ITag)Tags.Items.DYES_LIME);
        Ingredient shield = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185159_cQ});
        Ingredient sugar = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151102_aT});
        Ingredient feather = Ingredient.func_199805_a((ITag)Tags.Items.FEATHERS);
        Ingredient fishes = Ingredient.func_199805_a((ITag)ItemTags.field_206964_G);
        Ingredient plankWood = Ingredient.func_199805_a((ITag)ItemTags.field_199905_b);
        Ingredient ingotGold = Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_GOLD);
        Ingredient ingotIron = Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_IRON);
        Ingredient clayBall = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151119_aD});
        Ingredient redWool = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196570_aZ});
        Ingredient pinkWool = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196562_aR});
        Ingredient grayWool = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196563_aS});
        Ingredient anyWool = Ingredient.func_199805_a((ITag)ItemTags.field_199904_a);
        Ingredient enderPearl = Ingredient.func_199805_a((ITag)Tags.Items.ENDER_PEARLS);
        Ingredient gemDiamond = Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND);
        Ingredient gemEmerald = Ingredient.func_199805_a((ITag)Tags.Items.GEMS_EMERALD);
        Ingredient gemLapis = Ingredient.func_199805_a((ITag)Tags.Items.GEMS_LAPIS);
        Ingredient coal = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151044_h});
        Ingredient netherWart = Ingredient.func_199805_a((ITag)Tags.Items.CROPS_NETHER_WART);
        Ingredient quartzBlock = Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_QUARTZ);
        Ingredient film = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)InitItems.FILM.get()});
        Ingredient noteBlock = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221664_at});
        Ingredient chestsWooden = Ingredient.func_199805_a((ITag)Tags.Items.CHESTS_WOODEN);
        Ingredient hopper = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221862_eo});
        CompoundNBT extraData = new CompoundNBT();
        ListNBT passengerList = new ListNBT();
        CompoundNBT passenger = new CompoundNBT();
        passenger.func_74778_a("id", Objects.requireNonNull(((EntityType)InitEntities.MAID.get()).getRegistryName()).toString());
        passengerList.add((Object)passenger);
        extraData.func_218657_a("Passengers", (INBT)passengerList);
        this.addEntityRecipes((EntityType)InitEntities.BOX.get(), extraData, 0.5f, gemDiamond, gemLapis, ingotGold, redstone, ingotIron, coal);
        this.addEntityRecipes("reborn_maid", (EntityType)InitEntities.MAID.get(), new CompoundNBT(), 0.5f, film, "MaidInfo", film, gemLapis, ingotGold, redstone, ingotIron, coal);
        this.addEntityRecipes(EntityType.field_200728_aG, 0.2f, gunpowder, gunpowder, gunpowder, blazePowder, blazePowder, blazePowder);
        this.addItemRecipes(InitItems.HAKUREI_GOHEI, 0.15f, stick, stick, stick, paper, paper, paper);
        this.addItemRecipes(InitItems.ULTRAMARINE_ORB_ELIXIR, 0.3f, gemEmerald, enderPearl, dyeCyan, dyeCyan, dyeCyan, dyeCyan);
        this.addItemRecipes(InitItems.EXPLOSION_PROTECT_BAUBLE, netherWart, dyeOrange, obsidian, obsidian, obsidian, obsidian);
        this.addItemRecipes(InitItems.FIRE_PROTECT_BAUBLE, netherWart, dyeRed, blazePowder, blazePowder, blazePowder, blazePowder);
        this.addItemRecipes(InitItems.PROJECTILE_PROTECT_BAUBLE, netherWart, dyeBlue, shield, shield, shield, shield);
        this.addItemRecipes(InitItems.MAGIC_PROTECT_BAUBLE, netherWart, dyeCyan, sugar, sugar, sugar, sugar);
        this.addItemRecipes(InitItems.FALL_PROTECT_BAUBLE, netherWart, dyeYellow, feather, feather, feather, feather);
        this.addItemRecipes(InitItems.DROWN_PROTECT_BAUBLE, netherWart, dyeLime, fishes, fishes, fishes, fishes);
        this.addItemRecipes(InitItems.MAID_BACKPACK_SMALL, 0.1f, redWool, redWool, redWool, redWool, ingotIron, redWool);
        this.addItemRecipes(InitItems.MAID_BACKPACK_MIDDLE, pinkWool, pinkWool, pinkWool, pinkWool, ingotGold, pinkWool);
        this.addItemRecipes(InitItems.MAID_BACKPACK_BIG, 0.3f, grayWool, grayWool, grayWool, grayWool, gemDiamond, grayWool);
        this.addItemRecipes(InitItems.EXTINGUISHER, clayBall, clayBall, clayBall, clayBall, ingotIron, dyeRed);
        this.addItemRecipes(InitItems.MAID_BED, pinkWool, pinkWool, pinkWool, plankWood, plankWood, plankWood);
        this.addItemRecipes(InitItems.NIMBLE_FABRIC, enderPearl, enderPearl, enderPearl, anyWool, anyWool, anyWool);
        this.addItemRecipes(InitItems.MUTE_BAUBLE, anyWool, anyWool, anyWool, clayBall, clayBall, clayBall);
        this.addItemRecipes(InitItems.ITEM_MAGNET_BAUBLE, redstone, redstone, redstone, ingotIron, ingotIron, ingotIron);
        this.addItemRecipes(InitItems.CAMERA, quartzBlock, quartzBlock, quartzBlock, quartzBlock, obsidian, obsidian);
        this.addItemRecipes(InitItems.CHISEL, stick, stick, ingotIron, ingotIron, dyeYellow, dyeRed);
        this.addItemRecipes(InitItems.TRUMPET, ingotGold, ingotGold, ingotIron, ingotIron, ingotIron, noteBlock);
        this.addItemRecipes(InitItems.WIRELESS_IO, enderPearl, chestsWooden, hopper);
        this.addItemRecipes(InitItems.MAID_BEACON, plankWood, dyeRed, plankWood, obsidian, gemDiamond, obsidian);
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        this.recipes.clear();
        this.registerRecipes();
        for (AltarRecipe recipe : this.recipes) {
            JsonObject jsonObject = this.recipeToJson(recipe);
            Path savePath = path.resolve("data/" + recipe.func_199560_c().func_110624_b() + "/recipes/altar/" + recipe.func_199560_c().func_110623_a() + ".json");
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)jsonObject, (Path)savePath);
        }
    }

    public void addRecipes(AltarRecipe recipe) {
        this.recipes.add(recipe);
    }

    public void addEntityRecipes(String name, EntityType<?> entityType, @Nullable CompoundNBT extraData, float powerCost, Ingredient copyInput, @Nullable String copyTag, Ingredient ... inputs) {
        this.addRecipes(new AltarRecipe(new ResourceLocation("touhou_little_maid", name), entityType, extraData, powerCost, copyInput, copyTag, inputs));
    }

    public void addEntityRecipes(String name, EntityType<?> entityType, @Nullable CompoundNBT extraData, float powerCost, Ingredient ... inputs) {
        this.addRecipes(new AltarRecipe(new ResourceLocation("touhou_little_maid", name), entityType, extraData, powerCost, inputs));
    }

    public void addEntityRecipes(EntityType<?> entityType, @Nullable CompoundNBT extraData, float powerCost, Ingredient ... inputs) {
        ResourceLocation registryName = entityType.getRegistryName();
        if (registryName != null) {
            this.addEntityRecipes("spawn_" + registryName.func_110623_a(), entityType, extraData, powerCost, inputs);
        }
    }

    public void addEntityRecipes(EntityType<?> entityType, float powerCost, Ingredient ... inputs) {
        this.addEntityRecipes(entityType, null, powerCost, inputs);
    }

    public void addItemRecipes(String name, ItemStack output, float powerCost, Ingredient ... inputs) {
        CompoundNBT extraData = new CompoundNBT();
        extraData.func_218657_a("Item", (INBT)output.serializeNBT());
        this.addEntityRecipes(name, EntityType.field_200765_E, extraData, powerCost, inputs);
    }

    public void addItemRecipes(String name, Item output, float powerCost, Ingredient ... inputs) {
        this.addItemRecipes(name, output.func_190903_i(), powerCost, inputs);
    }

    public void addItemRecipes(String name, RegistryObject<Item> output, float powerCost, Ingredient ... inputs) {
        this.addItemRecipes(name, (Item)output.get(), powerCost, inputs);
    }

    public void addItemRecipes(RegistryObject<Item> output, float powerCost, Ingredient ... inputs) {
        ResourceLocation registryName = ((Item)output.get()).getRegistryName();
        if (registryName != null) {
            this.addItemRecipes("craft_" + registryName.func_110623_a(), output, powerCost, inputs);
        }
    }

    public void addItemRecipes(RegistryObject<Item> output, Ingredient ... inputs) {
        this.addItemRecipes(output, 0.2f, inputs);
    }

    private JsonObject recipeToJson(AltarRecipe recipe) {
        JsonObject json = new JsonObject();
        json.addProperty("type", InitRecipes.ALTAR_CRAFTING.toString());
        JsonObject output = new JsonObject();
        ResourceLocation name = recipe.getEntityType().getRegistryName();
        if (name == null) {
            throw new JsonParseException("Entity Registry Name Not Found");
        }
        output.addProperty("type", name.toString());
        NBTToJson.getJson((INBT)recipe.getExtraData()).ifPresent(e -> output.add("nbt", e));
        if (recipe.getCopyInput() != Ingredient.field_193370_a) {
            JsonObject copy = new JsonObject();
            copy.add("ingredient", recipe.getCopyInput().func_200304_c());
            if (StringUtils.isNotBlank((CharSequence)recipe.getCopyTag())) {
                copy.addProperty("tag", recipe.getCopyTag());
            }
            output.add("copy", (JsonElement)copy);
        }
        json.add("output", (JsonElement)output);
        json.addProperty("power", (Number)Float.valueOf(recipe.getPowerCost()));
        JsonArray ingredients = new JsonArray();
        for (Ingredient ingredient : recipe.func_192400_c()) {
            ingredients.add(ingredient.func_200304_c());
        }
        json.add("ingredients", (JsonElement)ingredients);
        return json;
    }

    public String func_200397_b() {
        return "Maid Altar Recipe";
    }
}

