/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAwaitTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidBedTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidBegTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidClearHurtTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidClearSleepTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFollowOwnerTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidInteractWithDoor;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidJoyTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidPanicTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidPickupEntitiesTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRunAwayTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidUpdateActivityFromSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.SwimTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.UpdateActivityTask;
import net.minecraft.entity.ai.brain.task.WalkRandomlyTask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;

public final class MaidBrain {
    public static ImmutableList<MemoryModuleType<?>> getMemoryTypes() {
        return ImmutableList.of((Object)MemoryModuleType.field_220954_o, (Object)MemoryModuleType.field_225462_q, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleType.field_220959_t, (Object)MemoryModuleType.field_220957_r, (Object)MemoryModuleType.field_220958_s, (Object)MemoryModuleType.field_223021_x, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleType.field_234104_p_, (Object)InitEntities.TARGET_POS.get());
    }

    public static ImmutableList<SensorType<? extends Sensor<? super EntityMaid>>> getSensorTypes() {
        return ImmutableList.of((Object)InitEntities.MAID_NEAREST_LIVING_ENTITY_SENSOR.get(), (Object)SensorType.field_221002_f, (Object)InitEntities.MAID_HOSTILES_SENSOR.get(), (Object)InitEntities.MAID_PICKUP_ENTITIES_SENSOR.get());
    }

    public static void registerBrainGoals(Brain<EntityMaid> brain, EntityMaid maid) {
        MaidBrain.registerSchedule(brain, maid);
        MaidBrain.registerCoreGoals(brain);
        MaidBrain.registerPanicGoals(brain);
        MaidBrain.registerAwaitGoals(brain);
        MaidBrain.registerIdleGoals(brain);
        MaidBrain.registerWorkGoals(brain, maid);
        MaidBrain.registerRestGoals(brain);
        brain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_218202_a(Activity.field_221366_b);
        brain.func_218211_a(maid.field_70170_p.func_72820_D(), maid.field_70170_p.func_82737_E());
    }

    private static void registerSchedule(Brain<EntityMaid> brain, EntityMaid maid) {
        switch (maid.getSchedule()) {
            case ALL: {
                brain.func_218203_a((Schedule)InitEntities.MAID_ALL_DAY_SCHEDULES.get());
                break;
            }
            case NIGHT: {
                brain.func_218203_a((Schedule)InitEntities.MAID_NIGHT_SHIFT_SCHEDULES.get());
                break;
            }
            default: {
                brain.func_218203_a((Schedule)InitEntities.MAID_DAY_SHIFT_SCHEDULES.get());
            }
        }
    }

    private static void registerCoreGoals(Brain<EntityMaid> brain) {
        Pair swim = Pair.of((Object)0, (Object)new SwimTask(0.8f));
        Pair look = Pair.of((Object)0, (Object)new LookTask(45, 90));
        Pair maidPanic = Pair.of((Object)1, (Object)((Object)new MaidPanicTask()));
        Pair maidAwait = Pair.of((Object)1, (Object)((Object)new MaidAwaitTask()));
        Pair interactWithDoor = Pair.of((Object)2, (Object)((Object)new MaidInteractWithDoor()));
        Pair walkToTarget = Pair.of((Object)2, (Object)new WalkToTargetTask());
        Pair followOwner = Pair.of((Object)3, (Object)((Object)new MaidFollowOwnerTask(0.5f, 2)));
        Pair pickupItem = Pair.of((Object)10, (Object)((Object)new MaidPickupEntitiesTask(EntityMaid::isPickup, 0.6f)));
        Pair clearSleep = Pair.of((Object)99, (Object)((Object)new MaidClearSleepTask()));
        brain.func_218208_a(Activity.field_221365_a, ImmutableList.of((Object)swim, (Object)look, (Object)maidPanic, (Object)maidAwait, (Object)interactWithDoor, (Object)walkToTarget, (Object)followOwner, (Object)pickupItem, (Object)clearSleep));
    }

    private static void registerIdleGoals(Brain<EntityMaid> brain) {
        Pair lookToPlayer = Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 5.0f), (Object)1);
        Pair lookToMaid = Pair.of((Object)new LookAtEntityTask(EntityMaid.TYPE, 5.0f), (Object)1);
        Pair lookToWolf = Pair.of((Object)new LookAtEntityTask(EntityType.field_200724_aC, 5.0f), (Object)1);
        Pair lookToCat = Pair.of((Object)new LookAtEntityTask(EntityType.field_220360_g, 5.0f), (Object)1);
        Pair lookToParrot = Pair.of((Object)new LookAtEntityTask(EntityType.field_200783_W, 5.0f), (Object)1);
        Pair walkRandomly = Pair.of((Object)new WalkRandomlyTask(0.3f, 5, 3), (Object)1);
        Pair noLook = Pair.of((Object)new DummyTask(40, 80), (Object)2);
        FirstShuffledTask firstShuffledTask = new FirstShuffledTask((List)ImmutableList.of((Object)lookToPlayer, (Object)lookToMaid, (Object)lookToWolf, (Object)lookToCat, (Object)lookToParrot, (Object)walkRandomly, (Object)noLook));
        SupplementedTask supplementedTask = new SupplementedTask(MaidBrain::lookAroundCondition, (Task)firstShuffledTask);
        Pair beg = Pair.of((Object)5, (Object)((Object)new MaidBegTask()));
        Pair joy = Pair.of((Object)6, (Object)((Object)new MaidJoyTask(0.6f, 2)));
        Pair supplemented = Pair.of((Object)10, (Object)supplementedTask);
        Pair updateActivity = Pair.of((Object)99, (Object)new UpdateActivityTask());
        brain.func_218208_a(Activity.field_221366_b, ImmutableList.of((Object)beg, (Object)joy, (Object)supplemented, (Object)updateActivity));
    }

    private static void registerWorkGoals(Brain<EntityMaid> brain, EntityMaid maid) {
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        ArrayList pairMaidList = maid.getTask().createBrainTasks(maid);
        if (pairMaidList.isEmpty()) {
            pairMaidList = Lists.newArrayList((Object[])new Pair[]{updateActivity});
        } else {
            pairMaidList.add((Pair<Integer, Task<? super EntityMaid>>)updateActivity);
        }
        pairMaidList.add(Pair.of((Object)6, (Object)((Object)new MaidBegTask())));
        brain.func_218208_a(Activity.field_221367_c, ImmutableList.copyOf((Collection)pairMaidList));
    }

    private static void registerRestGoals(Brain<EntityMaid> brain) {
        Pair bed = Pair.of((Object)5, (Object)((Object)new MaidBedTask(0.6f, 2)));
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        brain.func_218208_a(Activity.field_221369_e, ImmutableList.of((Object)bed, (Object)updateActivity));
    }

    private static void registerPanicGoals(Brain<EntityMaid> brain) {
        Pair clearHurt = Pair.of((Object)5, (Object)((Object)new MaidClearHurtTask()));
        Pair runAway = Pair.of((Object)5, MaidRunAwayTask.entity((MemoryModuleType<? extends Entity>)MemoryModuleType.field_220959_t, 0.7f, false));
        Pair runAwayHurt = Pair.of((Object)5, MaidRunAwayTask.entity((MemoryModuleType<? extends Entity>)MemoryModuleType.field_220958_s, 0.7f, false));
        brain.func_218208_a(Activity.field_221371_g, ImmutableList.of((Object)clearHurt, (Object)runAway, (Object)runAwayHurt));
    }

    private static void registerAwaitGoals(Brain<EntityMaid> brain) {
        Pair lookToPlayer = Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 5.0f), (Object)1);
        Pair lookToMaid = Pair.of((Object)new LookAtEntityTask(EntityMaid.TYPE, 5.0f), (Object)1);
        Pair lookToWolf = Pair.of((Object)new LookAtEntityTask(EntityType.field_200724_aC, 5.0f), (Object)1);
        Pair lookToCat = Pair.of((Object)new LookAtEntityTask(EntityType.field_220360_g, 5.0f), (Object)1);
        Pair lookToParrot = Pair.of((Object)new LookAtEntityTask(EntityType.field_200783_W, 5.0f), (Object)1);
        Pair noLook = Pair.of((Object)new DummyTask(30, 60), (Object)2);
        FirstShuffledTask firstShuffledTask = new FirstShuffledTask((List)ImmutableList.of((Object)lookToPlayer, (Object)lookToMaid, (Object)lookToWolf, (Object)lookToCat, (Object)lookToParrot, (Object)noLook));
        Pair shuffled = Pair.of((Object)5, (Object)new SupplementedTask(MaidBrain::lookAroundCondition, (Task)firstShuffledTask));
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        brain.func_218208_a(Activity.field_234625_o_, ImmutableList.of((Object)shuffled, (Object)updateActivity));
    }

    public static boolean lookAroundCondition(EntityMaid maid) {
        return !maid.isBegging() && !(maid.func_184187_bx() instanceof EntitySit);
    }
}

