/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.sensor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;

public class MaidHostilesSensor
extends Sensor<LivingEntity> {
    private static final ImmutableMap<EntityType<?>, Float> ACCEPTABLE_DISTANCE_FROM_HOSTILES = ImmutableMap.builder().put((Object)EntityType.field_200797_k, (Object)Float.valueOf(8.0f)).build();

    public Set<MemoryModuleType<?>> func_220974_a() {
        return ImmutableSet.of((Object)MemoryModuleType.field_220959_t);
    }

    protected void func_212872_a_(ServerWorld worldIn, LivingEntity entityIn) {
        entityIn.func_213375_cj().func_218226_a(MemoryModuleType.field_220959_t, this.getNearestHostile(entityIn));
    }

    private Optional<LivingEntity> getNearestHostile(LivingEntity livingEntity) {
        return this.getVisibleEntities(livingEntity).flatMap(entities -> entities.stream().filter(this::isHostile).filter(enemy -> this.isClose(livingEntity, (LivingEntity)enemy)).min((enemy1, enemy2) -> this.compareMobDistance(livingEntity, (LivingEntity)enemy1, (LivingEntity)enemy2)));
    }

    private Optional<List<LivingEntity>> getVisibleEntities(LivingEntity livingEntity) {
        return livingEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_220946_g);
    }

    private int compareMobDistance(LivingEntity livingEntity, LivingEntity target1, LivingEntity target2) {
        return MathHelper.func_76128_c((double)(target1.func_70068_e((Entity)livingEntity) - target2.func_70068_e((Entity)livingEntity)));
    }

    private boolean isClose(LivingEntity livingEntity, LivingEntity target) {
        float distance = ((Float)ACCEPTABLE_DISTANCE_FROM_HOSTILES.get((Object)target.func_200600_R())).floatValue();
        return target.func_233562_a_((Entity)livingEntity, (double)distance);
    }

    private boolean isHostile(LivingEntity livingEntity) {
        return ACCEPTABLE_DISTANCE_FROM_HOSTILES.containsKey((Object)livingEntity.func_200600_R());
    }
}

