/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;

public class MaidAttackStrafingTask
extends Task<EntityMaid> {
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public MaidAttackStrafingTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleStatus.VALUE_PRESENT), 1200);
    }

    protected boolean checkExtraStartConditions(ServerWorld worldIn, EntityMaid owner) {
        return owner.func_184614_ca().func_77973_b() instanceof ShootableItem && owner.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_).filter(Entity::func_70089_S).filter(e -> owner.func_213389_a(e.func_233580_cy_())).isPresent();
    }

    protected void tick(ServerWorld worldIn, EntityMaid owner, long gameTime) {
        ItemStack stack = owner.func_184614_ca();
        if (!(stack.func_77973_b() instanceof ShootableItem)) {
            return;
        }
        owner.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_).ifPresent(target -> {
            int maxAttackDistance = ((ShootableItem)stack.func_77973_b()).func_230305_d_();
            double distance = owner.func_70032_d((Entity)target);
            this.strafingTime = distance < (double)maxAttackDistance ? ++this.strafingTime : -1;
            if (this.strafingTime >= 20) {
                if ((double)owner.func_70681_au().nextFloat() < 0.3) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)owner.func_70681_au().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distance > (double)maxAttackDistance * 0.5) {
                    this.strafingBackwards = false;
                } else if (distance < (double)maxAttackDistance * 0.2) {
                    this.strafingBackwards = true;
                }
                owner.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                owner.field_70177_z = MathHelper.func_219800_b((float)owner.field_70177_z, (float)owner.field_70759_as, (float)0.0f);
                BrainUtil.func_220625_c((LivingEntity)owner, (LivingEntity)target);
            } else {
                BrainUtil.func_220625_c((LivingEntity)owner, (LivingEntity)target);
            }
        });
    }

    protected void start(ServerWorld worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    protected void stop(ServerWorld worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(false);
        entityIn.func_70605_aq().func_188488_a(0.0f, 0.0f);
    }

    protected boolean canStillUse(ServerWorld worldIn, EntityMaid entityIn, long gameTimeIn) {
        return this.checkExtraStartConditions(worldIn, entityIn);
    }
}

