/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.block.BlockMaidBed;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitPoi;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockPosWrapper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.server.ServerWorld;

public class MaidBedTask
extends MaidCheckRateTask {
    private final int closeEnoughDist;
    private final float speed;

    public MaidBedTask(float movementSpeed, int closeEnoughDist) {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)InitEntities.TARGET_POS.get(), (Object)MemoryModuleStatus.VALUE_ABSENT));
        this.closeEnoughDist = closeEnoughDist;
        this.speed = movementSpeed;
        this.setMaxCheckRate(10);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerWorld worldIn, EntityMaid maid) {
        if (super.checkExtraStartConditions(worldIn, maid) && maid.canBrainMoving()) {
            BlockPos bedPos = this.findBed(worldIn, maid);
            if (bedPos != null && maid.func_213389_a(bedPos)) {
                if (bedPos.func_177951_i((Vector3i)maid.func_233580_cy_()) < Math.pow(this.closeEnoughDist, 2.0)) {
                    maid.func_213375_cj().func_218205_a((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new BlockPosWrapper(bedPos));
                    return true;
                }
                BrainUtil.func_233866_a_((LivingEntity)maid, (BlockPos)bedPos, (float)this.speed, (int)1);
                this.setNextCheckTickCount(5);
            } else {
                maid.func_213375_cj().func_218189_b((MemoryModuleType)InitEntities.TARGET_POS.get());
            }
        }
        return false;
    }

    protected void start(ServerWorld worldIn, EntityMaid maid, long gameTimeIn) {
        maid.func_213375_cj().func_218207_c((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(targetPos -> {
            BlockPos pos = targetPos.func_220608_a();
            BlockState blockState = worldIn.func_180495_p(pos);
            if (blockState.func_203425_a((Block)InitBlocks.MAID_BED.get()) && blockState.func_177229_b(BlockMaidBed.PART) == BedPart.HEAD && !((Boolean)blockState.func_177229_b((Property)BedBlock.field_176471_b)).booleanValue()) {
                maid.func_213342_e(pos);
                maid.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.8, (double)pos.func_177952_p() + 0.5);
            }
        });
        maid.func_213375_cj().func_218189_b((MemoryModuleType)InitEntities.TARGET_POS.get());
        maid.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        maid.func_213375_cj().func_218189_b(MemoryModuleType.field_220951_l);
    }

    @Nullable
    private BlockPos findBed(ServerWorld world, EntityMaid maid) {
        BlockPos blockPos = maid.getBrainSearchPos();
        PointOfInterestManager poiManager = world.func_217443_B();
        int range = (int)maid.func_213391_dJ();
        return poiManager.func_219146_b(type -> type.equals(InitPoi.MAID_BED.get()), blockPos, range, PointOfInterestManager.Status.ANY).map(PointOfInterest::func_218261_f).min(Comparator.comparingDouble(pos -> pos.func_177951_i((Vector3i)maid.func_233580_cy_()))).orElse(null);
    }
}

