/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockPosWrapper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidCollectHoneyTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 100;
    private final float speed;
    private final int closeEnoughDist;

    public MaidCollectHoneyTask(float speed, int closeEnoughDist) {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)InitEntities.TARGET_POS.get(), (Object)MemoryModuleStatus.VALUE_ABSENT));
        this.speed = speed;
        this.closeEnoughDist = closeEnoughDist;
        this.setMaxCheckRate(100);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerWorld worldIn, EntityMaid maid) {
        if (super.checkExtraStartConditions(worldIn, maid) && maid.canBrainMoving()) {
            BlockPos beehivePos = this.findBeehive(worldIn, maid);
            if (beehivePos != null && maid.func_213389_a(beehivePos)) {
                if (beehivePos.func_177951_i((Vector3i)maid.func_233580_cy_()) < Math.pow(this.closeEnoughDist, 2.0)) {
                    maid.func_213375_cj().func_218205_a((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new BlockPosWrapper(beehivePos));
                    return true;
                }
                BrainUtil.func_233866_a_((LivingEntity)maid, (BlockPos)beehivePos, (float)this.speed, (int)1);
                this.setNextCheckTickCount(5);
            } else {
                maid.func_213375_cj().func_218189_b((MemoryModuleType)InitEntities.TARGET_POS.get());
            }
        }
        return false;
    }

    protected void start(ServerWorld level, EntityMaid maid, long gameTime) {
        maid.func_213375_cj().func_218207_c((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(target -> {
            BlockPos hivePos = target.func_220608_a();
            BlockState hiveBlockState = level.func_180495_p(hivePos);
            if ((Integer)hiveBlockState.func_177229_b((Property)BeehiveBlock.field_226873_c_) < 5) {
                return;
            }
            CombinedInvWrapper maidAvailableInv = maid.getAvailableInv(true);
            if (!this.collectHoneyComb(level, maid, maidAvailableInv, hiveBlockState, hivePos)) {
                this.collectHoneyBottle(level, maid, maidAvailableInv, hiveBlockState, hivePos);
            }
        });
        maid.func_213375_cj().func_218189_b((MemoryModuleType)InitEntities.TARGET_POS.get());
        maid.func_213375_cj().func_218189_b(MemoryModuleType.field_220951_l);
        maid.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
    }

    private void collectHoneyBottle(ServerWorld level, EntityMaid maid, CombinedInvWrapper maidAvailableInv, BlockState hiveBlockState, BlockPos hivePos) {
        ItemStack bottle = ItemsUtil.getStack((IItemHandler)maidAvailableInv, stack -> stack.func_77973_b() == Items.field_151069_bo);
        if (!bottle.func_190926_b()) {
            ItemStack honeyBottle = new ItemStack((IItemProvider)Items.field_226638_pX_);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)maidAvailableInv, (ItemStack)honeyBottle, (boolean)true);
            if (!result.func_190926_b()) {
                return;
            }
            bottle.func_190918_g(1);
            level.func_184148_a(null, maid.func_226277_ct_(), maid.func_226278_cu_(), maid.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            ItemHandlerHelper.insertItemStacked((IItemHandler)maidAvailableInv, (ItemStack)honeyBottle, (boolean)false);
            this.resetHoneyLevel((World)level, hiveBlockState, hivePos);
            maid.func_184609_a(Hand.MAIN_HAND);
        }
    }

    private boolean collectHoneyComb(ServerWorld level, EntityMaid maid, CombinedInvWrapper maidAvailableInv, BlockState hiveBlockState, BlockPos hivePos) {
        boolean hasShears;
        boolean bl = hasShears = maid.func_184614_ca().func_77973_b() == Items.field_151097_aZ;
        if (hasShears) {
            ItemStack honeyComb = new ItemStack((IItemProvider)Items.field_226635_pU_, 3);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)maidAvailableInv, (ItemStack)honeyComb, (boolean)true);
            if (!result.func_190926_b()) {
                return false;
            }
            level.func_184148_a(null, maid.func_226277_ct_(), maid.func_226278_cu_(), maid.func_226281_cx_(), SoundEvents.field_226133_ah_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            ItemHandlerHelper.insertItemStacked((IItemHandler)maidAvailableInv, (ItemStack)honeyComb, (boolean)false);
            this.resetHoneyLevel((World)level, hiveBlockState, hivePos);
            maid.func_184609_a(Hand.MAIN_HAND);
            maid.func_184614_ca().func_222118_a(1, (LivingEntity)maid, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
            return true;
        }
        return false;
    }

    @Nullable
    private BlockPos findBeehive(ServerWorld world, EntityMaid maid) {
        BlockPos blockPos = maid.getBrainSearchPos();
        PointOfInterestManager poiManager = world.func_217443_B();
        int range = (int)maid.func_213391_dJ();
        return poiManager.func_219146_b(type -> type == PointOfInterestType.field_226356_s_ || type == PointOfInterestType.field_226357_t_, blockPos, range, PointOfInterestManager.Status.ANY).map(PointOfInterest::func_218261_f).filter(pos -> this.canCollectHoney(world, (BlockPos)pos)).min(Comparator.comparingDouble(pos -> pos.func_177951_i((Vector3i)maid.func_233580_cy_()))).orElse(null);
    }

    private boolean canCollectHoney(ServerWorld world, BlockPos hivePos) {
        return (Integer)world.func_180495_p(hivePos).func_177229_b((Property)BeehiveBlock.field_226873_c_) >= 5;
    }

    public void resetHoneyLevel(World level, BlockState state, BlockPos pos) {
        level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BeehiveBlock.field_226873_c_, (Comparable)Integer.valueOf(0)), 3);
    }
}

