/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidMoveToBlockTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidFarmMoveTask
extends MaidMoveToBlockTask {
    private final NonNullList<ItemStack> seeds = NonNullList.func_191196_a();
    private final IFarmTask task;

    public MaidFarmMoveTask(IFarmTask task, float movementSpeed) {
        super(movementSpeed);
        this.task = task;
    }

    protected void start(ServerWorld worldIn, EntityMaid entityIn, long gameTimeIn) {
        this.seeds.clear();
        CombinedInvWrapper inv = entityIn.getAvailableInv(true);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!this.task.isSeed(stack)) continue;
            this.seeds.add((Object)stack);
        }
        this.searchForDestination(worldIn, entityIn);
    }

    @Override
    protected boolean shouldMoveTo(ServerWorld worldIn, EntityMaid maid, BlockPos basePos) {
        BlockState cropState;
        BlockPos above2Pos;
        BlockState stateUp2;
        if (this.task.checkCropPosAbove() && !(stateUp2 = worldIn.func_180495_p(above2Pos = basePos.func_177981_b(2))).func_196952_d((IBlockReader)worldIn, above2Pos).func_197766_b()) {
            return false;
        }
        BlockPos cropPos = basePos.func_177984_a();
        if (this.task.canHarvest(maid, cropPos, cropState = worldIn.func_180495_p(cropPos))) {
            return true;
        }
        BlockState baseState = worldIn.func_180495_p(basePos);
        return this.seeds.stream().anyMatch(seed -> this.task.canPlant(maid, basePos, baseState, (ItemStack)seed));
    }
}

