/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidFarmPlantTask
extends Task<EntityMaid> {
    private final IFarmTask task;

    public MaidFarmPlantTask(IFarmTask task) {
        super((Map)ImmutableMap.of((Object)InitEntities.TARGET_POS.get(), (Object)MemoryModuleStatus.VALUE_PRESENT));
        this.task = task;
    }

    protected boolean checkExtraStartConditions(ServerWorld worldIn, EntityMaid owner) {
        Brain<EntityMaid> brain = owner.func_213375_cj();
        return brain.func_218207_c((MemoryModuleType)InitEntities.TARGET_POS.get()).map(targetPos -> {
            Vector3d targetV3d = targetPos.func_220609_b();
            if (owner.func_195048_a(targetV3d) > Math.pow(this.task.getCloseEnoughDist(), 2.0)) {
                Optional walkTarget = brain.func_218207_c(MemoryModuleType.field_220950_k);
                if (!walkTarget.isPresent() || !((WalkTarget)walkTarget.get()).func_220966_a().func_220609_b().equals((Object)targetV3d)) {
                    brain.func_218189_b((MemoryModuleType)InitEntities.TARGET_POS.get());
                }
                return false;
            }
            return true;
        }).orElse(false);
    }

    protected void start(ServerWorld world, EntityMaid maid, long gameTimeIn) {
        maid.func_213375_cj().func_218207_c((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(posWrapper -> {
            BlockPos basePos = posWrapper.func_220608_a();
            BlockPos cropPos = basePos.func_177984_a();
            BlockState cropState = world.func_180495_p(cropPos);
            if (maid.canDestroyBlock(cropPos) && this.task.canHarvest(maid, cropPos, cropState)) {
                this.task.harvest(maid, cropPos, cropState);
                maid.func_184609_a(Hand.MAIN_HAND);
                maid.func_213375_cj().func_218189_b((MemoryModuleType)InitEntities.TARGET_POS.get());
                maid.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
            }
            CombinedInvWrapper availableInv = maid.getAvailableInv(true);
            List<Integer> slots = ItemsUtil.getFilterStackSlots((IItemHandler)availableInv, this.task::isSeed);
            if (!slots.isEmpty()) {
                for (int slot : slots) {
                    ItemStack seed = availableInv.getStackInSlot(slot);
                    BlockState baseState = world.func_180495_p(basePos);
                    if (!this.task.canPlant(maid, basePos, baseState, seed)) continue;
                    ItemStack remain = this.task.plant(maid, basePos, baseState, seed);
                    availableInv.setStackInSlot(slot, remain);
                    maid.func_184609_a(Hand.MAIN_HAND);
                    maid.func_213375_cj().func_218189_b((MemoryModuleType)InitEntities.TARGET_POS.get());
                    maid.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
                    return;
                }
            }
        });
    }
}

