/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManger;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;

public class MaidFeedAnimalTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 12;
    private final float speedModifier;
    private final int maxAnimalCount;
    private AnimalEntity feedEntity = null;

    public MaidFeedAnimalTask(float speedModifier, int maxAnimalCount) {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of((Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.maxAnimalCount = maxAnimalCount;
        this.setMaxCheckRate(12);
    }

    protected void start(ServerWorld worldIn, EntityMaid maid, long gameTimeIn) {
        this.feedEntity = null;
        long animalCount = this.getEntities(maid).stream().filter(e -> maid.func_213389_a(e.func_233580_cy_())).filter(Entity::func_70089_S).filter(e -> e instanceof AnimalEntity).count();
        if (animalCount < (long)this.maxAnimalCount) {
            this.getEntities(maid).stream().filter(e -> maid.func_213389_a(e.func_233580_cy_())).filter(Entity::func_70089_S).filter(e -> e instanceof AnimalEntity).filter(e -> ((AnimalEntity)e).func_70874_b() == 0).filter(e -> ((AnimalEntity)e).func_204701_dC()).filter(e -> ItemsUtil.isStackIn((IItemHandler)maid.getAvailableInv(false), arg_0 -> ((AnimalEntity)((AnimalEntity)e)).func_70877_b(arg_0))).filter(maid::canPathReach).findFirst().ifPresent(e -> {
                this.feedEntity = (AnimalEntity)e;
                BrainUtil.func_233860_a_((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)0);
            });
            if (this.feedEntity != null && this.feedEntity.func_233562_a_((Entity)maid, 2.0)) {
                ItemStack food = ItemsUtil.getStack((IItemHandler)maid.getAvailableInv(false), arg_0 -> ((AnimalEntity)this.feedEntity).func_70877_b(arg_0));
                if (!food.func_190926_b()) {
                    food.func_190918_g(1);
                    maid.func_184609_a(Hand.MAIN_HAND);
                    this.feedEntity.func_146082_f(null);
                }
                this.feedEntity = null;
            }
        } else {
            ChatBubbleManger.addInnerChatText(maid, "chat_bubble.touhou_little_maid.inner.feed_animal.max_number");
        }
    }

    private List<LivingEntity> getEntities(EntityMaid maid) {
        return maid.func_213375_cj().func_218207_c(MemoryModuleType.field_220946_g).orElse(Lists.newArrayList());
    }
}

