/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFeedTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidFeedOwnerTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 20;
    private final IFeedTask task;
    private final float walkSpeed;
    private final int closeEnoughDist;

    public MaidFeedOwnerTask(IFeedTask task, int closeEnoughDist, float walkSpeed) {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT));
        this.task = task;
        this.walkSpeed = walkSpeed;
        this.closeEnoughDist = closeEnoughDist;
        this.setMaxCheckRate(20);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerWorld worldIn, EntityMaid maid) {
        if (super.checkExtraStartConditions(worldIn, maid)) {
            LivingEntity owner = maid.func_70902_q();
            if (owner instanceof PlayerEntity && owner.func_70089_S() && maid.func_213389_a(owner.func_233580_cy_())) {
                if (owner.func_233562_a_((Entity)maid, (double)this.closeEnoughDist)) {
                    return true;
                }
                BrainUtil.func_233860_a_((LivingEntity)maid, (Entity)owner, (float)this.walkSpeed, (int)1);
            }
            return false;
        }
        return false;
    }

    protected void start(ServerWorld worldIn, EntityMaid maid, long gameTimeIn) {
        LivingEntity owner = maid.func_70902_q();
        if (owner instanceof PlayerEntity && owner.func_70089_S()) {
            PlayerEntity player = (PlayerEntity)owner;
            boolean dying = player.func_110143_aJ() / player.func_110138_aP() < 0.5f;
            IntArrayList lowestFoods = new IntArrayList();
            IntArrayList lowFoods = new IntArrayList();
            IntArrayList highFoods = new IntArrayList();
            CombinedInvWrapper inv = maid.getAvailableInv(true);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (!this.task.isFood(stack, player)) continue;
                IFeedTask.Priority priority = this.task.getPriority(stack, player);
                if (priority == IFeedTask.Priority.HIGH) {
                    highFoods.add(i);
                    break;
                }
                if (priority == IFeedTask.Priority.LOW) {
                    lowFoods.add(i);
                    break;
                }
                if (!dying || priority != IFeedTask.Priority.LOWEST) continue;
                lowestFoods.add(i);
                break;
            }
            if (highFoods.isEmpty() && lowFoods.isEmpty() && lowestFoods.isEmpty()) {
                return;
            }
            IntArrayList map = !highFoods.isEmpty() ? highFoods : (!lowFoods.isEmpty() ? lowFoods : lowestFoods);
            map.stream().skip(maid.func_70681_au().nextInt(map.size())).findFirst().ifPresent(slot -> {
                inv.setStackInSlot(slot.intValue(), this.task.feed(inv.getStackInSlot(slot.intValue()), player));
                maid.func_184609_a(Hand.MAIN_HAND);
                this.setNextCheckTickCount(5);
            });
        }
    }
}

