/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkAndSwimNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;

public class MaidFollowOwnerTask
extends Task<EntityMaid> {
    private static final int MAX_TELEPORT_ATTEMPTS_TIMES = 10;
    private final float speedModifier;
    private final int stopDistance;

    public MaidFollowOwnerTask(float speedModifier, int stopDistance) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.REGISTERED));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    protected void start(ServerWorld worldIn, EntityMaid maid, long gameTimeIn) {
        LivingEntity owner = maid.func_70902_q();
        int startDistance = (int)maid.func_213391_dJ() - 2;
        int minTeleportDistance = startDistance + 4;
        if (this.ownerStateConditions(owner) && this.maidStateConditions(maid) && !maid.func_233562_a_((Entity)owner, startDistance)) {
            if (!maid.func_233562_a_((Entity)owner, minTeleportDistance)) {
                this.teleportToOwner(maid, owner);
            } else if (!this.ownerIsWalkTarget(maid, owner)) {
                BrainUtil.func_233860_a_((LivingEntity)maid, (Entity)owner, (float)this.speedModifier, (int)this.stopDistance);
            }
        }
    }

    private void teleportToOwner(EntityMaid maid, LivingEntity owner) {
        BlockPos blockPos = owner.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            int x = this.randomIntInclusive(maid.func_70681_au(), -3, 3);
            int y = this.randomIntInclusive(maid.func_70681_au(), -1, 1);
            int z = this.randomIntInclusive(maid.func_70681_au(), -3, 3);
            if (!this.maybeTeleportTo(maid, owner, blockPos.func_177958_n() + x, blockPos.func_177956_o() + y, blockPos.func_177952_p() + z)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(EntityMaid maid, LivingEntity owner, int x, int y, int z) {
        if (this.teleportTooClosed(owner, x, z)) {
            return false;
        }
        if (!this.canTeleportTo(maid, new BlockPos(x, y, z))) {
            return false;
        }
        maid.func_70012_b((double)x + 0.5, y, (double)z + 0.5, maid.field_70177_z, maid.field_70125_A);
        maid.func_70661_as().func_75499_g();
        maid.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        maid.func_213375_cj().func_218189_b(MemoryModuleType.field_220951_l);
        maid.func_213375_cj().func_218189_b(MemoryModuleType.field_234103_o_);
        maid.func_213375_cj().func_218189_b(MemoryModuleType.field_220954_o);
        return true;
    }

    private boolean teleportTooClosed(LivingEntity owner, int x, int z) {
        return Math.abs((double)x - owner.func_226277_ct_()) < 2.0 && Math.abs((double)z - owner.func_226281_cx_()) < 2.0;
    }

    private boolean canTeleportTo(EntityMaid maid, BlockPos pos) {
        PathNodeType pathNodeType = WalkAndSwimNodeProcessor.func_237231_a_((IBlockReader)maid.field_70170_p, (BlockPos.Mutable)pos.func_239590_i_());
        if (pathNodeType == PathNodeType.WALKABLE) {
            BlockPos blockPos = pos.func_177973_b((Vector3i)maid.func_233580_cy_());
            return maid.field_70170_p.func_226665_a__((Entity)maid, maid.func_174813_aQ().func_186670_a(blockPos));
        }
        return false;
    }

    private int randomIntInclusive(Random random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    private boolean maidStateConditions(EntityMaid maid) {
        return !maid.isHomeModeEnable() && maid.canBrainMoving();
    }

    private boolean ownerStateConditions(@Nullable LivingEntity owner) {
        return owner != null && !owner.func_175149_v() && !owner.func_233643_dh_();
    }

    private boolean ownerIsWalkTarget(EntityMaid maid, LivingEntity owner) {
        return maid.func_213375_cj().func_218207_c(MemoryModuleType.field_220950_k).map(target -> {
            if (target.func_220966_a() instanceof EntityPosWrapper) {
                return ((EntityPosWrapper)target.func_220966_a()).field_220611_a.equals((Object)owner);
            }
            return false;
        }).orElse(false);
    }
}

